/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.analysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.cbio.causality.analysis.Graph;

public class ShortestDistanceReporter {
    public static Map<String, Map<String, Integer>> getShortestDistances(Graph graph, int limit) {
        HashMap<String, Map<String, Integer>> dist = new HashMap<String, Map<String, Integer>>();
        for (String source : graph.getSymbols()) {
            for (int i = 1; i <= limit; ++i) {
                Set<String> dw = graph.getDownstream(Collections.singleton(source), i);
                for (String target : dw) {
                    if (!dist.containsKey(source)) {
                        dist.put(source, new HashMap());
                    }
                    if (((Map)dist.get(source)).containsKey(target)) continue;
                    ((Map)dist.get(source)).put(target, i);
                }
            }
        }
        return dist;
    }

    public static void writeShortestDistances(Graph graph, int limit, String filename) throws IOException {
        Map<String, Map<String, Integer>> dist = ShortestDistanceReporter.getShortestDistances(graph, limit);
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        for (String source : dist.keySet()) {
            for (String target : dist.get(source).keySet()) {
                writer.write(source + "\t" + target + "\t" + dist.get(source).get(target) + "\n");
            }
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        Graph graph = new Graph("PERA", "is-upstream-of");
        Scanner sc = new Scanner(new File("/home/ozgun/Downloads/prior_network.tsv"));
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            graph.putRelation(token[0], token[2], true);
        }
        graph.printStats();
        ShortestDistanceReporter.writeShortestDistances(graph, 10, "/home/ozgun/Downloads/distances.txt");
    }
}

