/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.binintanalysis;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.data.portal.BroadAccessor;
import org.cbio.causality.network.PathwayCommons;
import org.cbio.causality.network.SPIKE;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;
import org.cbio.causality.util.FormatUtil;

public class AffectedNetworkFinder {
    private Graph trav;
    private int totalSymbolSize;
    private String study;
    private double fdrThr;
    Set<String> mutsig;

    public static void main(String[] args) throws IOException {
        AffectedNetworkFinder anf = new AffectedNetworkFinder("COADREAD", 0.05, 0.25);
        Map<String, Double> pvals = anf.calcPvals();
        anf.writeNetwork(pvals, "/home/ozgun/Desktop/temp.sif");
    }

    public AffectedNetworkFinder(String study, double mutsigThr, double fdrThr) {
        this.study = study;
        this.loadNetwork();
        this.mutsig = BroadAccessor.getMutsigGenes(study, mutsigThr, true);
        this.mutsig.retainAll(this.trav.getSymbols());
        System.out.println("mutsig in network = " + this.mutsig.size());
        this.fdrThr = fdrThr;
    }

    public Map<String, Double> calcPvals() {
        HashMap<String, Double> scores = new HashMap<String, Double>();
        for (String sym : this.trav.getSymbols()) {
            double pv = this.calcUpstreamEnrichmentPval(sym, 1);
            scores.put(sym, pv);
        }
        return scores;
    }

    private double calcUpstreamEnrichmentPval(String symbol, int depth) {
        double minPval = 1.0;
        for (int i = 0; i < depth; ++i) {
            Set<String> up = this.collectUpstream(symbol, i + 1);
            int cnt = 0;
            for (String s : up) {
                if (!this.mutsig.contains(s)) continue;
                ++cnt;
            }
            double pval = FishersExactTest.calcEnrichmentPval(this.totalSymbolSize, this.mutsig.size(), up.size(), cnt);
            if (!(pval < minPval)) continue;
            minPval = pval;
        }
        return minPval;
    }

    private Set<String> collectUpstream(String sym, int depth) {
        HashSet<String> up = new HashSet<String>(this.trav.getUpstream(sym));
        HashSet<String> newG = new HashSet<String>(up);
        for (int i = 1; i < depth; ++i) {
            Set<String> newUp = this.trav.getUpstream((Set<String>)newG);
            newUp.removeAll(newG);
            newG.clear();
            newG.addAll(newUp);
            newG.removeAll(up);
            up.addAll(newUp);
        }
        return up;
    }

    private void loadNetwork() {
        this.trav = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF);
        this.trav.merge(SPIKE.getGraphPostTl());
        this.totalSymbolSize = this.trav.getSymbols().size();
    }

    private void writeNetwork(Map<String, Double> pvals, String outFile) throws IOException {
        ArrayList<String> selected = new ArrayList<String>(FDR.select(pvals, null, this.fdrThr));
        System.out.println("selected.size() = " + selected.size());
        for (String gene : selected) {
            System.out.println(gene + "\t" + FormatUtil.roundToSignificantDigits(pvals.get(gene), 2));
        }
        selected.addAll(this.mutsig);
        this.writeNetwork(selected, outFile, pvals);
    }

    private void writeNetwork(Collection<String> selected, String filename, Map<String, Double> pvals) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        for (String s : selected) {
            for (String dw : this.trav.getDownstream(s)) {
                if (!selected.contains(dw)) continue;
                writer.write(s + "\t" + SIFEnum.CONTROLS_STATE_CHANGE_OF.getTag() + "\t" + dw + "\n");
            }
        }
        writer.close();
        writer = new BufferedWriter(new FileWriter(filename.substring(0, filename.lastIndexOf(".")) + ".format"));
        for (String s : selected) {
            if (!pvals.containsKey(s)) continue;
            writer.write("node\t" + s + "\tcolor\t255 255 255\n");
            if (!this.mutsig.contains(s)) continue;
            writer.write("node\t" + s + "\thighlight\ton\n");
        }
        writer.close();
    }

    private int getColorOfScore(double val, double max) {
        return 255 - (int)Math.round(val / max * 255.0);
    }

    private double maxScore(Map<String, Double> scores) {
        double max = -1.0;
        for (Double score : scores.values()) {
            if (!(score > max)) continue;
            max = score;
        }
        return max;
    }
}

