/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.binintanalysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math.stat.correlation.PearsonsCorrelation;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.ComponentSorter;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.binintanalysis.Dataset1;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.ExpDataManager;
import org.cbio.causality.network.PathwayCommons;

public class CorrelatedComponentFinder {
    private Graph graph;
    private Dataset1 dataset;
    CBioPortalAccessor portalAcc;
    ExpDataManager expMan;
    Map<String, Map<String, Double>> correlations;
    Map<String, Map<String, Double>> expSigPvals;
    Map<String, Map<String, Double>> enrichSigPvals;
    Map<String, List<Set<String>>> compsPos;
    Map<String, List<Set<String>>> compsNeg;
    double fdrThr;
    int componentSizeThr;
    private static final int MIN_GROUP_SIZE = 1;
    private static final PearsonsCorrelation COR = new PearsonsCorrelation();

    public static void main(String[] args) throws IOException {
        CorrelatedComponentFinder finder = new CorrelatedComponentFinder(Dataset1.UCEC, 0.05, 2);
        finder.calcCorrelations();
        finder.calcComponents();
        finder.writeComponents();
    }

    public CorrelatedComponentFinder(Dataset1 dataset, double fdrThr, int componentSizeThr) throws IOException {
        this.dataset = dataset;
        this.fdrThr = fdrThr;
        this.componentSizeThr = componentSizeThr;
        this.loadNetwork();
        this.loadData();
    }

    private void loadNetwork() {
        this.graph = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF);
    }

    private void loadData() throws IOException {
        this.portalAcc = new CBioPortalAccessor(this.dataset.mutCnCallExpZ);
        this.expMan = new ExpDataManager(this.portalAcc.getGeneticProfileById(this.dataset.exp.getProfileID()[0]), this.portalAcc.getCaseListById(this.dataset.exp.getCaseListID()));
    }

    private double calcCorrelation(String g1, String g2) {
        double[] e1 = this.expMan.get(g1);
        double[] e2 = this.expMan.get(g2);
        return COR.correlation(e1, e2);
    }

    public void calcCorrelations() {
        this.correlations = new HashMap<String, Map<String, Double>>();
        this.expSigPvals = new HashMap<String, Map<String, Double>>();
        for (String g1 : this.graph.getSymbols()) {
            if (!this.correlations.containsKey(g1)) {
                this.correlations.put(g1, new HashMap());
            }
            for (String g2 : this.graph.getNeighbors(g1)) {
                double cor;
                if (this.correlations.get(g1).containsKey(g2) || Double.isNaN(cor = this.calcCorrelation(g1, g2))) continue;
                this.correlations.get(g1).put(g2, cor);
                if (!this.correlations.containsKey(g2)) {
                    this.correlations.put(g2, new HashMap());
                }
                this.correlations.get(g2).put(g1, cor);
            }
        }
    }

    public void calcComponents() {
        this.compsPos = new HashMap<String, List<Set<String>>>();
        this.compsNeg = new HashMap<String, List<Set<String>>>();
        for (String mut : this.enrichSigPvals.keySet()) {
            HashSet<String> up = new HashSet<String>();
            HashSet<String> dw = new HashSet<String>();
            for (String target : this.enrichSigPvals.get(mut).keySet()) {
            }
            ComponentSorter sorter = new ComponentSorter(up, this.graph);
            List<Set<String>> components = sorter.getComponents(this.componentSizeThr);
            if (!components.isEmpty()) {
                this.compsPos.put(mut, components);
            }
            if ((components = (sorter = new ComponentSorter(dw, this.graph)).getComponents(this.componentSizeThr)).isEmpty()) continue;
            this.compsNeg.put(mut, components);
        }
        HashSet<String> resultGeneratingMuts = new HashSet<String>(this.compsPos.keySet());
        resultGeneratingMuts.addAll(this.compsNeg.keySet());
        System.out.println("Result generated for " + resultGeneratingMuts.size() + " mutators");
    }

    public void writeComponents() throws IOException {
        this.writeComponents(this.compsPos, "-up");
        this.writeComponents(this.compsNeg, "-dw");
    }

    public void writeComponents(Map<String, List<Set<String>>> comps, String add) throws IOException {
        String dir = "temp/components/";
        new File(dir).mkdirs();
        for (String mut : comps.keySet()) {
            if (comps.get(mut).isEmpty()) continue;
            BufferedWriter w1 = new BufferedWriter(new FileWriter(dir + mut + add + ".sif"));
            BufferedWriter w2 = new BufferedWriter(new FileWriter(dir + mut + add + ".format"));
            for (Set<String> comp : comps.get(mut)) {
                for (String g1 : comp) {
                    Set<String> neighs = this.graph.isDirected() ? this.graph.getDownstream(g1) : this.graph.getNeighbors(g1);
                    for (String g2 : comp) {
                        if (this.graph.isUndirected() && g2.compareTo(g1) < 0 || !neighs.contains(g2)) continue;
                        w1.write(g1 + "\t" + this.graph.getEdgeType() + "\t" + g2 + "\n");
                    }
                }
            }
            w1.close();
            w2.close();
        }
    }

    private String val2Color(double pval, int type) {
        double score = Math.min(10.0, -Math.log(pval));
        int v = 255 - (int)Math.round(25.5 * score);
        switch (type) {
            case 1: {
                return "255 " + v + " " + v;
            }
            case -1: {
                return v + " 255 " + v;
            }
        }
        throw new IllegalArgumentException();
    }
}

