/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.binintanalysis;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.BranchDataProvider;
import org.cbio.causality.analysis.CNVerifier;
import org.cbio.causality.analysis.DownstreamTree;
import org.cbio.causality.analysis.GeneBranch;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.analysis.RadialInfluenceTree;
import org.cbio.causality.binintanalysis.Dataset1;
import org.cbio.causality.data.portal.BroadAccessor;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.ExpDataManager;
import org.cbio.causality.model.Alteration;
import org.cbio.causality.model.AlterationPack;
import org.cbio.causality.model.Change;
import org.cbio.causality.network.PathwayCommons;
import org.cbio.causality.network.SPIKE;
import org.cbio.causality.network.SignaLink;
import org.cbio.causality.util.CollectionUtil;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersCombinedProbability;
import org.cbio.causality.util.Progress;
import org.cbio.causality.util.StudentsT;
import org.cbio.causality.util.Summary;

public class InfluentialMutatorFinder {
    private static final Set<String> focusExp = null;
    private static final Set<String> focusMut = null;
    private static final String dir = "binint/InfluentialMutatorFinder/";
    private Graph travSt;
    private Graph travExp;
    private Dataset1 dataset;
    private CBioPortalAccessor portalAcc;
    private ExpDataManager expMan;
    private Map<String, List<String>> downstream;
    private Map<String, List<String>> affectedDw;
    private int depth;
    Set<String> mutsig;
    double fdrThr;
    private static final boolean LIMIT_TO_MUTSIG = false;
    private static final boolean ADD_CN_TO_MUT = false;
    private static final int MIN_GROUP_SIZE = 3;
    private static final double MIN_MUT_RATIO = 0.01;

    public static void main(String[] args) throws IOException {
        Dataset1 dataset = Dataset1.BRCA;
        int depth = 1;
        double fdrThr = 0.05;
        System.out.println("depth = " + depth);
        Graph graphSt = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF);
        Graph graphExp = PathwayCommons.getGraph(SIFEnum.CONTROLS_EXPRESSION_OF);
        InfluentialMutatorFinder finder = new InfluentialMutatorFinder(graphSt, graphExp, dataset, depth, fdrThr);
        List<String> resPC = finder.find();
        graphSt = SPIKE.getGraphPostTl();
        graphExp = SPIKE.getGraphTR();
        finder = new InfluentialMutatorFinder(graphSt, graphExp, dataset, depth, fdrThr);
        List<String> resSpike = finder.find();
        graphSt = SignaLink.getGraphPostTl();
        graphExp = SignaLink.getGraphTR();
        finder = new InfluentialMutatorFinder(graphSt, graphExp, dataset, depth, fdrThr);
        List<String> resSignalink = finder.find();
        CollectionUtil.printVennCounts(resPC, resSpike, resSignalink);
    }

    public List<String> find() throws IOException {
        final Map<String, List<String>> affected = this.calcAffectedDownstream();
        System.out.println("mutators = " + affected.size());
        ArrayList<String> result = new ArrayList<String>(affected.keySet());
        ArrayList<String> mutators = new ArrayList<String>(affected.keySet());
        Collections.sort(mutators, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return new Integer(((List)affected.get(o2)).size()).compareTo(((List)affected.get(o1)).size());
            }
        });
        for (String mutator : mutators) {
            System.out.println(mutator + "\t" + affected.get(mutator).size());
        }
        System.out.println("pairs size = " + result.size());
        return result;
    }

    public InfluentialMutatorFinder(Graph travSt, Graph travExp, Dataset1 dataset, int depth, double fdrThr) throws IOException {
        this.travSt = travSt;
        this.travExp = travExp;
        this.dataset = dataset;
        this.depth = depth;
        this.fdrThr = fdrThr;
        this.loadData();
    }

    private void loadData() throws IOException {
        this.portalAcc = new CBioPortalAccessor(this.dataset.mutCnCallExpZ);
        this.expMan = new ExpDataManager(this.portalAcc.getGeneticProfileById(this.dataset.exp.getProfileID()[0]), this.portalAcc.getCaseListById(this.dataset.exp.getCaseListID()));
        this.portalAcc.setCnVerifier(new CNVerifier(this.expMan, 0.05));
        this.mutsig = BroadAccessor.getMutsigGenes(this.dataset.code(), 0.05, true);
    }

    private List<String> compareMutSig(List<String> list, boolean intersect) {
        ArrayList<String> select = new ArrayList<String>(list);
        if (intersect) {
            select.retainAll(this.mutsig);
        } else {
            select.removeAll(this.mutsig);
        }
        return select;
    }

    private boolean[] selectSubset(String symbol, boolean mutated) {
        AlterationPack alts = this.portalAcc.getAlterations(symbol);
        Change[] muts = alts.get(Alteration.MUTATION);
        Change[] cncs = alts.get(Alteration.COPY_NUMBER);
        Change[] expz = alts.get(Alteration.EXPRESSION);
        boolean[] x = new boolean[alts.getSize()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (mutated ? muts[i].isAltered() : muts[i] == Change.NO_CHANGE) && cncs[i] == Change.NO_CHANGE && expz[i] == Change.NO_CHANGE;
        }
        return x;
    }

    private double calcDiffPval(String symbol, boolean[] set1, boolean[] set2) {
        double[] exp = this.expMan.get(symbol);
        if (exp == null) {
            return Double.NaN;
        }
        boolean[] cnUnchanged = this.getCopyNumberUnchanged(symbol);
        if (cnUnchanged == null) {
            return Double.NaN;
        }
        double[] vals1 = this.getSubset(exp, set1, cnUnchanged);
        double[] vals2 = this.getSubset(exp, set2, cnUnchanged);
        if (vals1.length < 3 || vals2.length < 3) {
            return Double.NaN;
        }
        return StudentsT.getPValOfMeanDifference(vals1, vals2);
    }

    private boolean getChangeDirection(String symbol, boolean[] set1, boolean[] set2) {
        double[] exp = this.expMan.get(symbol);
        if (exp == null) {
            return false;
        }
        boolean[] cnUnchanged = this.getCopyNumberUnchanged(symbol);
        if (cnUnchanged == null) {
            return false;
        }
        double[] vals1 = this.getSubset(exp, set1, cnUnchanged);
        double[] vals2 = this.getSubset(exp, set2, cnUnchanged);
        if (vals1.length < 3 || vals2.length < 3) {
            return false;
        }
        return Summary.calcChangeOfMean(vals1, vals2) > 0.0;
    }

    private double[] getSubset(double[] vals, boolean[] inds, boolean[] cnUnchanged) {
        ArrayList<Double> list = new ArrayList<Double>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            if (!inds[i] || !cnUnchanged[i] || Double.isNaN(vals[i])) continue;
            list.add(vals[i]);
        }
        double[] sub = new double[list.size()];
        for (int i = 0; i < sub.length; ++i) {
            sub[i] = (Double)list.get(i);
        }
        return sub;
    }

    private Map<String, Double> getExpressionPvals(String mut, boolean[] set1, boolean[] set2) {
        Set<String> downstr = this.getDownstream(mut);
        if (focusExp != null) {
            downstr.retainAll(focusExp);
        }
        return this.getExpressionPvals(downstr, set1, set2);
    }

    private Map<String, Double> getExpressionPvals(Set<String> targets, boolean[] set1, boolean[] set2) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (String sym : targets) {
            double pval = this.calcDiffPval(sym, set1, set2);
            if (Double.isNaN(pval)) continue;
            if (pval == 0.0) {
                pval = 1.0E-11;
            }
            map.put(sym, pval);
        }
        return map;
    }

    private Set<String> getDownstream(String mut) {
        HashSet<String> tfs = new HashSet<String>();
        tfs.add(mut);
        if (this.depth > 1) {
            tfs.addAll(this.travSt.getDownstream(tfs, this.depth - 1));
        }
        return this.travExp.getDownstream(tfs);
    }

    private boolean[] getCopyNumberUnchanged(String symbol) {
        AlterationPack alts = this.portalAcc.getAlterations(symbol);
        if (alts == null) {
            return null;
        }
        Change[] cnc = alts.get(Alteration.COPY_NUMBER);
        if (cnc == null) {
            return null;
        }
        boolean[] b = new boolean[cnc.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = !cnc[i].isAltered() && !cnc[i].isAbsent();
        }
        return b;
    }

    private boolean considerMutator(String symbol) {
        if (this.getDownstream(symbol).isEmpty()) {
            return false;
        }
        AlterationPack alts = this.portalAcc.getAlterations(symbol);
        if (alts == null) {
            return false;
        }
        if (alts.get(Alteration.MUTATION) == null) {
            return false;
        }
        if (alts.countAltered(Alteration.MUTATION) < 3) {
            return false;
        }
        if (alts.getAlteredRatio(Alteration.MUTATION) < 0.01) {
            return false;
        }
        if (alts.isAbsent(Alteration.COPY_NUMBER)) {
            return false;
        }
        return !alts.isAbsent(Alteration.EXPRESSION);
    }

    private double[] toDoubleArray(Map<String, Double> map) {
        double[] d = new double[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            d[i++] = map.get(key);
        }
        return d;
    }

    public Map<String, List<String>> calcAffectedDownstream() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        Set<String> symbols = this.travSt.getSymbols();
        symbols.addAll(this.travExp.getOneSideSymbols(true));
        if (focusMut != null) {
            symbols.retainAll(focusMut);
        }
        Progress prg = new Progress(symbols.size());
        for (String sym : symbols) {
            List<String> select;
            boolean[] mutated;
            boolean[] normal;
            Map<String, Double> pvals;
            prg.tick(sym);
            if (!this.considerMutator(sym) || (pvals = this.getExpressionPvals(sym, normal = this.selectSubset(sym, false), mutated = this.selectSubset(sym, true))).isEmpty() || (select = FDR.select(pvals, null, this.fdrThr)).isEmpty()) continue;
            result.put(sym, select);
        }
        return result;
    }

    private double calcPVal(String mut, Set<String> downs) {
        boolean[] normal = this.selectSubset(mut, false);
        boolean[] mutated = this.selectSubset(mut, true);
        Map<String, Double> pvals = this.getExpressionPvals(downs, normal, mutated);
        return FishersCombinedProbability.pValue(this.toDoubleArray(pvals));
    }

    private boolean calcChangeDirection(String mut, String target) {
        boolean[] normal = this.selectSubset(mut, false);
        boolean[] mutated = this.selectSubset(mut, true);
        return this.getChangeDirection(target, normal, mutated);
    }

    public void generateInfluenceGraphs(List<String> result) {
        DownstreamTree tree = new DownstreamTree(this.travSt, this.travExp, new BranchDataProvider(){

            @Override
            public Color getColor(String gene, String root) {
                double pval = InfluentialMutatorFinder.this.calcPVal(root, Collections.singleton(gene));
                String colS = InfluentialMutatorFinder.this.val2Color(pval, InfluentialMutatorFinder.this.calcChangeDirection(root, gene) ? 1 : -1);
                String[] c = colS.split(" ");
                return new Color(Integer.parseInt(c[0]), Integer.parseInt(c[1]), Integer.parseInt(c[2]));
            }

            @Override
            public double getThickness(GeneBranch branch, String root) {
                Set<String> dwstr = branch.getAllGenes();
                double cumPval = InfluentialMutatorFinder.this.calcPVal(root, dwstr);
                return Math.min(-Math.log(cumPval), 5.0);
            }
        });
        String dir = dir + this.dataset.name() + "/";
        File d = new File(dir);
        if (!d.exists()) {
            d.mkdirs();
        }
        assert (d.isDirectory());
        for (String mut : result) {
            GeneBranch g = tree.getTree(mut, (Collection<String>)this.downstream.get(mut), this.depth);
            g.trimToMajorPaths((Collection<String>)this.downstream.get(mut));
            if (!g.selectLeaves((Collection<String>)this.affectedDw.get(mut))) continue;
            if (!this.affectedDw.get(mut).isEmpty() && this.affectedDw.get(mut).size() < 6) {
                RadialInfluenceTree.write(g.copy(true), false, dir + mut + ".svg");
            }
            this.writeTree(g, dir);
        }
    }

    private void writeTree(GeneBranch tree, String dir) {
        try {
            BufferedWriter writer1 = new BufferedWriter(new FileWriter(dir + tree.gene + ".sif"));
            BufferedWriter writer2 = new BufferedWriter(new FileWriter(dir + tree.gene + ".format"));
            writer2.write("graph\tgrouping\ton\n");
            writer2.write("node\t" + tree.gene + "\tcolor\t255 255 200\n");
            this.writeBranches(tree.gene, tree, writer1, writer2);
            writer1.close();
            writer2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeBranches(String origTarget, GeneBranch branch, Writer writer1, Writer writer2) throws IOException {
        for (GeneBranch down : branch.branches) {
            this.writeSelf(origTarget, branch, down, writer1, writer2);
        }
    }

    private void writeSelf(String origTarget, GeneBranch currentParent, GeneBranch down, Writer writer1, Writer writer2) throws IOException {
        if (!down.isSelected()) {
            return;
        }
        String edgeTag = down.isLeaf() || this.travExp.getUpstream(down.gene).contains(currentParent) ? SIFEnum.CONTROLS_EXPRESSION_OF.getTag() : SIFEnum.CONTROLS_STATE_CHANGE_OF.getTag();
        writer1.write(currentParent.gene + "\t" + edgeTag + "\t" + down.gene + "\n");
        this.writeWeights(origTarget, currentParent, down, edgeTag, writer2);
        this.writeBranches(origTarget, down, writer1, writer2);
    }

    private void writeWeights(String orig, GeneBranch from, GeneBranch to, String edgeType, Writer writer) throws IOException {
        Set<String> dwstr = to.getAllGenes();
        dwstr.retainAll((Collection)this.downstream.get(orig));
        assert (!dwstr.isEmpty());
        double cumPval = this.calcPVal(orig, dwstr);
        boolean upreg = this.calcChangeDirection(orig, to.gene);
        String key = from.gene + " " + edgeType + " " + to.gene;
        writer.write("edge\t" + key + "\tcolor\t" + this.val2Color(cumPval, 0) + "\n");
        writer.write("edge\t" + key + "\twidth\t2\n");
        if (this.affectedDw.get(orig).contains(to.gene)) {
            double pval = this.calcPVal(orig, Collections.singleton(to.gene));
            writer.write("node\t" + to.gene + "\tcolor\t" + this.val2Color(pval, upreg ? 1 : -1) + "\n");
        } else {
            writer.write("node\t" + to.gene + "\tcolor\t255 255 255\n");
        }
    }

    private String val2Color(double pval, int type) {
        double score = Math.min(10.0, -Math.log(pval));
        int v = 255 - (int)Math.round(25.5 * score);
        switch (type) {
            case 0: {
                return v + " " + v + " " + v;
            }
            case 1: {
                return "255 " + v + " " + v;
            }
            case -1: {
                return v + " 255 " + v;
            }
        }
        throw new IllegalArgumentException();
    }
}

