/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.cocitation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IHOPSpider {
    private static final Log log = LogFactory.getLog(IHOPSpider.class);
    private String iHopURL;

    public IHOPSpider(String iHopURL) {
        this.iHopURL = iHopURL;
    }

    public Map<String, Integer> parseCocitations(String symbol) {
        String url = this.getGeneSearchURL(symbol);
        BufferedReader reader = IHOPSpider.getReader(url);
        try {
            String ID2 = this.getInternalID(reader, symbol);
            reader.close();
            if (ID2 == null) {
                log.error("Cannot find internal ID of " + symbol + ".");
                return null;
            }
            url = this.getGenePageURL(ID2);
            reader = IHOPSpider.getReader(url);
            return this.parseCocitations(reader);
        }
        catch (IOException e) {
            log.error("Cannot parse co-citations for " + symbol + ".", e);
            return null;
        }
    }

    private String getGeneSearchURL(String symbol) {
        return this.getiHopURL() + "/?field=synonym&ncbi_tax_id=9606&search=" + symbol;
    }

    private String getGenePageURL(String internalID) {
        return this.getiHopURL() + "/gs/" + internalID + ".html?list=1&page=1";
    }

    private static BufferedReader getReader(String url) {
        try {
            URL u = new URL(url);
            URLConnection con = u.openConnection();
            InputStream is = con.getInputStream();
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getInternalID(BufferedReader reader, String symbol) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            int index;
            if (line.startsWith("<TD nowrap=\"1\"") && (index = line.indexOf("doaction(null, ")) >= 0) {
                ids.add(line.substring(index + 15, line.lastIndexOf(", 1")));
            }
            if (line.equals("<B>" + symbol + "</B>") && (line = reader.readLine()).equals("</SYMBOL>") && (index = (line = reader.readLine()).indexOf("doaction(null, ")) >= 0) {
                return line.substring(index + 15, line.lastIndexOf(", 1"));
            }
            line = reader.readLine();
        }
        for (String id : ids) {
            String sym = this.getSymbolOfID(id);
            if (sym == null || !sym.equals(symbol)) continue;
            return id;
        }
        if (log.isWarnEnabled()) {
            log.warn("Cannot find internal ID of " + symbol);
        }
        return null;
    }

    private Map<String, Integer> parseCocitations(BufferedReader reader) throws IOException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("           hstore(new Array(\"type\", \"GENE\"")) {
                String symbol = line.substring(line.indexOf("symbol\", \"") + 10, line.indexOf("\", \"name"));
                String count = line.substring(line.lastIndexOf(" \"") + 2, line.lastIndexOf("\""));
                map.put(symbol, Integer.parseInt(count));
            }
            line = reader.readLine();
        }
        return map;
    }

    private String getSymbolOfID(String ID2) {
        String url = this.getGenePageURL(ID2);
        BufferedReader reader = IHOPSpider.getReader(url);
        try {
            return this.parseSymbol(reader);
        }
        catch (IOException e) {
            log.error("Error while extracting gene symbol.", e);
            return null;
        }
    }

    private String parseSymbol(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("<title>")) {
                String symbol = line.substring(line.indexOf("[ ") + 2, line.indexOf(" ]"));
                return symbol;
            }
            line = reader.readLine();
        }
        return null;
    }

    public String getiHopURL() {
        return this.iHopURL;
    }

    public void setiHopURL(String iHopURL) {
        this.iHopURL = iHopURL;
    }
}

