/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cbio.causality.data.portal.CBioPortalManager;
import org.cbio.causality.util.Waiter;

public class GeneCards {
    private static final Set<String> CANCER_KW = new HashSet<String>(Arrays.asList("cancer", "oma", "oplasm", "tumor"));
    private static final String NOT_ASSOCIATED_FILE = "not-associated.txt";

    public static String getCacheDir() {
        return CBioPortalManager.getCacheDir() + File.separator + "GeneCards" + File.separator;
    }

    public static Set<String> getRelatedCancers(String gene) {
        Set<String> cancers = GeneCards.readCancersFromCache(gene);
        if (cancers != null && cancers.isEmpty()) {
            return cancers;
        }
        if (cancers == null) {
            try {
                cancers = GeneCards.spiderCancers(gene);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        if (cancers != null) {
            if (cancers.isEmpty()) {
                GeneCards.writeNotAssociated(gene);
            } else {
                GeneCards.cacheCancers(gene, cancers);
            }
        }
        return cancers;
    }

    private static Set<String> readCancersFromCache(String gene) {
        Set<String> na = GeneCards.getNotAssociated();
        if (na.contains(gene)) {
            return Collections.emptySet();
        }
        String filename = GeneCards.getCacheDir() + gene + ".txt";
        if (new File(filename).exists()) {
            try {
                HashSet<String> set = new HashSet<String>();
                BufferedReader reader = new BufferedReader(new FileReader(filename));
                String line = reader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        set.add(line);
                    }
                    line = reader.readLine();
                }
                reader.close();
                return set;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static void cacheCancers(String gene, Set<String> cancers) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(GeneCards.getCacheDir() + gene + ".txt"));
            for (String cancer : cancers) {
                writer.write(cancer + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Set<String> getNotAssociated() {
        HashSet<String> genes = new HashSet<String>();
        try {
            String fileName = GeneCards.getCacheDir() + NOT_ASSOCIATED_FILE;
            if (new File(fileName).exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(fileName));
                String line = reader.readLine();
                while (line != null) {
                    if (!line.isEmpty()) {
                        genes.add(line);
                    }
                    line = reader.readLine();
                }
                reader.close();
            } else {
                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return genes;
    }

    private static void writeNotAssociated(String gene) {
        Set<String> set = GeneCards.getNotAssociated();
        set.add(gene);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(GeneCards.getCacheDir() + NOT_ASSOCIATED_FILE));
            for (String s : set) {
                writer.write(s + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Set<String> spiderCancers(String gene) {
        Waiter.pause(5000L);
        Set<String> cancers = new HashSet<String>();
        try {
            URL url = new URL("http://www.genecards.org/cgi-bin/carddisp.pl?gene=" + gene);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.addRequestProperty("User-Agent", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2");
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder content = null;
            String line = reader.readLine();
            while (line != null) {
                if (content == null && line.equals("<br ><h2 class=\"navbar\">Disorders ")) {
                    content = new StringBuilder();
                } else if (content != null) {
                    if (line.equals("\t<TR>")) {
                        cancers = GeneCards.parseCancers(content.toString());
                    } else {
                        content.append(line);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error during spidering.", e);
        }
        return cancers;
    }

    private static Set<String> parseCancers(String line) {
        HashSet<String> words = new HashSet<String>();
        int i = 0;
        block0: while (i >= 0 && i < line.length() - 1) {
            int j;
            if ((i = line.indexOf(">", i + 1)) < 0 || (j = line.indexOf("<", i + 1)) <= 0) continue;
            String word = line.substring(i + 1, j);
            word = word.toLowerCase();
            for (String kw : CANCER_KW) {
                if (!word.endsWith(kw)) continue;
                words.add(word);
                continue block0;
            }
        }
        return words;
    }

    public static void main(String[] args) {
        String[] genes;
        for (String gene : genes = "DTNA DYTN UTRN DTNB DRP2".split(" ")) {
            if (gene.isEmpty()) continue;
            System.out.print("\n" + gene + ":");
            for (String disease : GeneCards.getRelatedCancers(gene)) {
                System.out.print(" " + disease + ",");
            }
        }
    }

    static {
        File dir = new File(GeneCards.getCacheDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

