/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.drug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class DrugData {
    private static Map<String, Set<String>> drug2target;
    private static Map<String, Set<String>> target2drug;
    private static Map<String, String> description;
    private static Set<String> fdaApproved;
    private static Set<String> cancerDrug;
    private static Set<String> nutraceutical;

    public static Set<String> getDrugs(String target) {
        if (!target2drug.containsKey(target)) {
            return Collections.emptySet();
        }
        return target2drug.get(target);
    }

    public static Set<String> getTargets(String drug) {
        if (!drug2target.containsKey(drug)) {
            return Collections.emptySet();
        }
        return drug2target.get(drug);
    }

    public static boolean isFDAApproved(String drug) {
        return fdaApproved.contains(drug);
    }

    public static boolean isCancerDrug(String drug) {
        return cancerDrug.contains(drug);
    }

    public static boolean isNutraceutical(String drug) {
        return nutraceutical.contains(drug);
    }

    public static String getDescription(String drug) {
        return description.get(drug);
    }

    public static Set<String> getFDAApprovedDrugs(String target) {
        HashSet<String> drugs = new HashSet<String>(DrugData.getDrugs(target));
        drugs.retainAll(fdaApproved);
        return drugs;
    }

    public static Set<String> getCancerDrugs(String target) {
        HashSet<String> drugs = new HashSet<String>(DrugData.getDrugs(target));
        drugs.retainAll(cancerDrug);
        return drugs;
    }

    public static Map<String, Set<String>> getDrugs(Set<String> targets) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String target : targets) {
            for (String drug : DrugData.getDrugs(target)) {
                if (!map.containsKey(drug)) {
                    map.put(drug, new HashSet());
                }
                ((Set)map.get(drug)).add(target);
            }
        }
        return map;
    }

    public static Set<String> getDruggable() {
        return target2drug.keySet();
    }

    public static List<String> sortDrugs(final Map<String, Set<String>> drugs) {
        ArrayList<String> sorted = new ArrayList<String>(drugs.keySet());
        Collections.sort(sorted, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer size2;
                Integer size1 = ((Set)drugs.get(o1)).size();
                if (size1.equals(size2 = Integer.valueOf(((Set)drugs.get(o2)).size()))) {
                    return o1.compareTo(o2);
                }
                return size2.compareTo(size1);
            }
        });
        return sorted;
    }

    private static String getHeader(Scanner scan) {
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.startsWith("#")) continue;
            return line;
        }
        return null;
    }

    public static void main(String[] args) {
        String drug = "Cetuximab";
        System.out.println(DrugData.getTargets(drug));
        System.out.println(DrugData.isCancerDrug(drug));
        System.out.println(DrugData.isFDAApproved(drug));
        System.out.println(DrugData.isNutraceutical(drug));
        System.out.println(DrugData.getDescription(drug));
        System.out.println(DrugData.getDrugs("EGFR"));
    }

    static {
        String[] tok;
        String line;
        drug2target = new HashMap<String, Set<String>>();
        target2drug = new HashMap<String, Set<String>>();
        description = new HashMap<String, String>();
        fdaApproved = new HashSet<String>();
        cancerDrug = new HashSet<String>();
        nutraceutical = new HashSet<String>();
        Scanner scan = new Scanner(DrugData.class.getResourceAsStream("drugs.tsv"));
        String header = DrugData.getHeader(scan);
        assert (header.equals("PiHelper_Drug_ID\tDrug_Name\tDrug_Synonyms\tDescription\tNumber_of_Targets\tATC_Codes\tisFdaApproved\tisCancerDrug\tisNutraceutical\tNumber_Of_Clinical_Trials\tDataSources\tReferences")) : "Something changed in matrix!";
        while (scan.hasNextLine()) {
            line = scan.nextLine();
            tok = line.split("\t");
            if (tok.length <= 8) continue;
            if (tok[3].length() > 2) {
                description.put(tok[1], tok[3].substring(1, tok[3].length() - 1));
            }
            if (tok[6].startsWith("t")) {
                fdaApproved.add(tok[1]);
            }
            if (tok[7].startsWith("t")) {
                cancerDrug.add(tok[1]);
            }
            if (!tok[8].startsWith("t")) continue;
            nutraceutical.add(tok[1]);
        }
        scan = new Scanner(DrugData.class.getResourceAsStream("drugtargets.tsv"));
        header = DrugData.getHeader(scan);
        assert (header.equals("PiHelper_DrugTarget_ID\tHGNC_Symbol\tDrug_Name\tDataSources\tReferences")) : "Something changed in matrix!";
        while (scan.hasNextLine()) {
            line = scan.nextLine();
            tok = line.split("\t");
            if (tok.length <= 2) continue;
            if (!drug2target.containsKey(tok[2])) {
                drug2target.put(tok[2], new HashSet());
            }
            if (!target2drug.containsKey(tok[1])) {
                target2drug.put(tok[1], new HashSet());
            }
            drug2target.get(tok[2]).add(tok[1]);
            target2drug.get(tok[1]).add(tok[2]);
        }
    }
}

