/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.portal;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.cbio.causality.data.portal.CBioPortalManager;
import org.cbio.causality.data.portal.CaseList;
import org.cbio.causality.util.ArrayUtil;

public class ClinicalDataManager {
    private Map<String, Double> os;
    private Map<String, Double> dfs;

    public ClinicalDataManager(CBioPortalAccessor acc) {
        this(acc.getCurrentCaseList());
    }

    public ClinicalDataManager(CaseList caseList) {
        CBioPortalManager cman = new CBioPortalManager();
        Map<String, Double>[] data = cman.getClinicalData(caseList);
        if (data != null) {
            this.dfs = data[0];
            this.os = data[1];
        }
    }

    public double[] getDFS(Set<String> caseIDs) {
        return this.get(caseIDs, this.dfs);
    }

    public double[] getOS(Set<String> caseIDs) {
        return this.get(caseIDs, this.os);
    }

    private double[] get(Set<String> caseIDs, Map<String, Double> map) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (String caseID : caseIDs) {
            Double val = map.get(caseID);
            if (val == null || Double.isNaN(val)) continue;
            vals.add(val);
        }
        return ArrayUtil.toArray(vals, 0.0);
    }
}

