/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.tcgafile;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.cbio.causality.util.ArrayUtil;
import org.cbio.causality.util.StudentsT;
import org.cbio.causality.util.Summary;

public class CNAReader {
    private String filename;
    private Map<String, Map<String, Integer>> data;
    boolean reduce;
    int threshold;
    public static final int NO_DATA = -2147483647;

    public CNAReader(String filename) throws FileNotFoundException {
        this(filename, null);
    }

    public CNAReader(String filename, Set<String> genes) throws FileNotFoundException {
        this(filename, genes, true, 2);
    }

    public CNAReader(String filename, boolean reduce, int threshold) throws FileNotFoundException {
        this(filename, null, reduce, threshold);
    }

    public CNAReader(String filename, Set<String> genes, boolean reduce, int threshold) throws FileNotFoundException {
        this.filename = filename;
        this.reduce = reduce;
        if (reduce && threshold < 1) {
            throw new IllegalArgumentException("Threshold has to be positive integer");
        }
        this.threshold = threshold;
        this.data = new HashMap<String, Map<String, Integer>>();
        this.load(genes);
    }

    private void load(Set<String> genes) throws FileNotFoundException {
        Scanner sc = new Scanner(new File(this.filename));
        String line = sc.nextLine();
        while (line.startsWith("#")) {
            line = sc.nextLine();
        }
        String[] header = line.split("\t");
        int ss = 0;
        while (!header[ss].startsWith("TCGA")) {
            ++ss;
        }
        for (int i = ss; i < header.length; ++i) {
            header[i] = header[i].substring(0, 15);
        }
        while (sc.hasNextLine()) {
            line = sc.nextLine();
            String id = line.substring(0, line.indexOf("\t"));
            if (id.contains("|")) {
                id = id.substring(0, id.indexOf("|"));
            }
            if (genes != null && !genes.contains(id)) continue;
            String[] token = line.split("\t");
            for (int i = ss; i < header.length; ++i) {
                Integer val = Integer.parseInt(token[i]);
                if (!this.data.containsKey(id)) {
                    this.data.put(id, new HashMap());
                }
                this.data.get(id).put(header[i], val);
            }
            if (genes == null || genes.size() != this.data.size()) continue;
            break;
        }
    }

    public Set<String> getSamples() {
        HashSet<String> samples = new HashSet<String>();
        for (Map<String, Integer> map : this.data.values()) {
            samples.addAll(map.keySet());
        }
        return samples;
    }

    public Set<String> getGenes() {
        return this.data.keySet();
    }

    public int[] getGeneAlterationArray(String id, String[] samples) {
        if (this.data.containsKey(id)) {
            int[] b = new int[samples.length];
            Arrays.fill(b, 0);
            for (int i = 0; i < samples.length; ++i) {
                if (this.data.get(id).containsKey(samples[i])) {
                    Integer val = this.data.get(id).get(samples[i]);
                    if (this.reduce) {
                        b[i] = val >= this.threshold ? 1 : (val <= -this.threshold ? -1 : 0);
                        continue;
                    }
                    b[i] = val;
                    continue;
                }
                b[i] = -2147483647;
            }
            return b;
        }
        return null;
    }

    private boolean[] getAmplified(int[] alterations) {
        return this.getOneSidedChange(alterations, true);
    }

    private boolean[] getDeleted(int[] alterations) {
        return this.getOneSidedChange(alterations, false);
    }

    private boolean[] getOneSidedChange(int[] alterations, boolean amplified) {
        boolean[] b = new boolean[alterations.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = amplified && alterations[i] > 0 || !amplified && alterations[i] < 0;
        }
        return b;
    }

    private boolean[] getNoChange(int[] alterations) {
        boolean[] b = new boolean[alterations.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = alterations[i] == 0;
        }
        return b;
    }

    public int[] getExpVerifiedCNA(String id, String[] samples, double[] exp, double pvalThr) {
        assert (exp.length == samples.length);
        int[] alterations = this.getGeneAlterationArray(id, samples);
        boolean[] noChange = this.getNoChange(alterations);
        double[] noChVals = ArrayUtil.subset(exp, noChange);
        if (noChVals.length == 0) {
            return null;
        }
        boolean[] amplified = this.getAmplified(alterations);
        boolean[] deleted = this.getDeleted(alterations);
        amplified = this.getVerified(amplified, noChVals, true, exp, pvalThr);
        deleted = this.getVerified(deleted, noChVals, false, exp, pvalThr);
        if (amplified == null && deleted == null) {
            return null;
        }
        if (amplified == null) {
            return this.keepSelected(alterations, deleted);
        }
        if (deleted == null) {
            return this.keepSelected(alterations, amplified);
        }
        ArrayUtil.ORWith(amplified, deleted);
        return this.keepSelected(alterations, amplified);
    }

    public boolean[] getVerified(boolean[] change, double[] noChVals, boolean amplified, double[] exp, double pvalThr) {
        double[] chVals = ArrayUtil.subset(exp, change);
        if (chVals.length == 0) {
            return null;
        }
        double ch = Summary.calcChangeOfMean(noChVals, chVals);
        if (amplified && ch < 0.0 || !amplified && ch > 0.0) {
            return null;
        }
        double p = StudentsT.getPValOfMeanDifference(noChVals, chVals);
        if (Double.isNaN(p) || p > pvalThr) {
            return null;
        }
        double val = Summary.getIntersectionPoint(chVals, noChVals);
        return CNAReader.select(change, exp, val, amplified);
    }

    private static boolean[] select(boolean[] considerLoc, double[] exp, double thr, boolean greaterThan) {
        boolean[] select = new boolean[exp.length];
        for (int i = 0; i < select.length; ++i) {
            select[i] = considerLoc[i] && (greaterThan ? exp[i] > thr : exp[i] < thr);
        }
        return select;
    }

    private int[] keepSelected(int[] cna, boolean[] verified) {
        int[] arr = new int[cna.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = verified[i] ? cna[i] : 0;
        }
        return arr;
    }

    public double getCNAPval(String id, String[] samples, boolean amplified, double[] exp) {
        int[] alterations = this.getGeneAlterationArray(id, samples);
        boolean[] noChange = this.getNoChange(alterations);
        double[] noChVals = ArrayUtil.subset(exp, noChange);
        if (noChVals.length == 0) {
            return 1.0;
        }
        boolean[] changed = amplified ? this.getAmplified(alterations) : this.getDeleted(alterations);
        double[] chVals = ArrayUtil.subset(exp, changed);
        if (chVals.length == 0) {
            return 1.0;
        }
        double ch = Summary.calcChangeOfMean(noChVals, chVals);
        if (amplified && ch < 0.0 || !amplified && ch > 0.0) {
            return 1.0;
        }
        double p = StudentsT.getPValOfMeanDifference(noChVals, chVals);
        if (Double.isNaN(p)) {
            return 1.0;
        }
        return p;
    }

    public static void main(String[] args) throws FileNotFoundException {
        CNAReader reader = new CNAReader("/home/ozgun/Documents/TCGA/UVM/all_thresholded.by_genes.txt");
        System.out.println(reader.getSamples().size());
    }
}

