/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.tcgafile;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class ExpressionReader {
    private String filename;
    private Map<String, Map<String, Double>> data;
    private double LOG2 = Math.log(2.0);

    public ExpressionReader(String filename) throws FileNotFoundException {
        this(filename, null);
    }

    public ExpressionReader(String filename, Set<String> genes) throws FileNotFoundException {
        this.filename = filename;
        this.data = new HashMap<String, Map<String, Double>>();
        this.load(genes);
    }

    private void load(Set<String> genes) throws FileNotFoundException {
        Scanner sc = new Scanner(new File(this.filename));
        String line = sc.nextLine();
        while (line.startsWith("#")) {
            line = sc.nextLine();
        }
        String[] header = line.split("\t");
        int ss = 0;
        while (!header[ss].startsWith("TCGA")) {
            ++ss;
        }
        for (int i = ss; i < header.length; ++i) {
            header[i] = header[i].substring(0, 15);
        }
        sc.nextLine();
        while (sc.hasNextLine()) {
            line = sc.nextLine();
            String id = line.substring(0, line.indexOf("|"));
            if (genes != null && !genes.contains(id) || id.equals("?")) continue;
            String[] token = line.split("\t");
            for (int i = ss; i < header.length; ++i) {
                Double val = Double.parseDouble(token[i]);
                if (!this.data.containsKey(id)) {
                    this.data.put(id, new HashMap());
                }
                this.data.get(id).put(header[i], val);
            }
            if (genes == null || this.data.size() != genes.size()) continue;
            break;
        }
    }

    public Set<String> getSamples() {
        HashSet<String> samples = new HashSet<String>();
        for (Map<String, Double> map : this.data.values()) {
            samples.addAll(map.keySet());
        }
        return samples;
    }

    public Set<String> getGenes() {
        return this.data.keySet();
    }

    public double[] getGeneAlterationArray(String id, String[] samples) {
        double[] d = new double[samples.length];
        if (this.data.containsKey(id)) {
            for (int i = 0; i < samples.length; ++i) {
                d[i] = this.data.get(id).containsKey(samples[i]) ? Math.log1p(this.data.get(id).get(samples[i])) / this.LOG2 : Double.NaN;
            }
        }
        return d;
    }

    public static void main(String[] args) throws FileNotFoundException {
        ExpressionReader reader = new ExpressionReader("/home/ozgun/Documents/TCGA/UVM/UVM.rnaseqv2__illuminahiseq_rnaseqv2__unc_edu__Level_3__RSEM_genes_normalized__data.data.txt");
        System.out.println(reader.getSamples().size());
    }
}

