/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.tcgafile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.cbio.causality.util.Histogram;
import org.cbio.causality.util.Summary;

public class MutationReader {
    private Map<String, Map<String, String>> typeMap = new LinkedHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> valueMap = new LinkedHashMap<String, Map<String, String>>();
    private Set<String> sampleSet = new HashSet<String>();
    public static final String NO_DATA = "NO_DATA";

    public MutationReader(String filename) throws FileNotFoundException {
        this(filename, null);
    }

    public MutationReader(String filename, Set<String> genes) throws FileNotFoundException {
        if (filename != null) {
            this.load(filename, genes);
        }
    }

    public void load(String filename, Set<String> genes) throws FileNotFoundException {
        Scanner sc = new Scanner(new File(filename));
        int typeInd = -1;
        int sampleInd = -1;
        int protChInd = -1;
        HashMap values = new HashMap();
        while (sc.hasNextLine()) {
            String protCh;
            String line = sc.nextLine();
            if (line.startsWith("#")) continue;
            if (line.startsWith("Hugo_Symbol")) {
                String[] header = line.split("\t");
                typeInd = this.indexOf(header, "Variant_Classification");
                sampleInd = this.indexOf(header, "Tumor_Sample_Barcode");
                protChInd = this.indexOf(header, "Protein_Change");
                if (protChInd < 0) {
                    protChInd = this.indexOf(header, "amino_acid_change_WU");
                }
                if (protChInd < 0) {
                    protChInd = this.indexOf(header, "AAChange");
                }
                if (protChInd < 0) {
                    protChInd = this.indexOf(header, "amino_acid_change");
                }
                if (protChInd >= 0) continue;
                System.out.println("No protein change in file " + filename);
                return;
            }
            String id = line.substring(0, line.indexOf("\t"));
            if (genes != null && !genes.contains(id)) continue;
            String[] token = line.split("\t");
            String sample = token[sampleInd];
            sample = sample.substring(0, 15);
            this.sampleSet.add(sample);
            String type = token[typeInd];
            if (type.equals("Silent")) continue;
            String string = protCh = token.length <= protChInd ? "" : token[protChInd];
            if (!protCh.isEmpty() && protCh.startsWith("p.")) {
                protCh = protCh.substring(2);
            } else if (protCh.equals(".")) {
                protCh = "";
            } else if (!protCh.equals("NULL") && !protCh.isEmpty()) continue;
            if (!this.typeMap.containsKey(id)) {
                this.typeMap.put(id, new HashMap());
            }
            this.typeMap.get(id).put(sample, type);
            if (!protCh.equals("NULL") && !protCh.isEmpty()) {
                if (!values.containsKey(id)) {
                    values.put(id, new HashMap());
                }
                if (!((Map)values.get(id)).containsKey(sample)) {
                    ((Map)values.get(id)).put(sample, new HashSet());
                }
                ((Set)((Map)values.get(id)).get(sample)).add(protCh);
            }
            if (genes == null || genes.size() != this.typeMap.size()) continue;
            break;
        }
        for (String gene : values.keySet()) {
            if (!this.valueMap.containsKey(gene)) {
                this.valueMap.put(gene, new HashMap());
            }
            for (String sample : ((Map)values.get(gene)).keySet()) {
                if (this.valueMap.get(gene).containsKey(sample)) continue;
                StringBuilder s = new StringBuilder();
                for (String mut : (Set)((Map)values.get(gene)).get(sample)) {
                    s.append(mut).append(" ");
                }
                this.valueMap.get(gene).put(sample, s.toString().trim());
            }
        }
    }

    public Set<String> getSamples() {
        return this.sampleSet;
    }

    public Set<String> getGenes() {
        return this.typeMap.keySet();
    }

    private int indexOf(String[] array, String val) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(val)) continue;
            return i;
        }
        return -1;
    }

    public boolean[] getGeneAlterationArray(String id, String[] samples) {
        if (this.typeMap.containsKey(id)) {
            boolean[] b = new boolean[samples.length];
            Arrays.fill(b, false);
            for (int i = 0; i < samples.length; ++i) {
                if (!this.typeMap.get(id).containsKey(samples[i])) {
                    throw new IllegalArgumentException("Sample " + samples[i] + " does not have mutation data.");
                }
                b[i] = true;
            }
            return b;
        }
        return null;
    }

    public String[] getMutationValues(String id, String[] samples) {
        if (this.valueMap.containsKey(id)) {
            String[] vals = new String[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                if (this.valueMap.get(id).containsKey(samples[i])) {
                    vals[i] = this.valueMap.get(id).get(samples[i]);
                    continue;
                }
                if (this.sampleSet.contains(samples[i])) continue;
                vals[i] = NO_DATA;
            }
            return vals;
        }
        return null;
    }

    public void writeAsAlterationMatrix(String outFile) throws IOException {
        ArrayList<String> samples = new ArrayList<String>(this.getSamples());
        Collections.sort(samples);
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        for (String sample : samples) {
            writer.write("\t" + sample);
        }
        for (String gene : this.typeMap.keySet()) {
            writer.write("\n" + gene);
            Map<String, String> map = this.typeMap.get(gene);
            for (String sample : samples) {
                writer.write("\t" + (map.containsKey(sample) ? "1" : "0"));
            }
        }
        writer.close();
    }

    private void printRecurrenceCounts() {
        String gene;
        Integer c;
        int totalMut = 0;
        int delMut = 0;
        HashMap cnt = new HashMap();
        for (String gene2 : this.valueMap.keySet()) {
            for (String sample : this.valueMap.get(gene2).keySet()) {
                for (String mut : this.valueMap.get(gene2).get(sample).split(" ")) {
                    ++totalMut;
                    if (mut.contains("*") || mut.contains("fs")) {
                        ++delMut;
                    }
                    if (!cnt.containsKey(gene2)) {
                        cnt.put(gene2, new HashMap());
                    }
                    if (((Map)cnt.get(gene2)).containsKey(mut)) {
                        ((Map)cnt.get(gene2)).put(mut, (Integer)((Map)cnt.get(gene2)).get(mut) + 1);
                        continue;
                    }
                    ((Map)cnt.get(gene2)).put(mut, 1);
                }
            }
        }
        System.out.println("Global ratio of deleterious mutations = " + (double)delMut / (double)totalMut);
        final HashMap<String, Integer> best = new HashMap<String, Integer>();
        for (String gene3 : cnt.keySet()) {
            best.put(gene3, Summary.max(((Map)cnt.get(gene3)).values()));
        }
        ArrayList genes = new ArrayList(cnt.keySet());
        Collections.sort(genes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)best.get(o2)).compareTo((Integer)best.get(o1));
            }
        });
        Map<String, Double> dRat = this.getRatiosOfDeleteriousMutations();
        Histogram h = new Histogram(0.1);
        h.setBorderAtZero(true);
        Iterator i$ = genes.iterator();
        while (i$.hasNext() && (c = (Integer)best.get(gene = (String)i$.next())) != 2) {
            System.out.println(c + "\t" + gene + "\t" + dRat.get(gene));
            h.count(dRat.get(gene));
        }
        h.print();
    }

    public Map<String, Integer> getHighestRecurrenceCounts() {
        HashMap cnt = new HashMap();
        for (String gene : this.valueMap.keySet()) {
            for (String sample : this.valueMap.get(gene).keySet()) {
                for (String mut : this.valueMap.get(gene).get(sample).split(" ")) {
                    if (!cnt.containsKey(gene)) {
                        cnt.put(gene, new HashMap());
                    }
                    if (((Map)cnt.get(gene)).containsKey(mut)) {
                        ((Map)cnt.get(gene)).put(mut, (Integer)((Map)cnt.get(gene)).get(mut) + 1);
                        continue;
                    }
                    ((Map)cnt.get(gene)).put(mut, 1);
                }
            }
        }
        HashMap<String, Integer> highest = new HashMap<String, Integer>();
        for (String gene : cnt.keySet()) {
            highest.put(gene, Summary.max(((Map)cnt.get(gene)).values()));
        }
        return highest;
    }

    public Map<String, Double> getRatiosOfDeleteriousMutations() {
        HashMap<String, Double> rat = new HashMap<String, Double>();
        for (String gene : this.valueMap.keySet()) {
            int total = 0;
            int del = 0;
            for (String sample : this.valueMap.get(gene).keySet()) {
                String s = this.valueMap.get(gene).get(sample);
                ++total;
                if (!s.contains("*") && !s.contains("fs")) continue;
                ++del;
            }
            double r = (double)del / (double)total;
            rat.put(gene, r);
        }
        return rat;
    }

    public double getOverallDelMutRatio() {
        int total = 0;
        int del = 0;
        for (String gene : this.valueMap.keySet()) {
            for (String sample : this.valueMap.get(gene).keySet()) {
                String s = this.valueMap.get(gene).get(sample);
                ++total;
                if (!s.contains("*") && !s.contains("fs")) continue;
                ++del;
            }
        }
        double r = (double)del / (double)total;
        return r;
    }

    public Map<String, Integer> getMutatedSampleCounts() {
        HashMap<String, Integer> cnt = new HashMap<String, Integer>();
        for (String gene : this.valueMap.keySet()) {
            cnt.put(gene, this.valueMap.get(gene).keySet().size());
        }
        return cnt;
    }

    public static void main(String[] args) throws IOException {
        MutationReader reader = new MutationReader("/home/babur/Documents/TCGA/SKCM/mutation.maf");
    }
}

