/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.data.tcgafile;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.util.CollectionUtil;

public class RPPAReader {
    private String filename;
    private static Map<String, Set<String>> additionalAnnotation = new HashMap<String, Set<String>>();
    private Map<String, Map<String, Double>> data;
    private Map<String, Map<String, Set<String>>> symbolToIDs;
    private Map<String, RPPAData> idToData;

    public RPPAReader(String filename) throws FileNotFoundException {
        this(filename, null);
    }

    public RPPAReader(String filename, Set<String> genes) throws FileNotFoundException {
        this.filename = filename;
        this.data = new HashMap<String, Map<String, Double>>();
        this.symbolToIDs = new HashMap<String, Map<String, Set<String>>>();
        this.idToData = new HashMap<String, RPPAData>();
        this.load(genes);
    }

    private void load(Set<String> genes) throws FileNotFoundException {
        Scanner sc = new Scanner(new File(this.filename));
        String line = sc.nextLine();
        while (line.startsWith("#")) {
            line = sc.nextLine();
        }
        String[] header = line.split("\t");
        int ss = 0;
        while (!header[ss].startsWith("TCGA")) {
            ++ss;
        }
        for (int i = ss; i < header.length; ++i) {
            header[i] = header[i].substring(0, 15);
        }
        while (sc.hasNextLine()) {
            line = sc.nextLine();
            String id = line.substring(0, line.indexOf("\t"));
            Set<String> pGenes = this.parseID(id);
            id = id.substring(id.indexOf("|") + 1);
            Map<String, String> map = this.mapSymbols(pGenes);
            if (genes != null && !CollectionUtil.intersects(map.keySet(), genes)) continue;
            ArrayList<String> geneList = new ArrayList<String>(map.keySet());
            Collections.sort(geneList);
            HashMap<String, List<String>> sitesMap = new HashMap<String, List<String>>();
            for (String g : geneList) {
                String pGene = map.get(g);
                if (!pGene.contains("_")) {
                    sitesMap = null;
                    break;
                }
                pGene = pGene.substring(pGene.indexOf("_") + 1);
                ArrayList sites = new ArrayList();
                Collections.addAll(sites, pGene.split("_"));
                sitesMap.put(g, sites);
            }
            RPPAData d = new RPPAData(id, null, geneList, sitesMap);
            this.idToData.put(id, d);
            for (String sym : map.keySet()) {
                if (!this.symbolToIDs.containsKey(sym)) {
                    this.symbolToIDs.put(sym, new HashMap());
                }
                if (!this.symbolToIDs.get(sym).containsKey(map.get(sym))) {
                    this.symbolToIDs.get(sym).put(map.get(sym), new HashSet());
                }
                this.symbolToIDs.get(sym).get(map.get(sym)).add(id);
            }
            String[] token = line.split("\t");
            for (int i = ss; i < header.length; ++i) {
                double val;
                double d2 = val = token[i].equals("NA") ? Double.NaN : Double.parseDouble(token[i]);
                if (!this.data.containsKey(id)) {
                    this.data.put(id, new HashMap());
                }
                this.data.get(id).put(header[i], val);
            }
        }
    }

    private Map<String, String> mapSymbols(Set<String> pGenes) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String pGene : pGenes) {
            String symbol = pGene.contains("_") ? pGene.substring(0, pGene.indexOf("_")) : pGene;
            map.put(symbol, pGene);
        }
        return map;
    }

    public Set<String> getSamples() {
        HashSet<String> samples = new HashSet<String>();
        for (Map<String, Double> map : this.data.values()) {
            samples.addAll(map.keySet());
        }
        return samples;
    }

    public Set<String> getGenes() {
        return this.symbolToIDs.keySet();
    }

    public double[] getValues(String id, String[] samples) {
        double[] b = new double[samples.length];
        if (this.data.containsKey(id)) {
            for (int i = 0; i < samples.length; ++i) {
                b[i] = this.data.get(id).containsKey(samples[i]) ? this.data.get(id).get(samples[i]) : Double.NaN;
            }
        }
        return b;
    }

    private Set<String> parseID(String id) {
        String symbols = id.substring(0, id.indexOf("|")).trim();
        if (additionalAnnotation.containsKey(id = id.substring(id.indexOf("|") + 1).trim())) {
            return additionalAnnotation.get(id);
        }
        ArrayList<String> pSites = new ArrayList<String>();
        if (id.contains("_p")) {
            String s = id.substring(id.indexOf("_p") + 2);
            String[] token = s.split("_");
            for (int i = 0; i < token.length; ++i) {
                if (token[i].startsWith("p")) {
                    token[i] = token[i].substring(1);
                }
                pSites.add(token[i]);
            }
        }
        HashSet<String> genes = new HashSet<String>(Arrays.asList(symbols.split(" ")));
        if (!pSites.isEmpty() && genes.size() > 1) {
            System.out.println("Warning: There is an unhandled RPPA entry: " + symbols + "|" + id);
        }
        HashSet<String> pGenes = new HashSet<String>();
        for (String gene : genes) {
            for (String site : pSites) {
                gene = gene + "_" + site;
            }
            pGenes.add(gene);
        }
        return pGenes;
    }

    public Set<RPPAData> getAssociatedData(String symbol, String[] samples) {
        Map<String, Set<String>> map = this.symbolToIDs.get(symbol);
        if (map == null) {
            return Collections.emptySet();
        }
        HashSet<RPPAData> stubs = new HashSet<RPPAData>();
        for (String pGene : map.keySet()) {
            for (String id : map.get(pGene)) {
                stubs.add(this.idToData.get(id));
            }
        }
        HashSet<RPPAData> set = new HashSet<RPPAData>();
        for (RPPAData stub : stubs) {
            RPPAData d = (RPPAData)stub.clone();
            d.vals = new double[][]{this.getValues(d.id, samples)};
            set.add(d);
        }
        return set;
    }

    public static void main(String[] args) throws FileNotFoundException {
        RPPAReader reader = new RPPAReader("/home/babur/Documents/Temp/BRCA/rppa.txt");
        ArrayList<String> sList = new ArrayList<String>(reader.getSamples());
        Collections.sort(sList);
        String[] samples = sList.toArray(new String[sList.size()]);
        for (RPPAData data : reader.getAssociatedData("AKT1", samples)) {
            System.out.println(data.toString());
        }
    }

    static {
        Scanner sc = new Scanner(RPPAReader.class.getResourceAsStream("rppa-annotation.txt"));
        while (sc.hasNextLine()) {
            String[] token = sc.nextLine().split("\t");
            additionalAnnotation.put(token[0], new HashSet<String>(Arrays.asList(token).subList(1, token.length)));
        }
        sc.close();
    }
}

