/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.idmapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.idmapping.HGNC;

public class CancerGeneCensus {
    private static Map<String, String> sym2chr = new HashMap<String, String>();

    public static Set<String> getAllSymbols() {
        return sym2chr.keySet();
    }

    public static boolean isCancerGene(String sym) {
        return sym2chr.containsKey(sym);
    }

    public static Set<String> getSymbolsOfChromosome(String chr) {
        HashSet<String> set = new HashSet<String>();
        for (String sym : CancerGeneCensus.getAllSymbols()) {
            String desNo;
            String c;
            String no;
            if (!sym2chr.containsKey(sym) || !(no = (c = sym2chr.get(sym)).split("p")[0].split("q")[0]).equals(desNo = chr.split("p")[0].split("q")[0]) || !c.contains(chr)) continue;
            set.add(sym);
        }
        return set;
    }

    public static void main(String[] args) {
        HashSet<String> genes = new HashSet<String>(Arrays.asList("POU5F1B", "SBNO1", "CYLD", "TOX", "SAV1", "CLEC12A", "SMAD4", "BBX", "HCFC2", "ZC3H18", "ANKRD24", "FBXW7", "ITPR2", "CHD4", "OR2T35", "ABCD1"));
        genes.retainAll(CancerGeneCensus.getAllSymbols());
        System.out.println("genes = " + genes);
    }

    static {
        BufferedReader reader = new BufferedReader(new InputStreamReader(HGNC.class.getResourceAsStream("Census_allWed Feb 24 19-39-08 2016.tsv")));
        try {
            reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                String sym = token[0];
                String chr = token[4];
                sym2chr.put(sym, chr);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

