/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.idmapping;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.analysis.Graph;

public class HGNC {
    private static Map<String, String> sym2id;
    private static Map<String, String> sym2chr;
    private static Map<String, String> id2sym;
    private static Map<String, String> old2new;
    private static Map<String, String> uniprot2sym;
    private static Map<String, Set<String>> families;

    public static String getSymbol(String symbolOrID) {
        if (symbolOrID == null) {
            return null;
        }
        if (id2sym.containsKey(symbolOrID)) {
            return id2sym.get(symbolOrID);
        }
        if (sym2id.containsKey(symbolOrID)) {
            return symbolOrID;
        }
        if (old2new.containsKey(symbolOrID = symbolOrID.toUpperCase())) {
            return old2new.get(symbolOrID);
        }
        if (uniprot2sym.containsKey(symbolOrID)) {
            return uniprot2sym.get(symbolOrID);
        }
        return null;
    }

    public static Set<String> getFamily(String name) {
        if (!families.containsKey(name)) {
            return Collections.emptySet();
        }
        return families.get(name);
    }

    public static Set<String> getAllSymbols() {
        return sym2id.keySet();
    }

    public static Set<String> getSymbolsOfChromosome(String chr) {
        HashSet<String> set = new HashSet<String>();
        for (String sym : HGNC.getAllSymbols()) {
            String desNo;
            String c;
            String no;
            if (!sym2chr.containsKey(sym) || !(no = (c = sym2chr.get(sym)).split("p")[0].split("q")[0]).equals(desNo = chr.split("p")[0].split("q")[0]) || !c.contains(chr)) continue;
            set.add(sym);
        }
        return set;
    }

    public static String getChromosomeLoc(String symbol) {
        return sym2chr.get(symbol);
    }

    public static Graph getCompleteClique(boolean directed) {
        Graph graph = new Graph("HGNC complete clique", "clique-edge");
        for (String s1 : sym2id.keySet()) {
            for (String s2 : sym2id.keySet()) {
                if (s1.equals(s2) || !directed && s2.compareTo(s1) < 0) continue;
                graph.putRelation(s1, s2, directed);
                graph.putRelation(s1, s2, directed);
            }
        }
        return graph;
    }

    public static void main(String[] args) {
        Set<String> set = HGNC.getSymbolsOfChromosome("8q24");
        System.out.println(HGNC.getChromosomeLoc("MYC"));
    }

    static {
        families = new HashMap<String, Set<String>>();
        try {
            sym2id = new HashMap<String, String>();
            sym2chr = new HashMap<String, String>();
            id2sym = new HashMap<String, String>();
            old2new = new HashMap<String, String>();
            uniprot2sym = new HashMap<String, String>();
            families = new HashMap<String, Set<String>>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(HGNC.class.getResourceAsStream("hgnc.txt")));
            reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                String sym = token[1];
                String id = token[0];
                sym2id.put(sym, id);
                id2sym.put(id, sym);
                if (token.length > 2) {
                    for (String old : token[2].split(",")) {
                        if ((old = old.trim().toUpperCase()).isEmpty()) continue;
                        old2new.put(old, sym);
                    }
                }
                if (token.length > 3) {
                    for (String synonym : token[3].split(",")) {
                        if ((synonym = synonym.trim().toUpperCase()).isEmpty()) continue;
                        old2new.put(synonym, sym);
                    }
                }
                if (token.length > 4) {
                    sym2chr.put(sym, token[4]);
                }
                if (token.length > 5) {
                    if (!families.containsKey(token[5])) {
                        families.put(token[5], new HashSet());
                    }
                    families.get(token[5]).add(sym);
                }
                if (token.length > 6 && !token[6].isEmpty()) {
                    uniprot2sym.put(token[6], sym);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

