/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.idmapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.idmapping.HGNC;

public class Length {
    private static Map<String, Integer> map;

    public static void main(String[] args) {
        System.out.println(Length.of("BAX"));
    }

    public static Integer of(String symbol) {
        return map.get(symbol);
    }

    public static boolean containsSymbol(String symbol) {
        return map.containsKey(symbol);
    }

    public static Set<String> getSymbols() {
        return map.keySet();
    }

    public static int getTotalLength(Set<String> symbols) {
        int t = 0;
        for (String symbol : symbols) {
            Integer l = Length.of(symbol);
            if (l == null) continue;
            t += l.intValue();
        }
        return t;
    }

    static {
        try {
            map = new HashMap<String, Integer>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(HGNC.class.getResourceAsStream("gene-lengths.txt")));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                String sym = token[0];
                Integer length = Integer.parseInt(token[1]);
                map.put(sym, length);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

