/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.util.Scanner;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.idmapping.HGNC;
import org.cbio.causality.network.IntAct;
import org.cbio.causality.network.InteractionProvider;
import org.cbio.causality.network.PathwayCommons;
import org.cbio.causality.network.ReactomeFI;
import org.cbio.causality.network.SPIKE;
import org.cbio.causality.network.SignaLink;

public class HPRD
implements InteractionProvider {
    private static Graph graph = new Graph("HPRD", SIFEnum.INTERACTS_WITH.getTag());

    public static Set<String> getInteractors(String symbol) {
        return graph.getNeighbors(symbol);
    }

    public static Set<String> getAllSymbols() {
        return graph.getSymbols();
    }

    public static int getDegree(String symbol) {
        return graph.getNeighbors(symbol).size();
    }

    @Override
    public Set<String> getInteractions(String symbol) {
        return HPRD.getInteractors(symbol);
    }

    public static Graph getGraph() {
        return graph;
    }

    public static Graph getGraph(boolean directed) {
        if (!directed) {
            return HPRD.getGraph();
        }
        Graph graph = new Graph();
        for (String s : HPRD.getAllSymbols()) {
            for (String n : HPRD.getInteractors(s)) {
                graph.putRelation(s, n, true);
            }
        }
        return graph;
    }

    public static void main(String[] args) {
        Graph icw = PathwayCommons.getGraph(SIFEnum.IN_COMPLEX_WITH);
        Graph hprd = HPRD.getGraph();
        Graph intact = IntAct.getGraph();
        icw.printVennIntersections(false, hprd, intact);
        Graph graph = PathwayCommons.getGraph(SIFEnum.IN_COMPLEX_WITH);
        graph.merge(HPRD.getGraph());
        graph.merge(IntAct.getGraph());
        graph.merge(ReactomeFI.getGraphPPI());
        System.out.println(graph.getNeighbors("FOXA1"));
        graph = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF);
        graph.merge(SPIKE.getGraphPostTl());
        graph.merge(SignaLink.getGraphPostTl());
        graph.merge(ReactomeFI.getGraphPostTl());
        System.out.println(graph.getUpstream("FOXA1"));
    }

    static {
        Scanner sc = new Scanner(HPRD.class.getResourceAsStream("BINARY_PROTEIN_PROTEIN_INTERACTIONS.txt"));
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            if (token[0].equals(token[3])) continue;
            token[0] = HGNC.getSymbol(token[0]);
            token[3] = HGNC.getSymbol(token[3]);
            if (token[0] == null || token[3] == null) continue;
            graph.putRelation(token[0], token[3], false);
        }
    }
}

