/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.idmapping.HGNC;

public class MSigDBTFT {
    private static Graph graph = new Graph("TRANSFAC", SIFEnum.CONTROLS_EXPRESSION_OF.getTag());

    public static Graph getGraph() {
        return graph;
    }

    private static void addRelation(String target, String tf) {
        if ((target = HGNC.getSymbol(target)) == null) {
            return;
        }
        graph.putRelation(tf, target, true);
    }

    public static void main(String[] args) {
        Graph graph = MSigDBTFT.getGraph();
        Set<String> set = graph.getUpstream("HRAS");
        System.out.println("set.size() = " + set.size());
        System.out.println(set);
        Graph g = new Graph("Custom", SIFEnum.CONTROLS_EXPRESSION_OF.getTag());
        g.load("/home/ozgun/Downloads/out.sif", Collections.<String>emptySet(), new HashSet<String>(Arrays.asList(g.getEdgeType())));
        g.printVennIntersections(true, graph);
    }

    static {
        Scanner sc = new Scanner(MSigDBTFT.class.getResourceAsStream("msigdb-tft.gmt"));
        while (sc.hasNextLine()) {
            int uInd;
            String line = sc.nextLine();
            String[] token = line.split("\t");
            String s = token[0];
            int dInd = s.indexOf("$");
            if (dInd < 0 || (uInd = s.indexOf("_", dInd)) < 0) continue;
            String tf = HGNC.getSymbol(s = s.substring(dInd + 1, uInd));
            if (tf != null) {
                for (int i = 2; i < token.length; ++i) {
                    MSigDBTFT.addRelation(token[i], tf);
                }
                continue;
            }
            Set<String> family = HGNC.getFamily(s);
            for (String mem : family) {
                for (int i = 2; i < token.length; ++i) {
                    MSigDBTFT.addRelation(token[i], mem);
                }
            }
        }
    }
}

