/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.network;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Scanner;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.analysis.GraphList;
import org.cbio.causality.network.HPRD;
import org.cbio.causality.network.IntAct;
import org.cbio.causality.network.MSigDBTFT;
import org.cbio.causality.network.ReactomeFI;
import org.cbio.causality.network.SPIKE;
import org.cbio.causality.network.SignaLink;
import org.cbio.causality.util.Download;

public class PathwayCommons {
    private static final String url = "http://www.pathwaycommons.org/archives/PC2/v9/PathwayCommons9.All.hgnc.txt.gz";
    private static final String tempFile = "PC.sif";
    private static final String dir = "PC/";

    public static Graph getGraph(SIFType ... types) {
        if (PathwayCommons.fileExists(types)) {
            if (types.length == 1) {
                return PathwayCommons.getSingleGraph(types[0]);
            }
            if (types.length > 1) {
                GraphList graph = new GraphList("Pathway Commons");
                for (SIFType type : types) {
                    graph.addGraph(PathwayCommons.getSingleGraph(type));
                }
                return graph;
            }
        }
        return null;
    }

    public static Graph getSingleGraph(SIFType type) {
        Scanner sc;
        String edgeType = type.getTag();
        Graph graph = new Graph("Pathway Commons", edgeType);
        try {
            sc = new Scanner(new FileInputStream(dir + type.getTag() + ".txt"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] token = line.split("\t");
            if (token.length > 2) {
                graph.putRelation(token[0], token[1], token[2], type.isDirected());
                continue;
            }
            graph.putRelation(token[0], token[1], type.isDirected());
        }
        return graph;
    }

    private static boolean fileExists(SIFType ... types) {
        if (!PathwayCommons.fileExistsJustCheck(types)) {
            if (!new File(tempFile).exists()) {
                Download.downloadAndUncompress(url, tempFile);
            }
            PathwayCommons.extractData();
        }
        return PathwayCommons.fileExistsJustCheck(types);
    }

    private static boolean fileExistsJustCheck(SIFType[] types) {
        boolean present = true;
        for (SIFType type : types) {
            if (new File(dir + type.getTag() + ".txt").exists()) continue;
            present = false;
            break;
        }
        return present;
    }

    private static boolean extractData() {
        try {
            String line;
            Scanner sc = new Scanner(new File(tempFile));
            sc.nextLine();
            HashMap<String, BufferedWriter> writers = new HashMap<String, BufferedWriter>();
            new File(dir).mkdirs();
            while (sc.hasNextLine() && !(line = sc.nextLine()).isEmpty()) {
                String[] token = line.split("\t");
                if (token.length <= 2) continue;
                if (!writers.containsKey(token[1])) {
                    writers.put(token[1], new BufferedWriter(new FileWriter(dir + token[1] + ".txt")));
                }
                ((Writer)writers.get(token[1])).write(token[0] + "\t" + token[2]);
                if (token.length > 6) {
                    ((Writer)writers.get(token[1])).write("\t" + token[6]);
                }
                ((Writer)writers.get(token[1])).write("\n");
            }
            for (Writer writer : writers.values()) {
                writer.close();
            }
            new File(tempFile).delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        PathwayCommons.printNetworkSizes();
    }

    private static void printNetworkSizes() {
        Graph graph = PathwayCommons.getGraph(SIFEnum.values());
        graph.printStats();
    }

    private static void printDataOverlaps() {
        Graph graph = PathwayCommons.getGraph(SIFEnum.CONTROLS_STATE_CHANGE_OF);
        graph.printVennIntersections(true, SPIKE.getGraphPostTl(), SignaLink.getGraphPostTl(), ReactomeFI.getGraphPostTl());
        System.out.println();
        graph = PathwayCommons.getGraph(SIFEnum.CONTROLS_EXPRESSION_OF);
        graph.printVennIntersections(true, SPIKE.getGraphTR(), SignaLink.getGraphPostTl(), ReactomeFI.getGraphTR(), MSigDBTFT.getGraph());
        System.out.println();
        Graph icw = PathwayCommons.getGraph(SIFEnum.IN_COMPLEX_WITH);
        icw.printVennIntersections(false, HPRD.getGraph(), IntAct.getGraph(), ReactomeFI.getGraphPPI());
    }

    private static void printMostConnected(Graph graph, int limit) {
        ArrayList<String> genes = new ArrayList<String>(graph.getSymbols());
        final HashMap<String, Integer> degree = new HashMap<String, Integer>();
        for (String gene : genes) {
            degree.put(gene, graph.getDegree(gene));
        }
        Collections.sort(genes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Integer)degree.get(o2)).compareTo((Integer)degree.get(o1));
            }
        });
        int i = 0;
        for (String gene : genes) {
            System.out.println(gene + "\t" + degree.get(gene));
            if (++i != limit) continue;
            break;
        }
    }
}

