/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.rppa;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cbio.causality.network.PhosphoSitePlus;
import org.cbio.causality.util.ArrayUtil;
import org.cbio.causality.util.StudentsT;
import org.cbio.causality.util.Summary;

public class RPPAData
implements Cloneable {
    public String id;
    public double[][] vals;
    public List<String> genes;
    public Map<String, List<String>> sites;
    public SiteEffect effect;
    private ChangeDetector chDet;
    public String[][] header;
    Type type;

    public RPPAData(String id, double[][] vals, List<String> genes, Map<String, List<String>> sites) {
        this.id = id;
        this.vals = vals;
        this.genes = genes;
        this.sites = sites;
        this.type = sites != null && !sites.isEmpty() ? Type.SITE_SPECIFIC : Type.TOTAL_PROTEIN;
        if (sites == null) {
            return;
        }
        for (String gene : sites.keySet()) {
            for (String site : sites.get(gene)) {
                Integer eff = PhosphoSitePlus.getEffect(gene, site);
                if (eff == null) continue;
                this.effect = SiteEffect.getValue(eff);
                break;
            }
            if (this.effect == null) continue;
            break;
        }
    }

    public void setChDet(ChangeDetector chDet) {
        this.chDet = chDet;
    }

    public boolean isPhospho() {
        return this.type == Type.SITE_SPECIFIC;
    }

    public boolean isTotalProt() {
        return this.type == Type.TOTAL_PROTEIN;
    }

    public boolean isActivity() {
        return this.type == Type.ACTIVITY;
    }

    public int getSelfEffect() {
        if (!this.isPhospho()) {
            return 1;
        }
        if (this.effect == null) {
            return 0;
        }
        return this.effect.getVal();
    }

    public boolean equals(Object obj) {
        return obj instanceof RPPAData && this.id.equals(((RPPAData)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public double getLog2Ratio() {
        if (this.vals[1] == null) {
            throw new UnsupportedOperationException();
        }
        return Math.log(Summary.mean(this.vals[1]) / Summary.mean(this.vals[0])) / Math.log(2.0);
    }

    public double getSignificanceBasedVal() {
        if (this.vals[1] == null) {
            throw new UnsupportedOperationException();
        }
        double pval = this.getTTestPval();
        double ch = Summary.mean(this.vals[1]) - Summary.mean(this.vals[0]);
        double sig = -Math.log(pval) / Math.log(2.0);
        if (ch < 0.0) {
            sig *= -1.0;
        }
        return sig;
    }

    public double getMeanVal() {
        if (this.vals.length > 1 && this.vals[1] != null) {
            throw new UnsupportedOperationException();
        }
        return Summary.mean(this.vals[0]);
    }

    public double getLog2MeanVal() {
        if (this.vals[1] != null) {
            throw new UnsupportedOperationException();
        }
        return Math.log(Summary.mean(this.vals[0])) / Math.log(2.0);
    }

    public double getDifOfMeans() {
        if (this.vals[1] == null) {
            throw new UnsupportedOperationException();
        }
        return Summary.mean(this.vals[1]) - Summary.mean(this.vals[0]);
    }

    public void separateData(boolean[][] subset) {
        if (this.vals.length > 1) {
            throw new UnsupportedOperationException();
        }
        if (this.vals[0].length != subset[0].length || this.vals[0].length != subset[1].length) {
            throw new IllegalArgumentException("Sizes don't match: vals[0].length = " + this.vals[0].length + ", subset[0].length = " + subset[0].length);
        }
        for (int i = 1; i < subset.length; ++i) {
            if (subset[0].length == subset[i].length) continue;
            throw new IllegalArgumentException("Subset array sizes don't match: subset[0].length = " + subset[0].length + ", subset[" + i + "].length = " + subset[i].length);
        }
        double[] all = this.vals[0];
        this.vals = new double[subset.length][];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = this.getValSubset(all, subset[i]);
        }
    }

    private double[] getValSubset(double[] all, boolean[] sub) {
        double[] v = new double[ArrayUtil.countValue(sub, true)];
        int k = 0;
        for (int i = 0; i < sub.length; ++i) {
            if (!sub[i]) continue;
            v[k++] = all[i];
        }
        return v;
    }

    public double getTTestPval() {
        if (this.vals[1] == null) {
            throw new UnsupportedOperationException();
        }
        return StudentsT.getPValOfMeanDifference(this.vals[0], this.vals[1]);
    }

    public int getChangeSign() {
        if (this.chDet == null) {
            throw new UnsupportedOperationException("Please set the change detector (chDet) before calling this method.");
        }
        return this.chDet.getChangeSign(this);
    }

    public double getChangeValue() {
        if (this.chDet == null) {
            throw new UnsupportedOperationException("Please set the change detector (chDet) before calling this method.");
        }
        return this.chDet.getChangeValue(this);
    }

    public int getActvityChangeSign() {
        int eff = !this.isPhospho() ? 1 : (this.effect == null ? 0 : this.effect.getVal());
        return this.getChangeSign() * eff;
    }

    public void makeActivityNode(boolean isActivated) {
        this.type = Type.ACTIVITY;
        this.vals = new double[][]{new double[1]};
        this.vals[0][0] = isActivated ? 1.0 : -1.0;
        this.setChDet(new DefaultActivityDet());
        this.effect = null;
        this.sites = null;
    }

    public Object clone() {
        try {
            RPPAData clone = (RPPAData)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.id;
    }

    public static void write(Collection<RPPAData> datas, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write("ID\tSymbol\tSite\tEffect");
            Iterator<RPPAData> iter = datas.iterator();
            RPPAData sample = iter.next();
            while (sample.isActivity()) {
                sample = iter.next();
            }
            for (int j = 0; j < sample.vals.length; ++j) {
                String[] header = sample.header == null ? null : sample.header[j];
                for (int i = 0; i < sample.vals[j].length; ++i) {
                    writer.write(header == null ? "\tv" + j + "-" + i : "\t" + header[i]);
                }
            }
            for (RPPAData data : datas) {
                if (data.isActivity()) continue;
                writer.write("\n" + data.id);
                String items = new ArrayList<String>(data.genes).toString().replace(",", "").replace("[", "").replace("]", "");
                writer.write("\t" + items);
                if (data.sites != null) {
                    ArrayList<String> siteList = new ArrayList<String>();
                    for (String gene : data.sites.keySet()) {
                        List<String> ss = data.sites.get(gene);
                        String s = ss.toString().replace("[", "").replace("]", "").replace(", ", "|");
                        siteList.add(s);
                    }
                    items = ((Object)siteList).toString().replace(",", "").replace("[", "").replace("]", "");
                    writer.write("\t" + items);
                    writer.write("\t" + (data.effect == null ? "" : (data.effect == SiteEffect.COMPLEX ? "c" : (data.effect == SiteEffect.ACTIVATING ? "a" : "i"))));
                } else {
                    writer.write("\t\t");
                }
                double[][] arr$ = data.vals;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    double[] vals;
                    for (double v : vals = arr$[i$]) {
                        writer.write("\t" + v);
                    }
                }
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void shuffleValues(Collection<RPPAData> datas) {
        ArrayList<RPPAData> list = new ArrayList<RPPAData>();
        for (RPPAData data : datas) {
            if (data.isActivity()) continue;
            list.add(data);
        }
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (int i = 0; i < datas.size(); ++i) {
            index.add(i);
        }
        Collections.shuffle(index);
        RPPAData d0 = (RPPAData)list.get((Integer)index.get(0));
        double[][] v = d0.vals;
        for (int i = 1; i < index.size(); ++i) {
            RPPAData dd = (RPPAData)list.get((Integer)index.get(i));
            double[][] temp = dd.vals;
            dd.vals = v;
            v = temp;
        }
        d0.vals = v;
    }

    public static List<RPPAData> copy(List<RPPAData> orig) {
        ArrayList<RPPAData> list = new ArrayList<RPPAData>();
        for (RPPAData data : orig) {
            list.add((RPPAData)data.clone());
        }
        return list;
    }

    public static enum Type {
        TOTAL_PROTEIN,
        SITE_SPECIFIC,
        ACTIVITY,
        EXPRESSION;

    }

    public static class TTestDetector
    extends ChangeAdapter {
        @Override
        public int getChangeSign(RPPAData data) {
            double pval = data.getTTestPval();
            if (pval > this.threshold) {
                return 0;
            }
            if (this.getChangeValue(data) > 0.0) {
                return 1;
            }
            return -1;
        }

        @Override
        public double getChangeValue(RPPAData data) {
            return data.getSignificanceBasedVal();
        }
    }

    public static abstract class ChangeAdapter
    implements ChangeDetector {
        protected double threshold;

        @Override
        public int getChangeSign(RPPAData data) {
            double val = this.getChangeValue(data);
            if (val >= this.threshold) {
                return 1;
            }
            if (val <= -this.threshold) {
                return -1;
            }
            return 0;
        }

        @Override
        public double getChangeValue(RPPAData data) {
            return data.getMeanVal();
        }

        public void setThreshold(double threshold) {
            this.threshold = threshold;
        }
    }

    public class DefaultActivityDet
    implements ChangeDetector {
        @Override
        public int getChangeSign(RPPAData data) {
            return (int)RPPAData.this.vals[0][0];
        }

        @Override
        public double getChangeValue(RPPAData data) {
            return RPPAData.this.vals[0][0];
        }
    }

    public static interface ChangeDetector {
        public int getChangeSign(RPPAData var1);

        public double getChangeValue(RPPAData var1);
    }

    public static enum SiteEffect {
        ACTIVATING(1),
        INHIBITING(-1),
        COMPLEX(0);

        int val;

        private SiteEffect(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }

        public static SiteEffect getValue(int x) {
            for (SiteEffect effect : SiteEffect.values()) {
                if (effect.val != x) continue;
                return effect;
            }
            return null;
        }
    }
}

