/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.rppa;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.analysis.Graph;
import org.cbio.causality.analysis.PhosphoGraph;
import org.cbio.causality.analysis.Relation;
import org.cbio.causality.network.SignedPC;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.signednetwork.SignedType;

public class RPPANetworkMapper {
    private static Map<SignedType, Graph> graph;
    private static final Color MIN_UP;
    private static final Color MIN_DOWN;
    private static final Color MAX_UP;
    private static final Color MAX_DOWN;
    private static final DecimalFormat FMT;

    public static List<Relation> map(Collection<RPPAData> data) {
        ArrayList<Relation> rels = new ArrayList<Relation>();
        if (graph == null) {
            graph = SignedPC.getAllGraphs();
        }
        for (RPPAData d1 : data) {
            RPPANetworkMapper.findRelations(d1, data, rels);
        }
        return rels;
    }

    private static void findRelations(RPPAData d1, Collection<RPPAData> data, List<Relation> rels) {
        for (RPPAData d2 : data) {
            if (d1 == d2 || ((Object)d1.genes).equals(d2.genes)) continue;
            for (String source : d1.genes) {
                for (String target : d2.genes) {
                    if (source.equals(target)) continue;
                    for (SignedType type : graph.keySet()) {
                        if (!graph.get(type).getDownstream(source).contains(target)) continue;
                        boolean match = false;
                        int sign = 0;
                        switch (type) {
                            case PHOSPHORYLATES: {
                                if (!d2.isPhospho()) break;
                                match = true;
                                sign = d1.getSelfEffect();
                                break;
                            }
                            case DEPHOSPHORYLATES: {
                                if (!d2.isPhospho()) break;
                                match = true;
                                sign = -d1.getSelfEffect();
                                break;
                            }
                            case UPREGULATES_EXPRESSION: {
                                if (!d2.isTotalProt()) break;
                                match = true;
                                sign = d1.getSelfEffect();
                                break;
                            }
                            case DOWNREGULATES_EXPRESSION: {
                                if (!d2.isTotalProt()) break;
                                match = true;
                                sign = -d1.getSelfEffect();
                            }
                        }
                        if (!match) continue;
                        Set<String> sites = graph.get(type) instanceof PhosphoGraph ? ((PhosphoGraph)graph.get(type)).getSites(source, target) : null;
                        rels.add(new Relation(source, target, type, d1, d2, sign, graph.get(type).getMediatorsInString(source, target), sites));
                    }
                }
            }
        }
    }

    public static void removeConflictingAndInsignificant(List<Relation> rels) {
        Iterator<Relation> iter = rels.iterator();
        while (iter.hasNext()) {
            Relation rel = iter.next();
            if (!rel.dataChangesAsUnxpected() && !rel.dataChangesInsignificant()) continue;
            iter.remove();
        }
    }

    public static void keepMatching(List<Relation> rels, boolean siteMatch) {
        Iterator<Relation> iter = rels.iterator();
        while (iter.hasNext()) {
            Relation rel = iter.next();
            if (!rel.dataChangesAsExpected()) {
                iter.remove();
                continue;
            }
            if (!siteMatch || rel.siteMatches()) continue;
            iter.remove();
        }
    }

    public static void keepConflicting(List<Relation> rels, boolean siteMatch) {
        Iterator<Relation> iter = rels.iterator();
        while (iter.hasNext()) {
            Relation rel = iter.next();
            if (!rel.dataChangesAsUnxpected()) {
                iter.remove();
                continue;
            }
            if (!siteMatch || rel.siteMatches()) continue;
            iter.remove();
        }
    }

    public static void keepChangedEndsOnly(List<Relation> rels) {
        Iterator<Relation> iter = rels.iterator();
        while (iter.hasNext()) {
            Relation rel = iter.next();
            if (rel.sourceData.getChangeSign() != 0 && rel.targetData.getChangeSign() != 0) continue;
            iter.remove();
        }
    }

    public static void cropTo(List<Relation> rels, Collection<String> cropTo) {
        Iterator<Relation> iter = rels.iterator();
        while (iter.hasNext()) {
            Relation rel = iter.next();
            if (cropTo.contains(rel.source) || cropTo.contains(rel.target)) continue;
            iter.remove();
        }
    }

    public static void removeConflictingActivities(List<Relation> rels, Collection<RPPAData> datas) {
        Map<String, Integer> map = RPPANetworkMapper.readActivities(datas);
        Iterator<Relation> iter = rels.iterator();
        while (iter.hasNext()) {
            Relation rel = iter.next();
            if (!map.containsKey(rel.source) || rel.sourceData.getActvityChangeSign() == map.get(rel.source).intValue()) continue;
            iter.remove();
        }
    }

    public static void writeGraph(Collection<RPPAData> datas, double thresholdVal, String filename, GraphType type, Collection<String> cropTo) throws IOException {
        BufferedWriter writer;
        RPPANetworkMapper.checkForDuplicateTotalProt(datas);
        List<Relation> relations = RPPANetworkMapper.map(datas);
        if (cropTo != null && !cropTo.isEmpty()) {
            RPPANetworkMapper.cropTo(relations, cropTo);
        }
        RPPANetworkMapper.filterToDesiredSubset(relations, datas, type);
        System.out.println("causative relations = " + relations.size());
        HashSet<String> nodesInRels = new HashSet<String>();
        HashSet<String> activated = new HashSet<String>();
        HashSet<String> inactivated = new HashSet<String>();
        HashSet<String> sifLines = new HashSet<String>();
        for (Relation rel : relations) {
            sifLines.add(rel.getEdgeData());
            nodesInRels.addAll(rel.sourceData.genes);
            nodesInRels.addAll(rel.targetData.genes);
            int sign = rel.sourceData.getActvityChangeSign();
            if (sign == 1) {
                activated.add(rel.source);
                continue;
            }
            if (sign != -1) continue;
            inactivated.add(rel.source);
        }
        if (type != GraphType.EXISTING_NETWORK) {
            writer = new BufferedWriter(new FileWriter(filename));
            for (String line : sifLines) {
                writer.write(line + "\n");
            }
            for (RPPAData data : datas) {
                if (data.getChangeSign() == 0) continue;
                for (String gene : data.genes) {
                    if (nodesInRels.contains(gene)) continue;
                    writer.write(gene + "\n");
                    nodesInRels.add(gene);
                }
            }
            writer.close();
        }
        filename = filename.substring(0, filename.lastIndexOf(".")) + ".format";
        writer = new BufferedWriter(new FileWriter(filename));
        writer.write("node\tall-nodes\tcolor\t255 255 255\n");
        for (Relation rel : relations) {
            writer.write("edge\t" + rel.source + " " + rel.edgeType.getTag() + " " + rel.target + "\tcolor\t" + RPPANetworkMapper.getEdgeColor(rel.edgeType) + "\n");
        }
        double maxVal = 0.0;
        for (RPPAData data : datas) {
            double val = Math.abs(data.getChangeValue());
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        Map<String, RPPAData> totalProtMap = RPPANetworkMapper.getTotalProtMapping(datas);
        for (RPPAData data : datas) {
            for (String gene : data.genes) {
                String bor;
                String colS;
                int changeSign = data.getChangeSign();
                if (data.isPhospho() || data.isTotalProt() && totalProtMap.get(gene) != data) {
                    colS = RPPANetworkMapper.getColor(data.getChangeValue(), thresholdVal, maxVal, changeSign > 0 ? MIN_UP : MIN_DOWN, changeSign > 0 ? MAX_UP : MAX_DOWN);
                    bor = data.effect == null || data.effect == RPPAData.SiteEffect.COMPLEX ? "0 0 0" : (data.effect == RPPAData.SiteEffect.ACTIVATING ? "0 180 20" : "180 0 20");
                    String let = data.isPhospho() ? "p" : "t";
                    writer.write("node\t" + gene + "\trppasite\t" + data.id + "(" + FMT.format(data.getChangeValue()) + ")|" + let + "|" + colS + "|" + bor + "\n");
                    continue;
                }
                if (data.isActivity()) {
                    colS = "255 255 255";
                    bor = changeSign > 0 ? "0 180 20" : "180 0 20";
                    writer.write("node\t" + gene + "\trppasite\t" + data.id + "|" + (changeSign > 0 ? "a" : "i") + "|" + colS + "|" + bor + "\n");
                    continue;
                }
                writer.write("node\t" + gene + "\tcolor\t" + RPPANetworkMapper.getColor(data.getChangeValue(), thresholdVal, maxVal, changeSign > 0 ? MIN_UP : MIN_DOWN, changeSign > 0 ? MAX_UP : MAX_DOWN) + "\n");
                writer.write("node\t" + gene + "\ttooltip\t" + data.id + "(" + FMT.format(data.getChangeValue()) + ")\n");
            }
        }
        for (String name : activated) {
            if (!inactivated.contains(name)) continue;
            writer.write("node\t" + name + "\tbordercolor\t180 100 100\n");
        }
        writer.close();
    }

    public static void writeGraphAntibodyCentric(Collection<RPPAData> datas, double thresholdVal, String filename, GraphType type, Collection<String> cropTo) throws IOException {
        RPPANetworkMapper.checkForDuplicateTotalProt(datas);
        List<Relation> relations = RPPANetworkMapper.map(datas);
        if (cropTo != null && !cropTo.isEmpty()) {
            RPPANetworkMapper.cropTo(relations, cropTo);
        }
        RPPANetworkMapper.filterToDesiredSubset(relations, datas, type);
        System.out.println("causative relations = " + relations.size());
        BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
        for (Relation rel : relations) {
            writer.write(rel.getEdgeDataAntibodyCentric() + "\n");
        }
        for (RPPAData data : datas) {
            if (data.getChangeSign() == 0) continue;
            writer.write(data.id + "\n");
        }
        writer.close();
        filename = filename.substring(0, filename.lastIndexOf(".")) + ".format";
        writer = new BufferedWriter(new FileWriter(filename));
        writer.write("node\tall-nodes\tcolor\t255 255 255\n");
        for (Relation rel : relations) {
            writer.write("edge\t" + rel.sourceData.id + " " + rel.edgeType.getTag() + " " + rel.targetData.id + "\tcolor\t" + RPPANetworkMapper.getEdgeColor(rel.edgeType) + "\n");
        }
        double maxVal = 0.0;
        for (RPPAData data : datas) {
            double val = Math.abs(data.getChangeValue());
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        for (RPPAData data : datas) {
            String id = data.id;
            int changeSign = data.getChangeSign();
            writer.write("node\t" + id + "\tcolor\t" + RPPANetworkMapper.getColor(data.getChangeValue(), thresholdVal, maxVal, changeSign > 0 ? MIN_UP : MIN_DOWN, changeSign > 0 ? MAX_UP : MAX_DOWN) + "\n");
            writer.write("node\t" + id + "\ttooltip\t" + data.id + "(" + FMT.format(data.getChangeValue()) + ")\n");
        }
        writer.close();
    }

    private static void filterToDesiredSubset(List<Relation> relations, Collection<RPPAData> datas, GraphType type) {
        switch (type) {
            case COMPATIBLE: {
                RPPANetworkMapper.keepMatching(relations, false);
                break;
            }
            case COMPATIBLE_WITH_SITE_MATCH: {
                RPPANetworkMapper.keepMatching(relations, true);
                break;
            }
            case CONFLICTING: {
                RPPANetworkMapper.keepConflicting(relations, false);
                break;
            }
            case CONFLICTING_WITH_SITE_MATCH: {
                RPPANetworkMapper.keepConflicting(relations, true);
                break;
            }
            case NON_CONFLICTING: {
                RPPANetworkMapper.removeConflictingAndInsignificant(relations);
                break;
            }
            case CHANGED_ONLY: {
                RPPANetworkMapper.keepChangedEndsOnly(relations);
            }
        }
        if (type == GraphType.COMPATIBLE || type == GraphType.COMPATIBLE_WITH_SITE_MATCH) {
            RPPANetworkMapper.removeConflictingActivities(relations, datas);
        }
    }

    private static String getColor(double val, double minVal, double maxVal, Color minCol, Color maxCol) {
        if ((val = Math.abs(val)) < minVal) {
            return "250 250 250";
        }
        double ratio = (val - minVal) / (maxVal - minVal);
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        return (int)Math.round((double)minCol.getRed() + ratio * (double)(maxCol.getRed() - minCol.getRed())) + " " + (int)Math.round((double)minCol.getGreen() + ratio * (double)(maxCol.getGreen() - minCol.getGreen())) + " " + (int)Math.round((double)minCol.getBlue() + ratio * (double)(maxCol.getBlue() - minCol.getBlue()));
    }

    private static String getEdgeColor(SignedType type) {
        switch (type) {
            case PHOSPHORYLATES: 
            case UPREGULATES_EXPRESSION: {
                return "0 100 0";
            }
            case DEPHOSPHORYLATES: 
            case DOWNREGULATES_EXPRESSION: {
                return "100 0 0";
            }
        }
        return null;
    }

    protected static Map<String, Set<RPPAData>> getGeneToRPPAMap(Collection<RPPAData> datas) {
        HashMap<String, Set<RPPAData>> map = new HashMap<String, Set<RPPAData>>();
        for (RPPAData data : datas) {
            for (String gene : data.genes) {
                if (!map.containsKey(gene)) {
                    map.put(gene, new HashSet());
                }
                ((Set)map.get(gene)).add(data);
            }
        }
        return map;
    }

    protected static Set<String> findChangingGenesInConflict(Map<String, Set<RPPAData>> map) {
        HashSet<String> set = new HashSet<String>();
        for (String gene : map.keySet()) {
            boolean up = false;
            boolean down = false;
            for (RPPAData data : map.get(gene)) {
                int sign = data.getActvityChangeSign();
                if (sign > 0) {
                    up = true;
                    continue;
                }
                if (sign >= 0) continue;
                down = true;
            }
            if (!up || !down) continue;
            set.add(gene);
        }
        return set;
    }

    protected static Set<RPPAData> getCropped(Collection<RPPAData> datas, Set<String> genes) {
        HashSet<RPPAData> set = new HashSet<RPPAData>();
        block0: for (RPPAData data : datas) {
            for (String gene : data.genes) {
                if (!genes.contains(gene)) continue;
                set.add(data);
                continue block0;
            }
        }
        return set;
    }

    protected static Map<String, Integer> readActivities(Collection<RPPAData> datas) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (RPPAData data : datas) {
            if (!data.isActivity()) continue;
            for (String gene : data.genes) {
                map.put(gene, data.getActvityChangeSign());
            }
        }
        return map;
    }

    protected static Set<Relation> getUndersupportedRelations(Collection<Relation> rels, Set<RPPAData> datas) {
        HashMap actSupport = new HashMap();
        HashMap inaSupport = new HashMap();
        HashMap actRels = new HashMap();
        HashMap inaRels = new HashMap();
        for (Relation rel : rels) {
            if (!datas.contains(rel.sourceData)) continue;
            HashMap map = null;
            HashMap relMap = null;
            if (rel.dataChangesAsExpected() && rel.siteMatches()) {
                if (rel.sourceData.getActvityChangeSign() > 0) {
                    map = actSupport;
                    relMap = actRels;
                } else if (rel.sourceData.getActvityChangeSign() < 0) {
                    map = inaSupport;
                    relMap = inaRels;
                }
            }
            if (map == null) continue;
            if (!map.containsKey(rel.source)) {
                map.put(rel.source, new HashSet());
            }
            ((Set)map.get(rel.source)).add(rel.target);
            if (!relMap.containsKey(rel.source)) {
                relMap.put(rel.source, new HashSet());
            }
            ((Set)relMap.get(rel.source)).add(rel);
        }
        HashSet genes = new HashSet(actSupport.keySet());
        genes.addAll(inaSupport.keySet());
        HashSet<Relation> under = new HashSet<Relation>();
        for (String gene : genes) {
            int actCnt = actSupport.containsKey(gene) ? ((Set)actSupport.get(gene)).size() : 0;
            int inaCnt = inaSupport.containsKey(gene) ? ((Set)inaSupport.get(gene)).size() : 0;
            System.out.println("gene = " + gene + "\tact = " + actCnt + "\tina = " + inaCnt);
            if (actCnt > 0 && actCnt < inaCnt) {
                under.addAll((Collection)actRels.get(gene));
                continue;
            }
            if (inaCnt <= 0 || actCnt <= inaCnt) continue;
            under.addAll((Collection)inaRels.get(gene));
        }
        return under;
    }

    protected static void checkForDuplicateTotalProt(Collection<RPPAData> datas) {
        HashMap map = new HashMap();
        for (RPPAData data : datas) {
            if (!data.isTotalProt()) continue;
            for (String gene : data.genes) {
                if (!map.containsKey(gene)) {
                    map.put(gene, new HashSet());
                }
                ((Set)map.get(gene)).add(data);
            }
        }
        for (String gene : map.keySet()) {
            Set set = (Set)map.get(gene);
            if (set.size() <= 1) continue;
            System.out.print("Multiple total protein for sym " + gene + ":");
            for (RPPAData d : set) {
                System.out.print("    " + d.id);
            }
            System.out.println();
        }
    }

    protected static Map<String, RPPAData> getTotalProtMapping(Collection<RPPAData> datas) {
        HashMap<String, RPPAData> map = new HashMap<String, RPPAData>();
        for (RPPAData data : datas) {
            if (!data.isTotalProt()) continue;
            for (String gene : data.genes) {
                if (map.containsKey(gene)) continue;
                map.put(gene, data);
            }
        }
        return map;
    }

    public static Map<String, int[]> getDownstreamActivitySupportCounts(Collection<RPPAData> data, GraphType type) {
        if (graph == null) {
            graph = SignedPC.getAllGraphs();
        }
        HashMap<String, int[]> count = new HashMap<String, int[]>();
        HashSet<String> symbols = new HashSet<String>();
        for (RPPAData d : data) {
            symbols.addAll(d.genes);
        }
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (String symbol : symbols) {
            relations.clear();
            RPPAData d = new RPPAData(symbol + "-act", null, Arrays.asList(symbol), null);
            d.makeActivityNode(true);
            RPPANetworkMapper.findRelations(d, data, relations);
            RPPANetworkMapper.filterToDesiredSubset(relations, data, type);
            int act = relations.size();
            relations.clear();
            d = new RPPAData(symbol + "-inh", null, Arrays.asList(symbol), null);
            d.makeActivityNode(false);
            RPPANetworkMapper.findRelations(d, data, relations);
            RPPANetworkMapper.filterToDesiredSubset(relations, data, type);
            int inh = relations.size();
            count.put(symbol, new int[]{act, inh});
        }
        for (String symbol : count.keySet()) {
            System.out.println(symbol + "\t" + ((int[])count.get(symbol))[0] + "\t" + ((int[])count.get(symbol))[1]);
        }
        return count;
    }

    public static List<Integer> getNullGraphSizes(List<RPPAData> datas, int iteration, GraphType type) {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (int i = 0; i < iteration; ++i) {
            RPPAData.shuffleValues(datas);
            List<Relation> relations = RPPANetworkMapper.map(datas);
            RPPANetworkMapper.filterToDesiredSubset(relations, datas, type);
            sizes.add(relations.size());
        }
        Collections.sort(sizes);
        Collections.reverse(sizes);
        return sizes;
    }

    static {
        MIN_UP = new Color(255, 210, 210);
        MIN_DOWN = new Color(210, 210, 255);
        MAX_UP = new Color(255, 80, 40);
        MAX_DOWN = new Color(40, 80, 255);
        FMT = new DecimalFormat("0.##");
    }

    public static enum GraphType {
        EXISTING_NETWORK,
        ALL_INCLUSIVE,
        CHANGED_ONLY,
        NON_CONFLICTING,
        COMPATIBLE,
        COMPATIBLE_WITH_SITE_MATCH,
        CONFLICTING,
        CONFLICTING_WITH_SITE_MATCH;

    }
}

