/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.signednetwork;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.cbio.causality.signednetwork.EN1;
import org.cbio.causality.signednetwork.EN2;
import org.cbio.causality.signednetwork.EP1;
import org.cbio.causality.signednetwork.EP2;
import org.cbio.causality.signednetwork.PN1;
import org.cbio.causality.signednetwork.PN2;
import org.cbio.causality.signednetwork.PN3;
import org.cbio.causality.signednetwork.PN4;
import org.cbio.causality.signednetwork.PP1;
import org.cbio.causality.signednetwork.PP2;
import org.cbio.causality.signednetwork.PP3;
import org.cbio.causality.signednetwork.PP4;
import org.cbio.causality.signednetwork.SignedSIFInteraction;
import org.cbio.causality.util.Kronometre;

public class Generator {
    public static void main(String[] args) throws IOException {
        SimpleIOHandler h = new SimpleIOHandler(BioPAXLevel.L3);
        Model model = h.convertFromOWL(new FileInputStream("../biopax-pattern/Pathway Commons.6.Detailed_Process_Data.BIOPAX.owl"));
        System.out.println("Model size = " + model.getObjects().size());
        Blacklist blacklist = new Blacklist("../biopax-pattern/blacklist.txt");
        Generator.generate(model, blacklist, "SignedPC.sif");
    }

    public static void generate(Model model, Blacklist blacklist, String outFile) throws IOException {
        Kronometre kron = new Kronometre();
        SIFSearcher searcher = new SIFSearcher(new PP1(), new PP2(), new PP3(), new PP4());
        searcher.setBlacklist(blacklist);
        Set<SIFInteraction> pp = searcher.searchSIF(model);
        System.out.println("Positive phosho = " + pp.size());
        searcher = new SIFSearcher(new PN1(), new PN2(), new PN3(), new PN4());
        searcher.setBlacklist(blacklist);
        Set<SIFInteraction> pn = searcher.searchSIF(model);
        System.out.println("Negative phosho = " + pn.size());
        Generator.decideConflictingPhosphorylation(pp, pn);
        searcher = new SIFSearcher(new EP1(), new EP2());
        searcher.setBlacklist(blacklist);
        Set<SIFInteraction> ep = searcher.searchSIF(model);
        System.out.println("Positive expression = " + ep.size());
        searcher = new SIFSearcher(new EN1(), new EN2());
        searcher.setBlacklist(blacklist);
        Set<SIFInteraction> en = searcher.searchSIF(model);
        System.out.println("Negative expression " + en.size());
        Generator.decideConflictingExpression(ep, en);
        HashSet<SIFInteraction> sifs = new HashSet<SIFInteraction>();
        sifs.addAll(pp);
        sifs.addAll(pn);
        sifs.addAll(ep);
        sifs.addAll(en);
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        for (SIFInteraction sif : sifs) {
            writer.write(sif.toString() + "\n");
        }
        writer.close();
        kron.stop();
        kron.print();
    }

    private static void decideConflictingPhosphorylation(Set<SignedSIFInteraction> pos, Set<SignedSIFInteraction> neg) {
        Set<String> ov = Generator.getWOTypes(pos);
        ov.retainAll(Generator.getWOTypes(neg));
        System.out.println("\noverlap size = " + ov.size());
        Map<String, SignedSIFInteraction> posSIFs = Generator.mapSIFs(pos, ov);
        Map<String, SignedSIFInteraction> negSIFs = Generator.mapSIFs(neg, ov);
        assert (posSIFs.size() == negSIFs.size());
        HashSet<String> posRem = new HashSet<String>();
        HashSet<String> negRem = new HashSet<String>();
        for (String key : posSIFs.keySet()) {
            SignedSIFInteraction posSIF = posSIFs.get(key);
            SignedSIFInteraction negSIF = negSIFs.get(key);
            if (posSIF.p2med.isEmpty() && negSIF.mediators.size() > posSIF.mediators.size()) {
                posRem.add(key);
                continue;
            }
            if (negSIF.p2med.isEmpty() && negSIF.mediators.size() < posSIF.mediators.size()) {
                negRem.add(key);
                continue;
            }
            HashSet<String> phs = new HashSet<String>(posSIF.p2med.keySet());
            phs.retainAll(negSIF.p2med.keySet());
            HashMap<String, SignedSIFInteraction> decision = new HashMap<String, SignedSIFInteraction>();
            for (String ph : phs) {
                if (posSIF.p2med.get(ph).size() > negSIF.p2med.get(ph).size()) {
                    decision.put(ph, posSIF);
                    continue;
                }
                if (posSIF.p2med.get(ph).size() >= negSIF.p2med.get(ph).size()) continue;
                decision.put(ph, negSIF);
            }
            for (String ph : decision.keySet()) {
                if (decision.get(ph) == posSIF) {
                    negSIF.mediators.removeAll((Collection)negSIF.p2med.get(ph));
                    negSIF.changedPhospho.remove(ph);
                    negSIF.p2med.remove(ph);
                    continue;
                }
                posSIF.mediators.removeAll((Collection)posSIF.p2med.get(ph));
                posSIF.changedPhospho.remove(ph);
                posSIF.p2med.remove(ph);
            }
        }
        Generator.removeDecided(pos, posRem);
        Generator.removeDecided(neg, negRem);
        System.out.println("decided = " + (posRem.size() + negRem.size()));
    }

    private static Map<String, SignedSIFInteraction> mapSIFs(Set<SignedSIFInteraction> sifs, Set<String> keys) {
        HashMap<String, SignedSIFInteraction> map = new HashMap<String, SignedSIFInteraction>();
        for (SignedSIFInteraction sif : sifs) {
            String key = sif.sourceID + "\t" + sif.targetID;
            if (!keys.contains(key)) continue;
            map.put(key, sif);
        }
        return map;
    }

    private static void decideConflictingExpression(Set<SIFInteraction> pos, Set<SIFInteraction> neg) {
        Set<String> ov = Generator.getWOTypes(pos);
        ov.retainAll(Generator.getWOTypes(neg));
        System.out.println("\noverlap size = " + ov.size());
        Map<String, Integer> posScore = Generator.countMediators(pos, ov);
        Map<String, Integer> negScore = Generator.countMediators(neg, ov);
        assert (posScore.size() == negScore.size());
        HashSet<String> posSet = new HashSet<String>();
        HashSet<String> negSet = new HashSet<String>();
        for (String key : posScore.keySet()) {
            if (posScore.get(key) > negScore.get(key)) {
                posSet.add(key);
                continue;
            }
            if (posScore.get(key) >= negScore.get(key)) continue;
            negSet.add(key);
        }
        Generator.removeDecided(pos, negSet);
        Generator.removeDecided(neg, posSet);
        System.out.println("decided = " + (posSet.size() + negSet.size()));
    }

    private static Map<String, Integer> countMediators(Set<SIFInteraction> sifs, Set<String> st) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SIFInteraction sif : sifs) {
            String key = sif.sourceID + "\t" + sif.targetID;
            if (!st.contains(key)) continue;
            map.put(key, sif.mediators.size());
        }
        return map;
    }

    private static void removeDecided(Set<? extends SIFInteraction> sifs, Set<String> keys) {
        Iterator<? extends SIFInteraction> iter = sifs.iterator();
        while (iter.hasNext()) {
            SIFInteraction sif = iter.next();
            String key = sif.sourceID + "\t" + sif.targetID;
            if (!keys.contains(key)) continue;
            iter.remove();
        }
    }

    private static String woType(SIFInteraction sif) {
        return sif.sourceID + "\t" + sif.targetID;
    }

    private static Set<String> getWOTypes(Set<? extends SIFInteraction> sifs) {
        HashSet<String> set = new HashSet<String>(sifs.size());
        for (SIFInteraction sIFInteraction : sifs) {
            set.add(Generator.woType(sIFInteraction));
        }
        return set;
    }
}

