/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.signednetwork;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.constraint.AND;
import org.biopax.paxtools.pattern.constraint.ConBox;
import org.biopax.paxtools.pattern.constraint.ModificationChangeConstraint;
import org.biopax.paxtools.pattern.constraint.NOT;
import org.biopax.paxtools.pattern.constraint.OR;
import org.biopax.paxtools.pattern.miner.ControlsStateChangeOfMiner;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.DifferentialModificationUtil;
import org.cbio.causality.signednetwork.ControlSignConstraint;
import org.cbio.causality.signednetwork.SignedSIFInteraction;
import org.cbio.causality.signednetwork.SignedType;

public class PP1
extends ControlsStateChangeOfMiner {
    public PP1() {
        this.setType(SignedType.PHOSPHORYLATES);
    }

    @Override
    public Pattern constructPattern() {
        Pattern p = super.constructPattern();
        p.add((Constraint)new NOT(ConBox.linkToSpecific()), "input PE", "output simple PE");
        p.add((Constraint)new NOT(ConBox.linkToSpecific()), "output PE", "input simple PE");
        p.add((Constraint)new OR(new MappedConst(new AND(new MappedConst(new ControlSignConstraint(ControlSignConstraint.Sign.POSITIVE), 0), new MappedConst(new ModificationChangeConstraint(ModificationChangeConstraint.Type.GAIN, "phospho"), 1, 2)), 0, 1, 2), new MappedConst(new AND(new MappedConst(new ControlSignConstraint(ControlSignConstraint.Sign.NEGATIVE), 0), new MappedConst(new ModificationChangeConstraint(ModificationChangeConstraint.Type.LOSS, "phospho"), 1, 2)), 0, 1, 2)), "Control", "input simple PE", "output simple PE");
        return p;
    }

    @Override
    public Set<SIFInteraction> createSIFInteraction(Match m, IDFetcher fetcher) {
        BioPAXElement sourceER = m.get(this.getSourceLabel(), this.getPattern());
        BioPAXElement targetER = m.get(this.getTargetLabel(), this.getPattern());
        Set<String> sources = fetcher.fetchID(sourceER);
        Set<String> targets = fetcher.fetchID(targetER);
        SIFType sifType = this.getSIFType();
        HashSet<SIFInteraction> set = new HashSet<SIFInteraction>();
        for (String source : sources) {
            for (String target : targets) {
                if (source.equals(target)) continue;
                set.add(new SignedSIFInteraction(source, target, sourceER, targetER, sifType, new HashSet<BioPAXElement>(m.get(this.getMediatorLabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getSourcePELabels(), this.getPattern())), new HashSet<BioPAXElement>(m.get(this.getTargetPELabels(), this.getPattern())), DifferentialModificationUtil.collectChangedPhosphorylationSites((PhysicalEntity)m.get("input simple PE", this.getPattern()), (PhysicalEntity)m.get("output simple PE", this.getPattern()), this.getSIFType().equals(SignedType.PHOSPHORYLATES))));
            }
        }
        return set;
    }
}

