/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import org.apache.commons.math.MathException;

public class ChiSquare {
    public static double pValue(double x, double n) {
        if (n == 1.0 && x > 1000.0) {
            return 0.0;
        }
        if (x > 1000.0 || n > 1000.0) {
            double q = ChiSquare.pValue((x - n) * (x - n) / (2.0 * n), 1.0) / 2.0;
            if (x > n) {
                return q;
            }
            return 1.0 - q;
        }
        double p = Math.exp(-0.5 * x);
        if (n % 2.0 == 1.0) {
            p *= Math.sqrt(2.0 * x / Math.PI);
        }
        for (double k = n; k >= 2.0; k -= 2.0) {
            p = p * x / k;
        }
        double t = p;
        double a = n;
        while (t > 1.0E-10 * p) {
            t = t * x / (a += 2.0);
            p += t;
        }
        return 1.0 - p;
    }

    public static void main(String[] args) throws MathException {
        System.out.println(ChiSquare.pValue(20.0, 6.0));
    }
}

