/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cbio.causality.util.FormatUtil;

public class CollectionUtil {
    public static List<String> getSortedList(final Map<String, Double> map) {
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Double v2;
                Double v1 = (Double)map.get(o1);
                if (v1.equals(v2 = (Double)map.get(o2))) {
                    return o1.compareTo(o2);
                }
                return v1.compareTo(v2);
            }
        });
        return list;
    }

    public static boolean intersects(Collection<?> col1, Collection<?> col2) {
        for (Object o : col1) {
            if (!col2.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static int countOverlap(Collection<?> col1, Collection<?> col2) {
        int cnt = 0;
        for (Object o : col1) {
            if (!col2.contains(o)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int[] getVennCounts(Collection<?> col1, Collection<?> col2) {
        HashSet set1 = new HashSet(col1);
        HashSet set2 = new HashSet(col2);
        HashSet inter = new HashSet(set1);
        inter.retainAll(set2);
        return new int[]{set1.size() - inter.size(), set2.size() - inter.size(), inter.size()};
    }

    public static <T extends Comparable> void printVennSets(Collection<T> ... col) {
        int[] cnt = CollectionUtil.getVennCounts(col);
        Set<T>[] venn = CollectionUtil.getVennSets(col);
        String[] name = CollectionUtil.getSetNamesArray(col.length);
        for (int i = 0; i < cnt.length; ++i) {
            ArrayList<T> list = new ArrayList<T>(venn[i]);
            Collections.sort(list);
            System.out.print(name[i] + "\t" + cnt[i] + "\t" + list);
            if (i < col.length) {
                System.out.print("\t" + FormatUtil.roundToSignificantDigits((double)cnt[i] / (double)col[i].size() * 100.0, 3));
            }
            System.out.println();
        }
    }

    public static <T extends Comparable> void printVennCounts(Collection<T> ... col) {
        int[] cnt = CollectionUtil.getVennCounts(col);
        String[] name = CollectionUtil.getSetNamesArray(col.length);
        for (int i = 0; i < cnt.length; ++i) {
            System.out.print(name[i] + "\t" + cnt[i]);
            if (i < col.length) {
                System.out.print("\t" + FormatUtil.roundToSignificantDigits((double)cnt[i] / (double)col[i].size() * 100.0, 3));
            }
            System.out.println();
        }
    }

    public static void printNameMapping(String ... names) {
        String[] nms = CollectionUtil.getSetNamesArray(names.length);
        for (int i = 0; i < names.length; ++i) {
            System.out.println(nms[i] + "\t" + names[i]);
        }
    }

    private static String addPrefixSpaces(String s, int desiredLength) {
        while (s.length() < desiredLength) {
            s = " " + s;
        }
        return s;
    }

    public static <T> int[] getVennCounts(Collection<T> ... col) {
        Set<T>[] venn = CollectionUtil.getVennSets(col);
        int[] cnt = new int[venn.length];
        for (int i = 0; i < cnt.length; ++i) {
            cnt[i] = venn[i].size();
        }
        return cnt;
    }

    public static <T> Set<T>[] getVennSets(Collection<T> ... col) {
        int size = col.length;
        Set[] set = new Set[size];
        for (int i = 0; i < size; ++i) {
            set[i] = new HashSet<T>(col[i]);
        }
        Set[] venn = new Set[(int)(Math.pow(2.0, size) - 1.0)];
        String[] bs = CollectionUtil.generateBinaryStrings(size);
        int x = 0;
        for (String s : bs) {
            HashSet<Set> intersectSets = new HashSet<Set>();
            HashSet<Set> subtractSets = new HashSet<Set>();
            for (int k = 0; k < size; ++k) {
                if (s.length() < k + 1 || s.charAt(s.length() - 1 - k) == '0') {
                    subtractSets.add(set[k]);
                    continue;
                }
                intersectSets.add(set[k]);
            }
            boolean first = true;
            HashSet select = new HashSet();
            for (Set inset : intersectSets) {
                if (first) {
                    select.addAll(inset);
                    first = false;
                    continue;
                }
                select.retainAll(inset);
            }
            for (Set subset : subtractSets) {
                select.removeAll(subset);
            }
            venn[x++] = select;
        }
        return venn;
    }

    private static String[] generateBinaryStrings(int n) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while ((double)i < Math.pow(2.0, n)) {
            list.add(Integer.toBinaryString(i).intern());
            ++i;
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int c2;
                int c1 = CollectionUtil.count1inBinaryString(o1);
                if (c1 != (c2 = CollectionUtil.count1inBinaryString(o2))) {
                    return new Integer(c1).compareTo(c2);
                }
                for (int i = Math.min(o1.length(), o2.length()) - 1; i >= 0; --i) {
                    boolean b2;
                    boolean b1 = o1.charAt(i) == '1';
                    boolean bl = b2 = o2.charAt(i) == '1';
                    if (b1 == b2) continue;
                    return b1 ? -1 : 1;
                }
                return 0;
            }
        });
        return list.toArray(new String[list.size()]);
    }

    private static int count1inBinaryString(String s) {
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '1') continue;
            ++cnt;
        }
        return cnt;
    }

    public static String[] getSetNamesArray(int n) {
        String[] bin = CollectionUtil.generateBinaryStrings(n);
        String[] names = new String[bin.length];
        int x = 0;
        for (String s : bin) {
            String name = "";
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(s.length() - 1 - i) != '1') continue;
                name = name + (char)(i + 65);
            }
            names[x++] = name;
        }
        return names;
    }

    public static String merge(Collection<String> col, String delim) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = col.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static <T> Set<T> getIntersection(Collection<T> ... col) {
        HashSet<T> set = new HashSet<T>(col[0]);
        for (int i = 1; i < col.length; ++i) {
            set.retainAll(col[i]);
        }
        return set;
    }

    public static int maxIntInList(List<Integer> list) {
        int max = -2147483647;
        for (Integer i : list) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }
}

