/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DiscretePvalHisto {
    double[] pvals;
    double window;

    public DiscretePvalHisto(double[] pvals, double window) {
        this.pvals = pvals;
        this.window = window;
        this.retouch();
    }

    public DiscretePvalHisto(List<Double> pvalList, double window) {
        this.pvals = new double[pvalList.size()];
        for (int i = 0; i < this.pvals.length; ++i) {
            this.pvals[i] = pvalList.get(i);
        }
        this.window = window;
        this.retouch();
    }

    private void retouch() {
        for (int i = 0; i < this.pvals.length; ++i) {
            this.pvals[i] = (double)Math.round(this.pvals[i] * 1.0E10) / 1.0E10;
        }
    }

    public void plot() {
        HashMap<Double, Integer> map = new HashMap<Double, Integer>();
        for (double v : this.pvals) {
            if (!map.containsKey(v)) {
                map.put(v, 0);
            }
            map.put(v, (Integer)map.get(v) + 1);
        }
        int total = 0;
        for (Integer cnt : map.values()) {
            total += cnt.intValue();
        }
        ArrayList<Double> list = new ArrayList<Double>(map.keySet());
        Collections.sort(list);
        int[] border = this.getBorderIndexes(list);
        int from = -1;
        for (int b : border) {
            double cnt = 0.0;
            for (int j = from + 1; j <= b; ++j) {
                cnt += (double)((Integer)map.get(list.get(j))).intValue();
            }
            double dist = (Double)list.get(b) - (from >= 0 ? (Double)list.get(from) : 0.0);
            double density = cnt / (dist * (double)total);
            System.out.println(list.get(b) + "\t" + density);
            from = b;
        }
    }

    private int[] getBorderIndexes(List<Double> list) {
        int i;
        LinkedList<Integer> bord = new LinkedList<Integer>();
        double target = this.window;
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i) < target) continue;
            bord.add(i);
            while (target < list.get((Integer)bord.getLast()) + this.window) {
                target += this.window;
            }
        }
        if (!bord.isEmpty() && (Integer)bord.getLast() < list.size() - 1) {
            bord.add(list.size() - 1);
        }
        i = 0;
        int[] inds = new int[bord.size()];
        for (Integer integ : bord.toArray(new Integer[bord.size()])) {
            inds[i++] = integ;
        }
        return inds;
    }
}

