/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class Download {
    public static boolean downlaodTextFile(String url, String saveFile) {
        try {
            String currentRead;
            URLConnection con = new URL(url).openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            BufferedWriter writer = new BufferedWriter(new FileWriter(saveFile));
            int cnt = 0;
            while ((currentRead = reader.readLine()) != null) {
                writer.write(currentRead + "\n");
                ++cnt;
            }
            reader.close();
            writer.close();
            return cnt > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean downloadAsIs(String address, String saveFile) {
        if (address.startsWith("ftp://")) {
            return Download.downloadAsIsViaFTP(address, saveFile);
        }
        try {
            int len;
            URL url = new URL(address);
            URLConnection con = url.openConnection();
            InputStream in = con.getInputStream();
            FileOutputStream out = new FileOutputStream(saveFile);
            byte[] buf = new byte[1024];
            int total = 0;
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                total += len;
            }
            in.close();
            ((OutputStream)out).close();
            return total > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean downloadAndUncompress(String address, String saveFile) {
        if (address.startsWith("ftp://")) {
            return Download.downloadAndUncompressViaFTP(address, saveFile);
        }
        try {
            int len;
            URL url = new URL(address);
            URLConnection con = url.openConnection();
            InflaterInputStream in = address.endsWith(".gz") ? new GZIPInputStream(con.getInputStream()) : new ZipInputStream(con.getInputStream());
            FileOutputStream out = new FileOutputStream(saveFile);
            byte[] buf = new byte[1024];
            int lines = 0;
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
                ++lines;
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return lines > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean downloadAndUncompressViaFTP(String address, String saveFile) {
        try {
            int noRead;
            FTPClient fc = new FTPClient();
            String host = address.substring(6, address.indexOf("/", 7));
            String fileloc = address.substring(address.indexOf("/", 7));
            fc.connect(host);
            fc.enterLocalPassiveMode();
            fc.setRemoteVerificationEnabled(false);
            fc.login("anonymous", "");
            fc.setFileType(2);
            GZIPInputStream is = new GZIPInputStream(fc.retrieveFileStream(fileloc));
            FileOutputStream out = new FileOutputStream(saveFile);
            int length = 0;
            byte[] buffer = new byte[65536];
            while ((noRead = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, noRead);
                length += noRead;
            }
            ((InputStream)is).close();
            fc.disconnect();
            ((OutputStream)out).close();
            return length > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean downloadAsIsViaFTP(String address, String saveFile) {
        try {
            int noRead;
            FTPClient fc = new FTPClient();
            String host = address.substring(6, address.indexOf("/", 7));
            String fileloc = address.substring(address.indexOf("/", 7));
            fc.connect(host);
            fc.enterLocalPassiveMode();
            fc.setRemoteVerificationEnabled(false);
            fc.login("anonymous", "");
            fc.setFileType(2);
            InputStream is = fc.retrieveFileStream(fileloc);
            FileOutputStream out = new FileOutputStream(saveFile);
            int length = 0;
            byte[] buffer = new byte[65536];
            while ((noRead = is.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, noRead);
                length += noRead;
            }
            is.close();
            fc.disconnect();
            ((OutputStream)out).close();
            return length > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String[] listFtpFiles(String ftpDir) throws IOException {
        FTPFile[] ftpFiles;
        ArrayList<String> list = new ArrayList<String>();
        FTPClient fc = new FTPClient();
        String host = ftpDir.substring(6, ftpDir.indexOf("/", 7));
        String dir = ftpDir.substring(ftpDir.indexOf("/", 7));
        fc.connect(host);
        fc.enterLocalPassiveMode();
        fc.setRemoteVerificationEnabled(false);
        fc.login("anonymous", "");
        for (FTPFile file : ftpFiles = fc.listFiles(dir)) {
            list.add(file.getName());
        }
        String[] files = list.toArray(new String[list.size()]);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].contains(" ")) continue;
            files[i] = files[i].substring(files[i].indexOf(" ") + 1);
        }
        return files;
    }
}

