/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cbio.causality.util.trendline.PolyTrendLine;

public class FDR {
    public static List<String> select(final Map<String, Double> results, double fdrThr, List<Double> randomized, int randMultiplier) {
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        if (randomized.isEmpty()) {
            return new ArrayList<String>(results.keySet());
        }
        Collections.sort(randomized);
        ArrayList<String> keys = new ArrayList<String>(results.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)results.get(o1)).compareTo((Double)results.get(o2));
            }
        });
        int ranIndex = 0;
        double ranPv = 0.0;
        int maxIndex = -1;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            double pval = results.get(key);
            while (ranPv <= pval && ranIndex < randomized.size()) {
                ranPv = randomized.get(ranIndex++);
            }
            double noise = (double)(ranIndex - 1) / (double)randMultiplier;
            if (!(noise / (double)(i + 1) <= fdrThr)) continue;
            maxIndex = i;
        }
        if (maxIndex < 0) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(keys.subList(0, maxIndex + 1));
    }

    public static List<String> select(Map<String, Double> results, Map<String, Double> limits, final Map<String, Double> priorityScores, double fdrThr) {
        ArrayList<String> items = new ArrayList<String>(priorityScores.keySet());
        Collections.sort(items, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)priorityScores.get(o2)).compareTo((Double)priorityScores.get(o1));
            }
        });
        if (limits == null) {
            limits = FDR.defaultLimits(results);
        }
        int priorityIndex = -1;
        int maxResult = 0;
        int selectedPriority = -1;
        List<String> result = null;
        while (true) {
            if (priorityIndex < items.size() - 1 && (priorityIndex < 0 || priorityScores.get(items.get(priorityIndex)).equals(priorityScores.get(items.get(priorityIndex + 1))))) {
                ++priorityIndex;
                continue;
            }
            HashMap<String, Double> resultsTemp = new HashMap<String, Double>();
            HashMap<String, Double> limitsTemp = new HashMap<String, Double>();
            for (int i = 0; i <= priorityIndex; ++i) {
                String key = (String)items.get(i);
                resultsTemp.put(key, results.get(key));
                limitsTemp.put(key, limits.get(key));
            }
            List<String> selected = FDR.select(resultsTemp, limitsTemp, fdrThr);
            if (selected.size() >= maxResult) {
                maxResult = selected.size();
                selectedPriority = priorityIndex;
                result = selected;
            }
            if (++priorityIndex >= items.size() - 1) break;
        }
        System.out.println("selectedPriority = " + selectedPriority);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public static List<String> selectBH(Map<String, Double> results, double fdrThr) {
        return FDR.select(results, null, fdrThr);
    }

    public static List<String> select(final Map<String, Double> results, Map<String, Double> limits, double fdrThr) {
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        if (limits == null) {
            limits = FDR.defaultLimits(results);
        }
        ArrayList<Double> limitList = new ArrayList<Double>(limits.values());
        Collections.sort(limitList);
        ArrayList<String> keys = new ArrayList<String>(results.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)results.get(o1)).compareTo((Double)results.get(o2));
            }
        });
        int limIndex = 0;
        double limPv = (Double)limitList.get(0);
        int maxIndex = -1;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            double pval = results.get(key);
            while (limPv <= pval && limIndex < limitList.size() - 1) {
                limPv = (Double)limitList.get(++limIndex);
            }
            double noise = pval * (double)(limIndex + 1);
            if (!(noise / (double)(i + 1) <= fdrThr)) continue;
            maxIndex = i;
        }
        if (maxIndex < 0) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(keys.subList(0, maxIndex + 1));
    }

    private static Map<String, Double> defaultLimits(Map<String, Double> results) {
        HashMap<String, Double> limits = new HashMap<String, Double>(results);
        for (String key : new HashSet(limits.keySet())) {
            limits.put(key, 0.0);
        }
        return limits;
    }

    public static List<String> selectWithPvalThreshold(final Map<String, Double> pvals, double pvalThr) {
        int cut;
        ArrayList<String> keys = new ArrayList<String>(pvals.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return new Double((Double)pvals.get(o1)).compareTo(new Double((Double)pvals.get(o2)));
            }
        });
        for (cut = 0; pvals.get(keys.get(cut)) <= pvalThr && cut < keys.size(); ++cut) {
        }
        return keys.subList(0, cut);
    }

    public static Map<String, Double> getQVals(final Map<String, Double> results, Map<String, Double> limits) {
        HashMap<String, Double> qvals = new HashMap<String, Double>();
        if (limits == null) {
            limits = FDR.defaultLimits(results);
        }
        ArrayList<Double> limitList = new ArrayList<Double>(limits.values());
        Collections.sort(limitList);
        ArrayList<String> keys = new ArrayList<String>(results.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)results.get(o1)).compareTo((Double)results.get(o2));
            }
        });
        int limIndex = 0;
        double limPv = (Double)limitList.get(0);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            double pval = results.get(key);
            while (limPv <= pval && limIndex < limitList.size() - 1) {
                limPv = (Double)limitList.get(++limIndex);
            }
            double noise = pval * (double)(limIndex + 1);
            double fdr = noise / (double)(i + 1);
            qvals.put(key, fdr);
        }
        return qvals;
    }

    public static int[] getResultSizesUsingPolyCurve(Map<String, Double> results, double[] thrs) {
        int[] sizes = new int[thrs.length];
        for (int i = 0; i < thrs.length; ++i) {
            sizes[i] = FDR.selectUsingPolyCurve(results, thrs[i]).size();
        }
        return sizes;
    }

    public static List<String> selectUsingPolyCurve(final Map<String, Double> results, double fdrThr) {
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> keys = new ArrayList<String>(results.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((Double)results.get(o1)).compareTo((Double)results.get(o2));
            }
        });
        double noiseSize = FDR.estimateNoiseVolume(results);
        int maxIndex = -1;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            double pval = results.get(key);
            double noise = pval * noiseSize;
            if (!(noise / (double)(i + 1) <= fdrThr)) continue;
            maxIndex = i;
        }
        if (maxIndex < 0) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(keys.subList(0, maxIndex + 1));
    }

    public static double estimateNoiseVolume(Map<String, Double> pvals) {
        double[][] f = FDR.getNoiseEstimatesForDifferentLambda(pvals);
        PolyTrendLine trendLine = new PolyTrendLine(3);
        trendLine.setValues(f[1], f[0]);
        double noiseRatio = trendLine.predict(f[0][f[0].length - 1]);
        return noiseRatio * (double)pvals.size();
    }

    public static double[][] getNoiseEstimatesForDifferentLambda(Map<String, Double> pvals) {
        double x;
        int i;
        ArrayList<Double> vals = new ArrayList<Double>();
        int[] cnt = new int[99];
        for (Double val : pvals.values()) {
            for (i = 0; i < cnt.length; ++i) {
                if (!(val > (double)(i + 1) * 0.01)) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
        }
        double m = pvals.size();
        for (i = 0; i < cnt.length && (x = (double)cnt[i] / (m * (1.0 - (double)(i + 1) * 0.01))) > 0.0; ++i) {
            vals.add(x);
        }
        double[][] v = new double[2][vals.size()];
        for (int i2 = 0; i2 < v[0].length; ++i2) {
            v[0][i2] = (double)(i2 + 1) * 0.01;
            v[1][i2] = (Double)vals.get(i2);
        }
        return v;
    }

    public static double decideBestFDR(Map<String, Double> results, List<Double> randomized, int randMultiplier) {
        double bestFDR = -1.0;
        double maxScore = 0.0;
        System.out.println("\nFDR\tResult size\tExpected true positives\ttp-fp");
        for (int i = 1; i <= 50; ++i) {
            double fp;
            double fdr = (double)i / 100.0;
            List<String> select = FDR.select(results, fdr, randomized, randMultiplier);
            double tp = (double)select.size() * (1.0 - fdr);
            double score = tp - (fp = (double)select.size() * fdr);
            if (score > maxScore) {
                maxScore = score;
                bestFDR = fdr;
            }
            System.out.println(fdr + "\t" + select.size() + "\t" + (int)Math.round(tp) + "\t" + (int)Math.round(tp - fp));
        }
        System.out.println();
        return bestFDR;
    }

    public static double decideBestFDR_BH(Map<String, Double> results, Map<String, Double> limits) {
        double bestFDR = -1.0;
        double maxScore = 0.0;
        for (int i = 1; i <= 50; ++i) {
            double fp;
            double fdr = (double)i / 100.0;
            List<String> select = FDR.select(results, limits, fdr);
            double tp = (double)select.size() * (1.0 - fdr);
            double score = tp - (fp = (double)select.size() * fdr);
            if (!(score > maxScore)) continue;
            maxScore = score;
            bestFDR = fdr;
        }
        return bestFDR;
    }
}

