/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FactorialSolver {
    private List<Integer> nom;
    private List<Integer> denom;

    public FactorialSolver(List<Integer> nom, List<Integer> denom) {
        this.nom = nom;
        this.denom = denom;
        this.clearIneffective(nom);
        this.clearIneffective(denom);
        this.clearOverlap(nom, denom);
    }

    public static double solve(List<Integer> nom, List<Integer> denom) {
        FactorialSolver solver = new FactorialSolver(nom, denom);
        return solver.solve();
    }

    public double solve() {
        double result;
        block15: {
            int i;
            int size;
            ArrayList<Integer> down;
            block14: {
                Integer n;
                int i2;
                Comparator<Integer> comparator = new Comparator<Integer>(){

                    @Override
                    public int compare(Integer int1, Integer int2) {
                        return int2 - int1;
                    }
                };
                Collections.sort(this.nom, comparator);
                Collections.sort(this.denom, comparator);
                ArrayList<Integer> up = new ArrayList<Integer>();
                down = new ArrayList<Integer>();
                size = Math.min(this.nom.size(), this.denom.size());
                for (i2 = 0; i2 < size; ++i2) {
                    int j;
                    n = this.nom.get(i2);
                    Integer d = this.denom.get(i2);
                    if (n > d) {
                        for (j = n.intValue(); j > d; --j) {
                            up.add(j);
                        }
                        continue;
                    }
                    for (j = d.intValue(); j > n; --j) {
                        down.add(j);
                    }
                }
                if (this.nom.size() > size) {
                    for (i2 = size; i2 < this.nom.size(); ++i2) {
                        n = this.nom.get(i2);
                        for (int j = 2; j <= n; ++j) {
                            up.add(j);
                        }
                    }
                } else if (this.denom.size() > size) {
                    for (i2 = size; i2 < this.denom.size(); ++i2) {
                        n = this.denom.get(i2);
                        for (int j = 2; j <= n; ++j) {
                            down.add(j);
                        }
                    }
                }
                Collections.sort(up, comparator);
                Collections.sort(down, comparator);
                size = Math.min(up.size(), down.size());
                result = 1.0;
                for (i = 0; i < size; ++i) {
                    Integer n2 = (Integer)up.get(i);
                    Integer d = (Integer)down.get(i);
                    result *= (double)n2.intValue() / (double)d.intValue();
                }
                if (up.size() <= size) break block14;
                for (i = size; i < up.size(); ++i) {
                    Integer n3 = (Integer)up.get(i);
                    result *= (double)n3.intValue();
                }
                break block15;
            }
            if (down.size() <= size) break block15;
            for (i = size; i < down.size(); ++i) {
                Integer d = (Integer)down.get(i);
                result /= (double)d.intValue();
            }
        }
        return result;
    }

    private void clearOverlap(List<Integer> a, List<Integer> b) {
        for (Integer x : new ArrayList<Integer>(a)) {
            if (!b.contains(x)) continue;
            a.remove(x);
            b.remove(x);
        }
    }

    private void clearIneffective(List<Integer> list) {
        Iterator<Integer> iter = list.iterator();
        while (iter.hasNext()) {
            Integer n = iter.next();
            if (n >= 2) continue;
            iter.remove();
        }
    }
}

