/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.cbio.causality.util.FactorialSolver;
import org.cbio.causality.util.Summary;

public class FishersExactTest {
    public static double calcNegativeDepPval(int a, int b, int c, int d) {
        double pval = 0.0;
        do {
            FactorialSolver f = new FactorialSolver(new ArrayList<Integer>(Arrays.asList(a + b, c + d, a + c, b + d)), new ArrayList<Integer>(Arrays.asList(a, b, c, d, a + b + c + d)));
            pval += f.solve();
            ++b;
            ++c;
        } while (--d >= 0 && --a >= 0);
        return pval;
    }

    public static double calcPositiveDepPval(int a, int b, int c, int d) {
        double pval = 0.0;
        do {
            FactorialSolver f = new FactorialSolver(new ArrayList<Integer>(Arrays.asList(a + b, c + d, a + c, b + d)), new ArrayList<Integer>(Arrays.asList(a, b, c, d, a + b + c + d)));
            pval += f.solve();
            ++a;
            ++d;
        } while (--b >= 0 && --c >= 0);
        return pval;
    }

    public static double calcEnrichmentPval(int size, int featuredOverall, int selected, int featuredSelected) {
        assert (selected <= size);
        assert (featuredSelected <= selected);
        assert (featuredSelected <= featuredOverall);
        return FishersExactTest.calcPositiveDepPval(size - selected - featuredOverall + featuredSelected, featuredOverall - featuredSelected, selected - featuredSelected, featuredSelected);
    }

    public static double getPvalOfMeanDiff_discretizeToTwo(double[] x0, double[] x1) {
        double[] d = new double[x0.length + x1.length];
        System.arraycopy(x0, 0, d, 0, x0.length);
        System.arraycopy(x1, 0, d, x0.length, x1.length);
        double median = Summary.median(d);
        int x0Low = 0;
        int x0High = 0;
        int x1Low = 0;
        int x1High = 0;
        for (double v : x0) {
            if (v < median) {
                ++x0Low;
                continue;
            }
            ++x0High;
        }
        for (double v : x1) {
            if (v < median) {
                ++x1Low;
                continue;
            }
            ++x1High;
        }
        double p1 = FishersExactTest.calcPositiveDepPval(x0Low, x0High, x1Low, x1High);
        double p2 = FishersExactTest.calcNegativeDepPval(x0Low, x0High, x1Low, x1High);
        double p = Math.min(p1, p2) * 2.0;
        return p;
    }

    public static void main(String[] args) {
        System.out.println(FishersExactTest.calcEnrichmentPval(213, 61, 14, 44));
    }
}

