/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Histogram {
    private Map<Integer, Integer> binMap;
    private double range;
    private int total;
    private double min;
    private double max;
    private boolean borderAtZero;
    public static final int Z = 1000000;

    public Histogram(double range) {
        this.range = range;
        this.binMap = new HashMap<Integer, Integer>();
        this.total = 0;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    public Histogram(double range, double[] vals) {
        this(range);
        for (double val : vals) {
            this.count(val);
        }
    }

    public void setBorderAtZero(boolean borderAtZero) {
        this.borderAtZero = borderAtZero;
    }

    public void countAll(double[] ns) {
        for (double n : ns) {
            this.count(n);
        }
    }

    public void count(double n) {
        int i;
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            return;
        }
        if (n > this.max) {
            this.max = n;
        }
        if (n < this.min) {
            this.min = n;
        }
        if (this.binMap.containsKey(i = this.getBin(n))) {
            this.binMap.put(i, this.binMap.get(i) + 1);
        } else {
            this.binMap.put(i, 1);
        }
        ++this.total;
    }

    private int getBin(double n) {
        if (this.borderAtZero) {
            return (int)Math.round((double)Math.round((n - this.range / 2.0) / this.range * 100.0) / 100.0);
        }
        return (int)Math.round(n / this.range);
    }

    private double getX(int bin) {
        if (this.borderAtZero) {
            return this.range * (double)bin + this.range / 2.0;
        }
        return this.range * (double)bin;
    }

    private String getIntervalString(int bin) {
        double center = this.getX(bin);
        return "[" + this.accurate(center - this.range / 2.0) + ", " + this.accurate(center + this.range / 2.0) + ")";
    }

    public int getValue(double n) {
        int i = this.getBin(n);
        if (this.binMap.containsKey(i)) {
            return this.binMap.get(i);
        }
        return 0;
    }

    public double getBinValue(int bin) {
        if (this.binMap.containsKey(bin)) {
            return this.binMap.get(bin).intValue();
        }
        return 0.0;
    }

    public double calc(double x) {
        return this.getValue(x);
    }

    public int getTotal() {
        return this.total;
    }

    public double getRange() {
        return this.range;
    }

    public void add(Histogram h) {
        assert (this.range == h.range) : "Ranges not equal, r1 = " + this.range + " r2 = " + h.range;
        for (Integer i : h.binMap.keySet()) {
            if (!this.binMap.containsKey(i)) {
                this.binMap.put(i, 0);
            }
            this.binMap.put(i, this.binMap.get(i) + h.binMap.get(i));
            this.total += h.binMap.get(i).intValue();
        }
    }

    public void multiply(int x) {
        for (Integer i : this.binMap.keySet()) {
            this.binMap.put(i, this.binMap.get(i) * x);
            this.total += this.binMap.get(i) * (x - 1);
        }
    }

    public int getPositiveTotal() {
        int t = 0;
        for (Integer i : this.binMap.keySet()) {
            if (i < 0) continue;
            t += this.binMap.get(i).intValue();
        }
        return t;
    }

    public int getNegativeTotal() {
        int t = 0;
        for (Integer i : this.binMap.keySet()) {
            if (i >= 0) continue;
            t += this.binMap.get(i).intValue();
        }
        return t;
    }

    public double getDensity(double x) {
        int a = this.getValue(x);
        return (double)a / ((double)this.total * this.range);
    }

    public double[] getMinMax() {
        if (this.total == 0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        int[] bins = this.getMinMaxBin();
        return new double[]{this.getX(bins[0]), this.getX(bins[1])};
    }

    public int[] getMinMaxBin() {
        int mini = Integer.MAX_VALUE;
        int maxi = -2147483647;
        for (Integer i : this.binMap.keySet()) {
            if (i < mini) {
                mini = i;
            }
            if (i <= maxi) continue;
            maxi = i;
        }
        return new int[]{mini, maxi};
    }

    public double getPeakLocation() {
        int max = -2147483647;
        int maxLoc = 0;
        for (Integer i : this.binMap.keySet()) {
            Integer cnt;
            if (!this.binMap.containsKey(i) || (cnt = this.binMap.get(i)) <= max) continue;
            max = cnt;
            maxLoc = i;
        }
        return (double)maxLoc * this.range;
    }

    public void print() {
        int t = 0;
        for (Integer c : this.binMap.values()) {
            t += c.intValue();
        }
        assert (t == this.total) : "total = " + this.total + " found = " + t;
        if (this.binMap.isEmpty()) {
            return;
        }
        Object[] bins = this.binMap.keySet().toArray(new Integer[this.binMap.size()]);
        Arrays.sort(bins);
        int p = (Integer)bins[0];
        for (Object bin : bins) {
            for (int i = p + 1; i < (Integer)bin; ++i) {
                System.out.println(this.getIntervalString(i) + "\t0");
            }
            System.out.println(this.getIntervalString((Integer)bin) + "\t" + this.binMap.get(bin));
            p = (Integer)bin;
        }
    }

    public double[][] getPlotVals() {
        int t = 0;
        for (Integer c : this.binMap.values()) {
            t += c.intValue();
        }
        assert (t == this.total) : "total = " + this.total + " found = " + t;
        if (this.binMap.isEmpty()) {
            return null;
        }
        double[][] v = new double[2][this.binMap.size()];
        Object[] bins = this.binMap.keySet().toArray(new Integer[this.binMap.size()]);
        Arrays.sort(bins);
        int i = 0;
        for (Object bin : bins) {
            v[0][i] = this.getX((Integer)bin);
            v[1][i++] = this.binMap.get(bin).intValue();
        }
        return v;
    }

    private double accurate(double v) {
        return (double)Math.round(v * 1000000.0) / 1000000.0;
    }

    public void print(double times) {
        if (this.binMap.isEmpty()) {
            return;
        }
        Object[] bins = this.binMap.keySet().toArray(new Integer[this.binMap.size()]);
        Arrays.sort(bins);
        int p = (Integer)bins[0];
        for (Object bin : bins) {
            for (int i = p + 1; i < (Integer)bin; ++i) {
                System.out.println(this.getIntervalString(i) + "\t0");
            }
            System.out.println(this.getIntervalString((Integer)bin) + "\t" + (double)this.binMap.get(bin).intValue() * times);
            p = (Integer)bin;
        }
    }

    public void printTogether(Histogram h) {
        if (this.binMap.isEmpty()) {
            h.print();
            return;
        }
        Object[] bins = this.binMap.keySet().toArray(new Integer[this.binMap.size()]);
        Arrays.sort(bins);
        Object[] hbins = h.binMap.keySet().toArray(new Integer[h.binMap.size()]);
        Arrays.sort(hbins);
        int min = Math.min((Integer)bins[0], (Integer)hbins[0]);
        int max = Math.max((Integer)bins[bins.length - 1], (Integer)hbins[hbins.length - 1]);
        for (int i = min; i <= max; ++i) {
            System.out.print((double)i * this.range + "\t");
            if (this.binMap.containsKey(i)) {
                System.out.print(this.binMap.get(i) + "\t");
            } else {
                System.out.print("0\t");
            }
            if (h.binMap.containsKey(i)) {
                System.out.print(h.binMap.get(i) + "\n");
                continue;
            }
            System.out.print("0\n");
        }
    }

    public void printTogether(Histogram h, double times) {
        if (this.binMap.isEmpty()) {
            h.print();
            return;
        }
        Object[] bins = this.binMap.keySet().toArray(new Integer[this.binMap.size()]);
        Arrays.sort(bins);
        Object[] hbins = h.binMap.keySet().toArray(new Integer[h.binMap.size()]);
        Arrays.sort(hbins);
        int min = Math.min((Integer)bins[0], (Integer)hbins[0]);
        int max = Math.max((Integer)bins[bins.length - 1], (Integer)hbins[hbins.length - 1]);
        for (int i = min; i <= max; ++i) {
            System.out.print((double)i * this.range + "\t");
            if (this.binMap.containsKey(i)) {
                System.out.print(this.binMap.get(i) + "\t");
            } else {
                System.out.print("0\t");
            }
            if (h.binMap.containsKey(i)) {
                System.out.print((double)h.binMap.get(i).intValue() * times + "\n");
                continue;
            }
            System.out.print("0\n");
        }
    }

    public static void printAll(Histogram ... his) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        double range = his[0].getRange();
        for (Histogram h : his) {
            if (range != h.getRange()) {
                throw new IllegalArgumentException("Histogram ranges are not equal.");
            }
            for (Integer v : h.binMap.keySet()) {
                if (v < min) {
                    min = v;
                }
                if (v <= max) continue;
                max = v;
            }
        }
        for (int i = min; i <= max; ++i) {
            System.out.print(his[0].getIntervalString(i));
            for (Histogram h : his) {
                System.out.print("\t");
                if (!h.binMap.containsKey(i)) continue;
                System.out.print(h.binMap.get(i));
            }
            System.out.println();
        }
    }

    public void printDensity() {
        System.out.println("total count = " + this.total);
        double[] minmax = this.getMinMax();
        String sep = "\t";
        for (double x = minmax[0]; x < minmax[1] + this.range / 2.0; x += this.range) {
            System.out.println(x + sep + this.getDensity(x));
        }
    }

    public static void write(Histogram h, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write(h.getRange() + "\n");
            writer.write(h.getTotal() + "\n");
            for (Integer key : h.binMap.keySet()) {
                writer.write(key + "\t" + h.binMap.get(key) + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Histogram read(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String line = reader.readLine();
            Histogram h = new Histogram(Double.parseDouble(line));
            h.total = Integer.parseInt(reader.readLine());
            line = reader.readLine();
            while (line != null) {
                if (line.length() != 0) {
                    String[] s = line.split("\\t");
                    assert (s.length == 2);
                    h.binMap.put(Integer.parseInt(s[0]), Integer.parseInt(s[1]));
                }
                line = reader.readLine();
            }
            reader.close();
            return h;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Random r = new Random();
        Histogram h = new Histogram(0.05);
        h.borderAtZero = true;
        for (int i = 0; i < 10000; ++i) {
            h.count(r.nextDouble());
        }
        h.print();
    }
}

