/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;

public class KaplanMeier {
    public static void generate(OutputStream out, String[] names, List<double[]> valsList) throws IOException {
        int j;
        if (names.length != valsList.size()) {
            throw new IllegalArgumentException("Name and valsList sizes should be equal");
        }
        for (double[] vals : valsList) {
            Arrays.sort(vals);
        }
        int[] i = new int[names.length];
        double[] y = new double[names.length];
        for (int j2 = 0; j2 < i.length; ++j2) {
            i[j2] = 0;
            y[j2] = 1.0;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write("Time");
        for (String name : names) {
            writer.write("\t" + name);
        }
        double x = 0.0;
        writer.write("\n" + x);
        for (j = 0; j < i.length; ++j) {
            writer.write("\t" + y[j]);
        }
        while ((x = KaplanMeier.min(i, valsList)) != Double.MAX_VALUE) {
            writer.write("\n" + x);
            for (j = 0; j < i.length; ++j) {
                writer.write("\t" + y[j]);
            }
            if (!KaplanMeier.advance(i, valsList, x)) break;
            for (j = 0; j < i.length; ++j) {
                y[j] = 1.0 - (double)i[j] / (double)valsList.get(j).length;
            }
            writer.write("\n" + x);
            for (j = 0; j < i.length; ++j) {
                writer.write("\t" + y[j]);
            }
        }
        writer.close();
    }

    private static boolean advance(int[] i, List<double[]> valsList, double min) {
        boolean changed = false;
        for (int j = 0; j < i.length; ++j) {
            int index = KaplanMeier.newInd(valsList.get(j), i[j], min);
            if (index == i[j]) continue;
            i[j] = index;
            changed = true;
        }
        return changed;
    }

    private static double min(int[] i, List<double[]> valsList) {
        double min = Double.MAX_VALUE;
        for (int j = 0; j < i.length; ++j) {
            if (valsList.get(j).length == i[j] || !(valsList.get(j)[i[j]] < min)) continue;
            min = valsList.get(j)[i[j]];
        }
        return min;
    }

    private static int newInd(double[] vals, int currentInd, double currentMin) {
        int i;
        for (i = currentInd; i < vals.length && !(vals[i] > currentMin); ++i) {
        }
        return i;
    }
}

