/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

public class Kronometre {
    private long startedAt;
    private long pausedAt;
    private long totalPaused;
    private long totalCounted;
    private boolean paused;

    public Kronometre() {
        this.start();
    }

    public void reset() {
        this.start();
    }

    public void start() {
        this.startedAt = System.currentTimeMillis();
        this.totalPaused = 0L;
        this.totalCounted = 0L;
        this.pausedAt = 0L;
        this.paused = false;
    }

    public void pause() {
        if (!this.paused) {
            this.pausedAt = System.currentTimeMillis();
            this.paused = true;
        }
    }

    public void resume() {
        if (this.paused) {
            this.totalPaused += System.currentTimeMillis() - this.pausedAt;
            this.paused = false;
        }
    }

    public void stop() {
        if (this.paused) {
            this.resume();
        }
        long totalTime = System.currentTimeMillis() - this.startedAt;
        this.totalCounted = totalTime - this.totalPaused;
    }

    public long getPassedMilisec() {
        return (this.paused ? this.pausedAt : System.currentTimeMillis()) - this.startedAt - this.totalPaused;
    }

    public void print() {
        System.out.println("Time elapsed: " + Kronometre.getPrintable(this.totalCounted));
        if (this.totalPaused > 0L) {
            System.out.println("Time paused: " + Kronometre.getPrintable(this.totalPaused));
            System.out.println("Time total: " + Kronometre.getPrintable(this.totalCounted + this.totalPaused));
        }
    }

    public static String getPrintable(long time) {
        int div = 3600000;
        int hours = (int)(time / (long)div);
        time %= (long)div;
        int minutes = (int)(time / (long)(div /= 60));
        time %= (long)div;
        int seconds = (int)(time / (long)(div /= 60));
        String s = hours > 0 ? hours + "h, " : "";
        s = s + (minutes > 0 ? minutes + "m, " : "");
        s = s + seconds + "s";
        return s;
    }
}

