/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.Process;

public class ModelExciser {
    private static Log log = LogFactory.getLog(ModelExciser.class);
    private static final SimpleEditorMap EM = SimpleEditorMap.L3;
    protected static final PathAccessor cotrolAcc = new PathAccessor("Interaction/controlledOf*:Interaction");
    static BioPAXIOHandler handler = new SimpleIOHandler();

    public static void exciseToFile(Model model, List<PathwayTicket> tickets, boolean addControls, boolean addNumber, String outFile) {
        model = ModelExciser.excise(model, tickets, addControls, addNumber);
        try {
            handler.convertToOWL(model, new FileOutputStream(outFile));
        }
        catch (FileNotFoundException e) {
            log.error("Cannot write to file.", e);
        }
    }

    public static Model excise(Model model, List<PathwayTicket> tickets, boolean addControls, boolean addNumber) {
        HashSet<BioPAXElement> content = new HashSet<BioPAXElement>();
        int i = 0;
        for (PathwayTicket ticket : tickets) {
            if (addControls) {
                ticket.addControls();
            }
            if (addNumber) {
                ticket.addNumberToName(++i, tickets.size());
            }
            content.addAll(ticket.inters);
        }
        Model excised = ModelExciser.excise(model, content);
        i = 0;
        for (PathwayTicket ticket : tickets) {
            Pathway pathway2 = excised.addNew(Pathway.class, System.currentTimeMillis() + "-AutoGenerated-" + ++i);
            pathway2.setDisplayName(ticket.name);
            pathway2.addComment(ticket.comment);
            for (Interaction anInt : ticket.inters) {
                pathway2.addPathwayComponent((Process)excised.getByID(anInt.getUri()));
            }
        }
        return excised;
    }

    public static Model excise(Model model, Set<BioPAXElement> content) {
        Completer c = new Completer(EM);
        content = c.complete(content, model);
        Cloner cln = new Cloner(EM, BioPAXLevel.L3.getDefaultFactory());
        return cln.clone(model, content);
    }

    public static class PathwayTicket {
        Set<Interaction> inters;
        String comment;
        String name;

        public PathwayTicket(String name, String comment, Interaction ... inter) {
            this.name = name;
            this.comment = comment;
            this.inters = new HashSet<Interaction>(Arrays.asList(inter));
        }

        public void addControls() {
            for (Interaction inter : new HashSet<Interaction>(this.inters)) {
                for (Object o : cotrolAcc.getValueFromBean(inter)) {
                    if (!(o instanceof Control)) continue;
                    this.inters.add((Control)o);
                }
            }
        }

        public void addNumberToName(int no, int max) {
            this.name = PathwayTicket.getWithLeadingZeros(no, max) + " " + this.name;
        }

        public static String getWithLeadingZeros(int i, int size) {
            assert (i <= size);
            int w1 = (int)Math.floor(Math.log10(size));
            int w2 = (int)Math.floor(Math.log10(i));
            String s = "";
            for (int j = w2; j < w1; ++j) {
                s = s + "0";
            }
            return s + i;
        }
    }
}

