/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cbio.causality.model.Change;
import org.cbio.causality.util.FactorialSolver;
import org.cbio.causality.util.Summary;

public class Overlap {
    private static final Map<String, Double> cache = new HashMap<String, Double>();
    public static boolean useCache = true;
    public static final String SEP = ".";
    public static int cacheUsed = 0;
    public static int cacheNotUsed = 0;

    public static double calcMutexPval(int n, int o, int ... a) {
        String key = null;
        if (useCache && cache.containsKey(key = n + SEP + o + SEP + Arrays.toString(a))) {
            ++cacheUsed;
            return cache.get(key);
        }
        if (n < 0 || o < 0) {
            throw new IllegalArgumentException("All parameters should be non-negative. n=" + n + " o=" + o);
        }
        for (int aa : a) {
            if (aa >= 0) continue;
            throw new IllegalArgumentException("All parameters should be non-negative. a contains " + aa);
        }
        if (o > Summary.min(a)) {
            throw new IllegalArgumentException("o cannot be more than min(a)");
        }
        if (n < Summary.max(a)) {
            throw new IllegalArgumentException("n cannot be less than max(a)");
        }
        int minO = Math.max(0, Summary.sum(a) - (a.length - 1) * n);
        if (o < minO) {
            throw new IllegalArgumentException("o cannot be lower than max(0, sum(a)-((length(a)-1) * n))");
        }
        if (n == 0) {
            return 1.0;
        }
        double[] p = Overlap.calcOverlapPvals(n, minO, o, a);
        double result = Summary.sum(p);
        if (useCache) {
            ++cacheNotUsed;
            cache.put(key, result);
        }
        return result;
    }

    public static double calcCoocPval(int n, int o, int ... a) {
        if (n < 0 || o < 0) {
            throw new IllegalArgumentException("All parameters should be non-negative. n=" + n + " o=" + o);
        }
        for (int aa : a) {
            if (aa >= 0) continue;
            throw new IllegalArgumentException("All parameters should be non-negative. a contains " + aa);
        }
        if (o > Summary.min(a)) {
            throw new IllegalArgumentException("o cannot be more than min(a)");
        }
        if (n < Summary.max(a)) {
            throw new IllegalArgumentException("n cannot be less than max(a)");
        }
        int minO = Math.max(0, Summary.sum(a) - (a.length - 1) * n);
        if (o < minO) {
            throw new IllegalArgumentException("o cannot be lower than max(0, sum(a)-((length(a)-1) * n))");
        }
        int maxO = Summary.min(a);
        if (o > maxO) {
            throw new IllegalArgumentException("o cannot be higher than min(a)");
        }
        if (n == 0) {
            return 1.0;
        }
        double[] p = Overlap.calcOverlapPvals(n, o, maxO, a);
        return Summary.sum(p);
    }

    public static double[] calcOverlapPvals(int n, int from, int to, int ... a) {
        if (a.length < 2) {
            throw new IllegalArgumentException("Array a should have length at least 2. length(a) = " + a.length);
        }
        if (n < 0 || from < 0 || to < 0) {
            throw new IllegalArgumentException("All parameters should be non-negative. n=" + n + " from=" + from + " to=" + to);
        }
        for (int aa : a) {
            if (aa >= 0) continue;
            throw new IllegalArgumentException("All parameters should be non-negative. a contains " + aa);
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be bigger than to");
        }
        if (to > Summary.min(a)) {
            throw new IllegalArgumentException("to cannot be more than min(a)");
        }
        if (Summary.max(a) > n) {
            throw new IllegalArgumentException("max(a) cannot be greater than sample size");
        }
        if (n == 0) {
            throw new IllegalArgumentException("n should be a positive number");
        }
        int minO = Math.max(0, Summary.sum(a) - (a.length - 1) * n);
        if (from < minO) {
            throw new IllegalArgumentException("from cannot be lower than max(0, sum(a)-((length(a)-1) * n))");
        }
        double[] pval = new double[to - from + 1];
        if (a.length == 2) {
            int i;
            int e = (int)((double)Summary.mult(a) / Math.pow(n, a.length - 1));
            if (e < from) {
                e = from;
            } else if (e > to) {
                e = to;
            }
            pval[e - from] = Overlap.calcProb(n, a[0], a[1], e);
            for (i = e - 1; i >= from; --i) {
                pval[i - from] = pval[i - from + 1] * Overlap.getMultiplierToDecreaseO(n, a[0], a[1], i + 1);
            }
            for (i = e + 1; i <= to; ++i) {
                pval[i - from] = pval[i - from - 1] * Overlap.getMultiplierToIncreaseO(n, a[0], a[1], i - 1);
            }
            return pval;
        }
        int[] at = new int[a.length - 1];
        System.arraycopy(a, 0, at, 0, at.length);
        int f = Math.max(Summary.sum(at) - (at.length - 1) * n, minO);
        int t = Math.min(Summary.min(at), n + to - a[a.length - 1]);
        double[] p1 = Overlap.calcOverlapPvals(n, f, t, at);
        for (int i = 0; i < pval.length; ++i) {
            pval[i] = Overlap.calcProb(n, i + from, p1, f, a);
        }
        return pval;
    }

    public static double[] calcOverlapPvalsForDifferingA(int n, int b, int o, int from, int to) {
        int i;
        if (n < 0 || o < 0 || b < 0 || from < 0 || to < 0) {
            throw new IllegalArgumentException("All parameters should be non-negative. n=" + n + " o=" + o + " b=" + b + " from=" + from + " to=" + to);
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be bigger than to");
        }
        if (o > from) {
            throw new IllegalArgumentException("o cannot be more than from");
        }
        if (from > n) {
            throw new IllegalArgumentException("from cannot be greater than sample size");
        }
        if (to > n) {
            throw new IllegalArgumentException("to cannot be greater than sample size");
        }
        if (b > n) {
            throw new IllegalArgumentException("b cannot be greater than sample size");
        }
        if (o < b - (n - from)) {
            throw new IllegalArgumentException("o cannot be lower than b-(n-from)");
        }
        if (o < b - (n - to)) {
            throw new IllegalArgumentException("o cannot be lower than b-(n-to)");
        }
        if (o > b) {
            throw new IllegalArgumentException("o cannot be greater than b");
        }
        if (n == 0) {
            throw new IllegalArgumentException("n should be a positive number");
        }
        double[] pval = new double[to - from + 1];
        int e = (int)((double)(n * o) / (double)b);
        if (e < from) {
            e = from;
        } else if (e > to) {
            e = to;
        }
        pval[e - from] = Overlap.calcProb(n, e, b, o);
        for (i = e - 1; i >= from; --i) {
            pval[i - from] = pval[i - from + 1] * Overlap.getMultiplierToDecreaseA(n, i + 1, b, o);
        }
        for (i = e + 1; i <= to; ++i) {
            pval[i - from] = pval[i - from - 1] * Overlap.getMultiplierToIncreaseA(n, i - 1, b, o);
        }
        return pval;
    }

    protected static double calcProb(int n, int a, int b, int x) {
        if (a + b - n > x) {
            return 0.0;
        }
        if (x > a || x > b) {
            return 0.0;
        }
        String key = null;
        if (useCache && cache.containsKey(key = n + SEP + x + SEP + Math.max(a, b) + SEP + Math.min(a, b))) {
            return cache.get(key);
        }
        FactorialSolver s = new FactorialSolver(new ArrayList<Integer>(Arrays.asList(a, b, n - a, n - b)), new ArrayList<Integer>(Arrays.asList(n, x, a - x, b - x, n - a - b + x)));
        double p = s.solve();
        if (useCache) {
            cache.put(key, p);
        }
        return p;
    }

    protected static double calcProb(int n, int x, double[] p1, int startOv, int ... a) {
        int minX = Math.max(Summary.sum(a) - (a.length - 1) * n, 0);
        int maxX = Summary.min(a);
        if (minX > x || x > maxX) {
            return 0.0;
        }
        int from = Math.max(Summary.sumButLast(a) - (a.length - 2) * n, x);
        assert (from >= startOv);
        int to = Math.min(Summary.minButLast(a), n + x - a[a.length - 1]);
        double[] p2 = Overlap.calcOverlapPvalsForDifferingA(n, a[a.length - 1], x, from, to);
        double pval = 0.0;
        for (int i = 0; i < p2.length; ++i) {
            if (i + from - startOv > p1.length) {
                System.out.println();
            }
            pval += p1[i + from - startOv] * p2[i];
        }
        return pval;
    }

    private static double getMultiplierToIncreaseO(int n, int a, int b, int o) {
        return (double)((a - o) * (b - o)) / (double)((o + 1) * (n - a - b + o + 1));
    }

    private static double getMultiplierToDecreaseO(int n, int a, int b, int o) {
        return (double)(o * (n - a - b + o)) / (double)((a - o + 1) * (b - o + 1));
    }

    private static double getMultiplierToIncreaseA(int n, int a, int b, int o) {
        return (double)((a + 1) * (n - a - b + o)) / (double)((n - a) * (a - o + 1));
    }

    private static double getMultiplierToDecreaseA(int n, int a, int b, int o) {
        return (double)((n - a + 1) * (a - o)) / (double)(a * (n - a - b + o + 1));
    }

    public static double calcMutexPvalOfSubset(boolean[] use, boolean[] ... alt) {
        int[] a = new int[alt.length];
        int[] no = Overlap.getCounts(use, a, alt);
        return Overlap.calcMutexPval(no[0], no[1], a);
    }

    public static double calcMutexPval(boolean[] ... alt) {
        return Overlap.calcMutexPvalOfSubset(null, alt);
    }

    public static double calcCoocPvalOfSubset(boolean[] use, boolean[] ... alt) {
        int[] a = new int[alt.length];
        int[] no = Overlap.getCounts(use, a, alt);
        return Overlap.calcCoocPval(no[0], no[1], a);
    }

    public static List<Integer> getCounts(boolean[] ... alt) {
        int[] a = new int[alt.length];
        int[] no = Overlap.getCounts(null, a, alt);
        ArrayList<Integer> cnts = new ArrayList<Integer>();
        cnts.add(no[0]);
        cnts.add(no[1]);
        for (int i : a) {
            cnts.add(i);
        }
        return cnts;
    }

    public static double calcCoocPval(boolean[] ... alt) {
        return Overlap.calcCoocPvalOfSubset(null, alt);
    }

    private static int[] getCounts(boolean[] use, int[] altCntToFill, boolean[] ... alt) {
        assert (altCntToFill.length == alt.length);
        int samples = alt[0].length;
        assert (use == null || use.length == samples);
        for (int i = 0; i < alt.length; ++i) {
            assert (alt[i].length == samples);
            altCntToFill[i] = 0;
        }
        int n = 0;
        int overlap = 0;
        for (int i = 0; i < samples; ++i) {
            if (use != null && !use[i]) continue;
            ++n;
            int hit = 0;
            for (int j = 0; j < alt.length; ++j) {
                if (!alt[j][i]) continue;
                int n2 = j;
                altCntToFill[n2] = altCntToFill[n2] + 1;
                ++hit;
            }
            if (hit != alt.length) continue;
            ++overlap;
        }
        return new int[]{n, overlap};
    }

    public static double calcMutexPval(Change[] ... ch) {
        return Overlap.calcMutexPval(Overlap.toBoolean(ch));
    }

    public static double calcMutexPval(boolean[] use, Change[] ... ch) {
        return Overlap.calcMutexPvalOfSubset(use, Overlap.toBoolean(ch));
    }

    public static double calcCoocPval(Change[] ... ch) {
        return Overlap.calcCoocPval(Overlap.toBoolean(ch));
    }

    public static double calcCoocPval(boolean[] use, Change[] ... ch) {
        return Overlap.calcCoocPvalOfSubset(use, Overlap.toBoolean(ch));
    }

    private static boolean[][] toBoolean(Change[][] ch) {
        boolean[][] b = new boolean[ch.length][];
        for (int i = 0; i < b.length; ++i) {
            b[i] = new boolean[ch[i].length];
            for (int j = 0; j < ch[i].length; ++j) {
                b[i][j] = ch[i][j].isAltered();
            }
        }
        return b;
    }

    public static void main(String[] args) throws InterruptedException {
        int n = 199;
        int a = 58;
        int b = 58;
        int o = 23;
        System.out.println(Overlap.calcCoocPval(n, o, a, b));
    }
}

