/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import org.cbio.causality.util.Kronometre;

public class Progress {
    private int length;
    private int totalTicks;
    private double total;
    private int counted;
    private Kronometre kron;
    private boolean showRemainingTime = true;
    private static final String DOT = "#";
    public static final int DEFAULT_LENGTH = 100;

    public Progress(int totalTicks) {
        this(totalTicks, 100, null);
    }

    public Progress(int totalTicks, String message) {
        this(totalTicks, 100, message);
    }

    public Progress(int totalTicks, int length, String message) {
        this.length = length;
        this.totalTicks = totalTicks;
        this.total = totalTicks;
        this.kron = new Kronometre();
        this.kron.start();
        System.out.print("\n|");
        if (message != null) {
            System.out.print(" " + message);
            length -= message.length() + 1;
        }
        for (int i = 0; i < length; ++i) {
            System.out.print(" ");
        }
        System.out.print("|\n ");
    }

    public synchronized void tick() {
        this.tick(null);
    }

    public synchronized void tick(String message) {
        ++this.counted;
        if (this.counted == this.totalTicks) {
            this.kron.stop();
            if (this.showRemainingTime) {
                this.printWholeProgress();
            }
            System.out.print("  ");
            this.kron.print();
            return;
        }
        int p = (int)(Math.ceil((double)this.counted / this.total * (double)this.length) - Math.ceil((double)(this.counted - 1) / this.total * (double)this.length));
        if (this.showRemainingTime) {
            this.printWholeProgress();
            System.out.print(" " + Kronometre.getPrintable(this.estimateRemainingTime()));
            if (message != null) {
                System.out.print(" (" + message + ")");
            }
        } else if (p == 1) {
            System.out.print(DOT);
        } else if (p > 1) {
            for (int i = 0; i < p; ++i) {
                System.out.print(DOT);
            }
        }
    }

    private void printWholeProgress() {
        System.out.print("\r ");
        int p = (int)Math.ceil((double)this.counted / this.total * (double)this.length);
        for (int i = 0; i < p; ++i) {
            System.out.print(DOT);
        }
    }

    private long estimateRemainingTime() {
        long passed = this.kron.getPassedMilisec();
        double ratio = (this.total - (double)this.counted) / (double)this.counted;
        return (long)((double)passed * ratio);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 500; ++i) {
            System.out.println(i + "\t" + (char)i);
        }
        Progress p = new Progress(100, 54, "A special message");
        for (int i = 0; i < 100; ++i) {
            p.tick();
        }
    }
}

