/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.List;

public class RandomnessChecker {
    List<Double> values;

    public RandomnessChecker() {
        this(1000);
    }

    public RandomnessChecker(int initialSize) {
        this.values = new ArrayList<Double>(initialSize);
    }

    public void add(double pval) {
        this.values.add(pval);
    }

    public int getCount(double thr) {
        int cnt = 0;
        for (Double value : this.values) {
            if (!(value <= thr)) continue;
            ++cnt;
        }
        return cnt;
    }

    public String getStatusForThreshold(double thr) {
        double e = this.getExpected(thr);
        int o = this.getCount(thr);
        double d = (double)o - e;
        return "Expected: " + e + "   Observed: " + o + "   Diff: " + (d > 0.0 ? "+" : "") + d + "   Off by " + (int)(Math.abs(d) * 100.0 / e) + "%";
    }

    public double getExpected(double thr) {
        return (double)this.values.size() * thr;
    }

    public static void main(String[] args) {
        RandomnessChecker rc = new RandomnessChecker();
        for (int i = 0; i < 10000; ++i) {
            rc.add(Math.random());
        }
        System.out.println(rc.getStatusForThreshold(0.05));
    }
}

