/*
 * Decompiled with CFR 0.152.
 */
package org.cbio.causality.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.cbio.causality.util.Summary;

public class ScoreUtil {
    private List<Double> scores;
    private double max;
    private double min;
    protected int multiFactor;
    public static final double EPS = 1.0E-8;

    public ScoreUtil() {
        this(1);
    }

    public ScoreUtil(int multiFactor) {
        this.multiFactor = multiFactor;
        this.scores = new ArrayList<Double>();
    }

    public void addSCore(double d) {
        if (this.scores.isEmpty()) {
            this.min = d;
            this.max = d;
        }
        this.scores.add(d);
        if (d > this.max) {
            this.max = d;
        } else if (d < this.min) {
            this.min = d;
        }
    }

    public void unite(ScoreUtil sc) {
        this.scores.addAll(sc.scores);
        this.multiFactor += sc.multiFactor;
        if (this.max < sc.max) {
            this.max = sc.max;
        }
        if (this.min > sc.min) {
            this.min = sc.min;
        }
    }

    public int countOverThr(double thr) {
        int cnt = 0;
        for (Double score : this.scores) {
            if (!(score >= thr)) continue;
            ++cnt;
        }
        return cnt;
    }

    public double getThresholdForFDR(ScoreUtil real, double fdr) {
        if (this.getFDRForThr(real, real.max) > fdr) {
            return real.max + 1.0E-8;
        }
        double highFDR = this.getFDRForThr(real, this.min);
        if (highFDR <= fdr) {
            return this.min;
        }
        List<Double> sorted = this.getSortedValues();
        double minVal = this.max + 1.0E-8;
        for (Double val : sorted) {
            double FDR2 = this.getFDRForThr(real, val);
            if (!(FDR2 <= fdr) || !(val < minVal)) continue;
            minVal = val;
        }
        return minVal;
    }

    public List<Double> getSortedValues() {
        HashSet<Double> set = new HashSet<Double>(this.scores);
        ArrayList<Double> list = new ArrayList<Double>(set);
        Collections.sort(list);
        Collections.reverse(list);
        return list;
    }

    public double getFDRForThr(ScoreUtil real, double thr) {
        int ranCnt = this.countOverThr(thr);
        int norCnt = real.countOverThr(thr);
        if (norCnt == 0) {
            return 0.0;
        }
        double ranNormalized = (double)ranCnt / (double)this.multiFactor;
        double norNormalized = (double)norCnt / (double)real.multiFactor;
        return ranNormalized / norNormalized;
    }

    public double getTotal() {
        return Summary.sum(this.scores);
    }
}

