/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.widgets;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.widgets.ImageBorder;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public final class MultiLineLabel
extends FigureCanvas {
    private TextFlow textFlow;
    static final Border MARGIN = new MarginBorder(2);
    private Image image;

    public MultiLineLabel(Composite parent) {
        super(parent);
        this.setViewport(new FocusableViewport());
        FlowPage page = new FlowPage();
        this.textFlow = new TextFlow();
        page.add(this.textFlow);
        this.setContents(page);
        this.getViewport().setContentsTracksWidth(true);
        this.addAccessibility();
    }

    private void addAccessibility() {
        this.getAccessible().addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
            }
        });
        this.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = MultiLineLabel.this.getText();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean mirrored;
                Point p = MultiLineLabel.this.getViewport().getViewLocation();
                int dy = MultiLineLabel.this.getFont().getFontData()[0].getHeight();
                int dx = dy * 3 / 2;
                boolean bl = mirrored = (e.widget.getStyle() & 0x8000000) != 0;
                if (e.keyCode == 0x1000002) {
                    MultiLineLabel.this.scrollToY(p.y + dy / 2);
                    MultiLineLabel.this.scrollToY(p.y + dy);
                    MultiLineLabel.this.scrollToY(p.y + dy * 3 / 2);
                    MultiLineLabel.this.scrollToY(p.y + dy * 2);
                } else if (e.keyCode == 0x1000001) {
                    MultiLineLabel.this.scrollToY(p.y - dy / 2);
                    MultiLineLabel.this.scrollToY(p.y - dy);
                    MultiLineLabel.this.scrollToY(p.y - dy * 3 / 2);
                    MultiLineLabel.this.scrollToY(p.y - dy * 2);
                } else if (!mirrored && e.keyCode == 0x1000004 || mirrored && e.keyCode == 0x1000003) {
                    MultiLineLabel.this.scrollToX(p.x + dx);
                    MultiLineLabel.this.scrollToX(p.x + dx * 2);
                    MultiLineLabel.this.scrollToX(p.x + dx * 3);
                } else if (!mirrored && e.keyCode == 0x1000003 || mirrored && e.keyCode == 0x1000004) {
                    MultiLineLabel.this.scrollToX(p.x - dx);
                    MultiLineLabel.this.scrollToX(p.x - dx * 2);
                    MultiLineLabel.this.scrollToX(p.x - dx * 3);
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textFlow.setEnabled(this.getEnabled());
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textFlow.revalidate();
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            this.setBorder(new ImageBorder(image));
        } else {
            this.setBorder(null);
        }
    }

    public void setText(String text) {
        this.textFlow.setText(text);
    }

    class FocusableViewport
    extends Viewport {
        FocusableViewport() {
            super(true);
            this.setFocusTraversable(true);
            this.setBorder(MARGIN);
        }

        public void handleFocusGained(FocusEvent event) {
            super.handleFocusGained(event);
            this.repaint();
        }

        public void handleFocusLost(FocusEvent event) {
            super.handleFocusLost(event);
            this.repaint();
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.hasFocus()) {
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.drawFocus(this.getBounds().getResized(-1, -1));
            }
        }
    }
}

