/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;

class DropShadowButtonBorder
extends AbstractBorder {
    protected Insets insets = new Insets(1, 1, 3, 3);
    private static final Color highlight = ColorConstants.menuBackgroundSelected;
    private static final Color dropshadow2 = new Color(null, ViewForm.borderMiddleRGB);
    private static final Color dropshadow3 = new Color(null, ViewForm.borderOutsideRGB);

    DropShadowButtonBorder() {
    }

    public Insets getInsets(IFigure figure) {
        return this.insets;
    }

    public boolean isOpaque() {
        return true;
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        ButtonModel model = ((Clickable)figure).getModel();
        Rectangle r = DropShadowButtonBorder.getPaintRectangle(figure, insets);
        g.setLineWidth(1);
        r.width -= 3;
        r.height -= 3;
        if (model.isMouseOver() && !model.isArmed()) {
            g.setForegroundColor(highlight);
            g.drawRectangle(r);
            r.translate(1, 1);
            g.setForegroundColor(dropshadow2);
            g.drawLine(r.x, r.bottom(), r.right(), r.bottom());
            g.drawLine(r.right(), r.y, r.right(), r.bottom());
            r.translate(1, 1);
            g.setForegroundColor(dropshadow3);
            g.drawLine(r.x + 1, r.bottom(), r.right() - 1, r.bottom());
            g.drawLine(r.right(), r.y + 1, r.right(), r.bottom() - 1);
        } else if (model.isPressed()) {
            r.translate(1, 1);
            g.setForegroundColor(highlight);
            g.drawRectangle(r);
            r.translate(1, 1);
            g.setForegroundColor(dropshadow2);
            g.drawLine(r.x, r.bottom(), r.right(), r.bottom());
            g.drawLine(r.right(), r.y, r.right(), r.bottom());
        } else {
            r.translate(1, 1);
            g.setForegroundColor(dropshadow3);
            g.drawRectangle(r);
            r.translate(1, 1);
            g.drawLine(r.x, r.bottom(), r.right(), r.bottom());
            g.drawLine(r.right(), r.y, r.right(), r.bottom());
        }
    }
}

