/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.lang.reflect.Constructor;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class DirectEditManager {
    private static final Color BLUE = ColorConstants.menuBackgroundSelected;
    private static final Border BORDER_FRAME = new DirectEditBorder();
    private AncestorListener ancestorListener;
    private EditPartListener editPartListener;
    private ControlListener controlListener;
    private IFigure cellEditorFrame;
    private ICellEditorListener cellEditorListener;
    private boolean showingFeedback;
    private boolean dirty;
    private DirectEditRequest request;
    private CellEditorLocator locator;
    private GraphicalEditPart source;
    private CellEditor ce;
    private Class editorType;
    private boolean committing = false;
    static /* synthetic */ Class class$0;

    public DirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        this.source = source;
        this.locator = locator;
        this.editorType = editorType;
    }

    protected void bringDown() {
        this.eraseFeedback();
        this.unhookListeners();
        if (this.getCellEditor() != null) {
            this.getCellEditor().deactivate();
            this.getCellEditor().dispose();
            this.setCellEditor(null);
        }
        this.request = null;
        this.dirty = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commit() {
        if (this.committing) {
            return;
        }
        this.committing = true;
        try {
            this.eraseFeedback();
            if (this.isDirty()) {
                CommandStack stack = this.getEditPart().getViewer().getEditDomain().getCommandStack();
                stack.execute(this.getEditPart().getCommand(this.getDirectEditRequest()));
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.bringDown();
            this.committing = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.bringDown();
            this.committing = false;
            return;
        }
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Composite");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor constructor = this.editorType.getConstructor(classArray);
            return (CellEditor)constructor.newInstance(composite);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DirectEditRequest createDirectEditRequest() {
        DirectEditRequest req = new DirectEditRequest();
        req.setCellEditor(this.getCellEditor());
        return req;
    }

    protected void eraseFeedback() {
        if (this.showingFeedback) {
            LayerManager.Helper.find(this.getEditPart()).getLayer("Feedback Layer").remove(this.getCellEditorFrame());
            this.cellEditorFrame = null;
            this.getEditPart().eraseSourceFeedback(this.getDirectEditRequest());
            this.showingFeedback = false;
        }
    }

    protected CellEditor getCellEditor() {
        return this.ce;
    }

    private IFigure getCellEditorFrame() {
        if (this.cellEditorFrame != null) {
            return this.cellEditorFrame;
        }
        this.cellEditorFrame = new Figure();
        this.cellEditorFrame.setBorder(BORDER_FRAME);
        return this.cellEditorFrame;
    }

    private Control getControl() {
        return this.ce.getControl();
    }

    protected DirectEditRequest getDirectEditRequest() {
        if (this.request == null) {
            this.request = this.createDirectEditRequest();
        }
        return this.request;
    }

    protected GraphicalEditPart getEditPart() {
        return this.source;
    }

    private CellEditorLocator getLocator() {
        return this.locator;
    }

    private void handleValueChanged() {
        this.setDirty(true);
        this.showFeedback();
        this.placeCellEditor();
    }

    private void hookListeners() {
        this.ancestorListener = new AncestorListener.Stub(){

            public void ancestorMoved(IFigure ancestor) {
                DirectEditManager.this.placeCellEditor();
            }
        };
        this.getEditPart().getFigure().addAncestorListener(this.ancestorListener);
        Control control2 = this.getControl();
        this.controlListener = new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                Display.getCurrent().asyncExec(new Runnable(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        DirectEditManager.access$2(2.access$0(this.this$1));
                    }
                });
            }

            public void controlResized(ControlEvent e) {
                DirectEditManager.this.placeBorder();
            }

            static /* synthetic */ DirectEditManager access$0(2 var0) {
                return var0.DirectEditManager.this;
            }
        };
        control2.addControlListener(this.controlListener);
        this.cellEditorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                DirectEditManager.this.commit();
            }

            public void cancelEditor() {
                DirectEditManager.this.bringDown();
            }

            public void editorValueChanged(boolean old, boolean newState) {
                DirectEditManager.this.handleValueChanged();
            }
        };
        this.getCellEditor().addListener(this.cellEditorListener);
        this.editPartListener = new EditPartListener.Stub(){

            public void partDeactivated(EditPart editpart) {
                DirectEditManager.this.bringDown();
            }
        };
        this.getEditPart().addEditPartListener(this.editPartListener);
    }

    protected abstract void initCellEditor();

    protected boolean isDirty() {
        return this.dirty;
    }

    private void placeBorder() {
        if (this.showingFeedback) {
            IFigure shadow = this.getCellEditorFrame();
            Rectangle rect = new Rectangle(this.getCellEditor().getControl().getBounds());
            rect.expand(shadow.getInsets());
            shadow.translateToRelative(rect);
            shadow.setBounds(rect);
        }
    }

    private void placeCellEditor() {
        this.getLocator().relocate(this.getCellEditor());
    }

    protected void setCellEditor(CellEditor editor) {
        this.ce = editor;
        if (this.ce == null) {
            return;
        }
        this.hookListeners();
    }

    protected void setDirty(boolean value) {
        this.dirty = value;
    }

    protected void setEditPart(GraphicalEditPart source) {
        this.source = source;
    }

    public void setLocator(CellEditorLocator locator) {
        this.locator = locator;
    }

    public void show() {
        if (this.getCellEditor() != null) {
            return;
        }
        Composite composite = (Composite)this.source.getViewer().getControl();
        this.setCellEditor(this.createCellEditorOn(composite));
        if (this.getCellEditor() == null) {
            return;
        }
        this.initCellEditor();
        this.getCellEditor().activate();
        this.placeCellEditor();
        this.getControl().setVisible(true);
        this.getCellEditor().setFocus();
        this.showFeedback();
    }

    private void showCellEditorFrame() {
        LayerManager.Helper.find(this.getEditPart()).getLayer("Feedback Layer").add(this.getCellEditorFrame());
        this.placeBorder();
    }

    public void showFeedback() {
        if (!this.showingFeedback) {
            this.showCellEditorFrame();
        }
        this.showingFeedback = true;
        this.showCellEditorFrame();
        this.getEditPart().showSourceFeedback(this.getDirectEditRequest());
    }

    protected void unhookListeners() {
        this.getEditPart().getFigure().removeAncestorListener(this.ancestorListener);
        this.getEditPart().removeEditPartListener(this.editPartListener);
        this.ancestorListener = null;
        this.editPartListener = null;
        if (this.getCellEditor() == null) {
            return;
        }
        this.getCellEditor().removeListener(this.cellEditorListener);
        this.cellEditorListener = null;
        Control control2 = this.getCellEditor().getControl();
        if (control2 == null || control2.isDisposed()) {
            return;
        }
        control2.removeControlListener(this.controlListener);
        this.controlListener = null;
    }

    private static class DirectEditBorder
    extends AbstractBorder {
        private static final Insets insets = new Insets(1, 2, 2, 2);

        DirectEditBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return insets;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle rect = DirectEditBorder.getPaintRectangle(figure, insets);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.drawLine(rect.x, rect.y, rect.x, rect.bottom());
            ++rect.x;
            --rect.width;
            rect.resize(-1, -1);
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawLine(rect.x + 2, rect.bottom(), rect.right(), rect.bottom());
            graphics.drawLine(rect.right(), rect.bottom(), rect.right(), rect.y + 2);
            rect.resize(-1, -1);
            graphics.setForegroundColor(BLUE);
            graphics.drawRectangle(rect);
        }
    }
}

