/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionSynchronizer
implements ISelectionChangedListener {
    private List viewers = new ArrayList();
    private boolean isDispatching = false;
    private int disabled = 0;
    private EditPartViewer pendingSelection;

    public void addViewer(EditPartViewer viewer) {
        viewer.addSelectionChangedListener(this);
        this.viewers.add(viewer);
    }

    protected EditPart convert(EditPartViewer viewer, EditPart part) {
        Object temp = viewer.getEditPartRegistry().get(part.getModel());
        EditPart newPart = null;
        if (temp != null) {
            newPart = (EditPart)temp;
        }
        return newPart;
    }

    public void removeViewer(EditPartViewer viewer) {
        viewer.removeSelectionChangedListener(this);
        this.viewers.remove(viewer);
        if (this.pendingSelection == viewer) {
            this.pendingSelection = null;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.isDispatching) {
            return;
        }
        EditPartViewer source = (EditPartViewer)event.getSelectionProvider();
        if (this.disabled > 0) {
            this.pendingSelection = source;
        } else {
            ISelection selection = event.getSelection();
            this.syncSelection(source, selection);
        }
    }

    private void syncSelection(EditPartViewer source, ISelection selection) {
        this.isDispatching = true;
        int i = 0;
        while (i < this.viewers.size()) {
            if (this.viewers.get(i) != source) {
                EditPartViewer viewer = (EditPartViewer)this.viewers.get(i);
                this.setViewerSelection(viewer, selection);
            }
            ++i;
        }
        this.isDispatching = false;
    }

    public void setEnabled(boolean value) {
        if (!value) {
            ++this.disabled;
        } else if (--this.disabled == 0 && this.pendingSelection != null) {
            this.syncSelection(this.pendingSelection, this.pendingSelection.getSelection());
            this.pendingSelection = null;
        }
    }

    private void setViewerSelection(EditPartViewer viewer, ISelection selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            EditPart part = this.convert(viewer, (EditPart)iter.next());
            if (part == null) continue;
            result.add(part);
        }
        viewer.setSelection(new StructuredSelection(result));
        if (result.size() > 0) {
            viewer.reveal((EditPart)result.get(result.size() - 1));
        }
    }
}

