/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

class Splitter
extends Composite {
    public static final int DEFAULT_SASH_WIDTH = 5;
    private static final int DRAG_MINIMUM = 62;
    private static final String MAINTAIN_SIZE = "maintain size";
    private int fixedSize = 150;
    private int orientation = 512;
    private Sash[] sashes = new Sash[0];
    private Control[] controls = new Control[0];
    private Control maxControl = null;
    private Listener sashListener;
    private int sashWidth = 5;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public void addFixedSizeChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(int oldValue, int newValue) {
        this.listeners.firePropertyChange(MAINTAIN_SIZE, oldValue, newValue);
    }

    public void removeFixedSizeChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public int getFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(int newSize) {
        if (newSize == this.fixedSize) {
            return;
        }
        this.fixedSize = newSize;
        this.firePropertyChange(this.fixedSize, this.fixedSize);
    }

    public Splitter(Composite parent, int style) {
        super(parent, Splitter.checkStyle(style));
        if ((style & 0x100) != 0) {
            this.orientation = 256;
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Splitter.this.layout(true);
            }
        });
        this.sashListener = new Listener(){

            public void handleEvent(Event e) {
                Splitter.this.onDragSash(e);
            }
        };
    }

    private static int checkStyle(int style) {
        int mask = 2048;
        return style & mask;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        boolean vertical;
        Control[] controls = this.getControls(true);
        if (controls.length == 0) {
            return new Point(wHint, hHint);
        }
        int width = 0;
        int height = 0;
        boolean bl = vertical = (this.getStyle() & 0x200) != 0;
        if (vertical) {
            width = wHint;
            height += (controls.length - 1) * this.getSashWidth();
        } else {
            height = hHint;
            width += controls.length * this.getSashWidth();
        }
        int i = 0;
        while (i < controls.length) {
            Point size;
            if (vertical) {
                size = controls[i].computeSize(wHint, -1);
                height += size.y;
            } else {
                size = controls[i].computeSize(-1, hHint);
                if (controls[i].getData(MAINTAIN_SIZE) != null) {
                    size.x = this.fixedSize;
                }
                width += size.x;
            }
            ++i;
        }
        return new Point(width, height);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getSashWidth() {
        return this.sashWidth;
    }

    public Control getMaximizedControl() {
        return this.maxControl;
    }

    private Control[] getControls(boolean onlyVisible) {
        Control[] children = this.getChildren();
        Control[] controls = new Control[]{};
        int i = 0;
        while (i < children.length) {
            if (!(children[i] instanceof Sash || onlyVisible && !children[i].getVisible())) {
                Control[] newControls = new Control[controls.length + 1];
                System.arraycopy(controls, 0, newControls, 0, controls.length);
                newControls[controls.length] = children[i];
                controls = newControls;
            }
            ++i;
        }
        return controls;
    }

    public void layout(boolean changed) {
        int i;
        Sash[] newSashes;
        Rectangle area = this.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        Control[] newControls = this.getControls(true);
        if (this.controls.length == 0 && newControls.length == 0) {
            return;
        }
        this.controls = newControls;
        if (this.maxControl != null && !this.maxControl.isDisposed()) {
            int i2 = 0;
            while (i2 < this.controls.length) {
                if (this.controls[i2] != this.maxControl) {
                    this.controls[i2].setBounds(-200, -200, 0, 0);
                } else {
                    this.controls[i2].setBounds(area);
                }
                ++i2;
            }
            return;
        }
        if (this.sashes.length < this.controls.length - 1) {
            newSashes = new Sash[this.controls.length - 1];
            System.arraycopy(this.sashes, 0, newSashes, 0, this.sashes.length);
            int sashOrientation = this.orientation == 256 ? 512 : 256;
            i = this.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = new Sash(this, sashOrientation);
                newSashes[i].setBackground(ColorConstants.button);
                newSashes[i].addListener(9, new SashPainter());
                newSashes[i].addListener(13, this.sashListener);
                ++i;
            }
            this.sashes = newSashes;
        }
        if (this.sashes.length > this.controls.length - 1) {
            if (this.controls.length == 0) {
                int i3 = 0;
                while (i3 < this.sashes.length) {
                    this.sashes[i3].dispose();
                    ++i3;
                }
                this.sashes = new Sash[0];
            } else {
                newSashes = new Sash[this.controls.length - 1];
                System.arraycopy(this.sashes, 0, newSashes, 0, newSashes.length);
                int i4 = this.controls.length - 1;
                while (i4 < this.sashes.length) {
                    this.sashes[i4].dispose();
                    ++i4;
                }
                this.sashes = newSashes;
            }
        }
        if (this.controls.length == 0) {
            return;
        }
        int x = area.x;
        i = 0;
        while (i < this.controls.length) {
            int width;
            Control control2 = this.controls[i];
            if (control2.getData(MAINTAIN_SIZE) != null) {
                width = this.fixedSize;
                if (width > area.width) {
                    width = area.width - this.getSashWidth();
                }
                control2.setBounds(x, area.y, width, area.height);
                x += width + this.getSashWidth();
            } else {
                width = Math.max(area.width - this.fixedSize - this.getSashWidth(), 0);
                control2.setBounds(x, area.y, width, area.height);
                x += width + this.getSashWidth();
            }
            ++i;
        }
        if (this.sashes.length > 0) {
            this.sashes[0].setBounds(this.controls[0].getBounds().x + this.controls[0].getBounds().width, area.y, this.getSashWidth(), area.height);
        }
    }

    public void maintainSize(Control c) {
        Control[] controls = this.getControls(false);
        int i = 0;
        while (i < controls.length) {
            Control ctrl = controls[i];
            if (ctrl == c) {
                ctrl.setData(MAINTAIN_SIZE, new Boolean(true));
                break;
            }
            ++i;
        }
    }

    void paint(Sash sash, GC gc) {
        if (this.getSashWidth() == 0) {
            return;
        }
        Point size = sash.getSize();
        if (this.getOrientation() == 256) {
            gc.setForeground(ColorConstants.buttonDarker);
            gc.drawLine(this.getSashWidth() - 1, 0, this.getSashWidth() - 1, size.y);
            gc.setForeground(ColorConstants.buttonLightest);
            gc.drawLine(0, 0, 0, size.y);
        } else {
            gc.setForeground(ColorConstants.buttonDarker);
            gc.drawLine(0, 0, size.x, 0);
            gc.drawLine(0, this.getSashWidth() - 1, size.x, this.getSashWidth() - 1);
            gc.setForeground(ColorConstants.buttonLightest);
            gc.drawLine(0, 1, size.x, 1);
        }
    }

    private void onDragSash(Event event) {
        if (event.detail == 1) {
            Rectangle area = this.getClientArea();
            if (this.orientation == 256) {
                event.x = this.controls[0].getData(MAINTAIN_SIZE) != null ? Math.max(event.x, 62) : Math.min(event.x, area.width - 62 - this.getSashWidth());
            } else {
                event.y = Math.min(event.y, area.height - 62 - this.getSashWidth());
            }
            return;
        }
        Sash sash = (Sash)event.widget;
        int sashIndex = -1;
        int i = 0;
        while (i < this.sashes.length) {
            if (this.sashes[i] == sash) {
                sashIndex = i;
                break;
            }
            ++i;
        }
        if (sashIndex == -1) {
            return;
        }
        Control c1 = this.controls[sashIndex];
        Control c2 = this.controls[sashIndex + 1];
        Rectangle b1 = c1.getBounds();
        Rectangle b2 = c2.getBounds();
        this.controls = this.getControls(false);
        Rectangle sashBounds = sash.getBounds();
        if (this.orientation == 256) {
            int shift = event.x - sashBounds.x;
            b1.width += shift;
            b2.x += shift;
            b2.width -= shift;
        } else {
            int shift = event.y - sashBounds.y;
            b1.height += shift;
            b2.y += shift;
            b2.height -= shift;
        }
        c1.setBounds(b1);
        sash.setBounds(event.x, event.y, event.width, event.height);
        c2.setBounds(b2);
        if (c1.getData(MAINTAIN_SIZE) != null) {
            this.setFixedSize(c1.getBounds().width);
        } else {
            this.setFixedSize(c2.getBounds().width);
        }
    }

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        if (orientation != 256 && orientation != 512) {
            SWT.error(5);
        }
        this.orientation = orientation;
        int sashOrientation = orientation == 256 ? 512 : 256;
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].dispose();
            this.sashes[i] = new Sash(this, sashOrientation);
            this.sashes[i].setBackground(ColorConstants.buttonLightest);
            this.sashes[i].addListener(13, this.sashListener);
            ++i;
        }
        this.layout();
    }

    public void setSashWidth(int width) {
        this.sashWidth = width;
    }

    public void setLayout(Layout layout) {
    }

    public void setMaximizedControl(Control control2) {
        if (control2 == null) {
            if (this.maxControl != null) {
                this.maxControl = null;
                this.layout();
                int i = 0;
                while (i < this.sashes.length) {
                    this.sashes[i].setVisible(true);
                    ++i;
                }
            }
            return;
        }
        int i = 0;
        while (i < this.sashes.length) {
            this.sashes[i].setVisible(false);
            ++i;
        }
        this.maxControl = control2;
        this.layout();
    }

    class SashPainter
    implements Listener {
        SashPainter() {
        }

        public void handleEvent(Event e) {
            Splitter.this.paint((Sash)e.widget, e.gc);
        }
    }
}

