/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileInputStream;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFileOutputStream;
import org.eclipse.osgi.util.NLS;

public class DefaultPermissionStorage
implements PermissionStorage {
    private static final String CONDPERMS = "condPerms";
    protected File permissionDir;
    protected Hashtable permissionFiles;
    protected File defaultData;
    protected static final int PERMISSIONDATA_VERSION_1 = 1;
    protected static final int PERMISSIONDATA_VERSION = 1;

    public DefaultPermissionStorage(AbstractFrameworkAdaptor adaptor) throws IOException {
        this.permissionDir = new File(adaptor.getBundleStoreRootDir(), "permdata");
        this.permissionFiles = new Hashtable();
        if (!this.permissionDir.exists() && !this.permissionDir.mkdirs()) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Unable to create directory: " + this.permissionDir.getPath());
            }
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, this.permissionDir));
        }
        this.defaultData = new File(this.permissionDir, ".default");
        this.loadLocations();
    }

    public synchronized String[] getLocations() throws IOException {
        int size = this.permissionFiles.size();
        if (size == 0) {
            return null;
        }
        String[] locations = new String[size];
        Enumeration keysEnum = this.permissionFiles.keys();
        int i = 0;
        while (i < size) {
            locations[i] = (String)keysEnum.nextElement();
            ++i;
        }
        return locations;
    }

    public synchronized String[] getPermissionData(String location) throws IOException {
        File file;
        if (location == null) {
            file = this.defaultData;
        } else {
            file = (File)this.permissionFiles.get(location);
            if (file == null) {
                return null;
            }
        }
        try {
            return this.readData(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public synchronized void setPermissionData(String location, String[] data) throws IOException {
        if (location == null) {
            File file = this.defaultData;
            if (data == null) {
                ReliableFile.delete(this.defaultData);
            } else {
                this.save(this.defaultData, null, data);
            }
        } else {
            File file = (File)this.permissionFiles.get(location);
            if (data == null) {
                if (file == null) {
                    return;
                }
                this.permissionFiles.remove(location);
                ReliableFile.delete(file);
            } else {
                file = this.save(file, location, data);
                this.permissionFiles.put(location, file);
            }
        }
    }

    protected void loadLocations() throws IOException {
        String[] list = ReliableFile.getBaseFiles(this.permissionDir);
        if (list == null) {
            return;
        }
        int len = list.length;
        int i = 0;
        while (i < len) {
            String name = list[i];
            if (!name.endsWith(".tmp") && !name.equals(CONDPERMS)) {
                File file = new File(this.permissionDir, name);
                try {
                    String location = this.readLocation(file);
                    if (location != null) {
                        this.permissionFiles.put(location, file);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLocation(File file) throws IOException {
        DataInputStream in;
        block6: {
            String string;
            in = new DataInputStream(new ReliableFileInputStream(file));
            try {
                int version = in.readInt();
                switch (version) {
                    case 1: {
                        String location;
                        boolean locationPresent = in.readBoolean();
                        if (!locationPresent) break block6;
                        string = location = in.readUTF();
                        Object var6_7 = null;
                        break;
                    }
                    default: {
                        throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return string;
        }
        Object var6_9 = null;
        in.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] readData(File file) throws IOException {
        String[] stringArray;
        DataInputStream in;
        block8: {
            in = new DataInputStream(new ReliableFileInputStream(file));
            try {
                int version = in.readInt();
                switch (version) {
                    case 1: {
                        boolean locationPresent = in.readBoolean();
                        if (locationPresent) {
                            in.readUTF();
                        }
                        int size = in.readInt();
                        String[] data = new String[size];
                        int i = 0;
                        while (true) {
                            if (i >= size) {
                                stringArray = data;
                                Object var8_9 = null;
                                break block8;
                            }
                            data[i] = in.readUTF();
                            ++i;
                        }
                    }
                    default: {
                        throw new IOException(AdaptorMsg.ADAPTOR_STORAGE_EXCEPTION);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                in.close();
                throw throwable;
            }
        }
        in.close();
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File save(File file, String location, String[] data) throws IOException {
        if (file == null) {
            file = File.createTempFile("perm", "", this.permissionDir);
            file.delete();
        }
        int size = data.length;
        DataOutputStream out = new DataOutputStream(new ReliableFileOutputStream(file));
        try {
            out.writeInt(1);
            if (location == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(location);
            }
            out.writeInt(size);
            int i = 0;
            while (i < size) {
                out.writeUTF(data[i]);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            out.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        out.close();
        return file;
    }

    /*
     * Exception decompiling
     */
    public void serializeConditionalPermissionInfos(Vector v) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 198->202)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Vector deserializeConditionalPermissionInfos() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 261->264)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

