/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;

public class MultiSourcePackage
extends PackageSource {
    SingleSourcePackage[] suppliers;

    MultiSourcePackage(String id, SingleSourcePackage[] suppliers) {
        super(id);
        this.suppliers = suppliers;
    }

    public SingleSourcePackage[] getSuppliers() {
        return this.suppliers;
    }

    public Class loadClass(String name) {
        Class result = null;
        int i = 0;
        while (i < this.suppliers.length) {
            result = this.suppliers[i].loadClass(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    public URL getResource(String name) {
        URL result = null;
        int i = 0;
        while (i < this.suppliers.length) {
            result = this.suppliers[i].getResource(name);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    public Enumeration getResources(String name) {
        Enumeration firstResult = null;
        Vector compoundResults = null;
        int i = 0;
        while (i < this.suppliers.length) {
            Enumeration resources = this.suppliers[i].getResources(name);
            if (resources != null) {
                if (firstResult == null) {
                    firstResult = resources;
                } else {
                    if (compoundResults == null) {
                        compoundResults = new Vector();
                        while (firstResult.hasMoreElements()) {
                            compoundResults.add(firstResult.nextElement());
                        }
                    }
                    while (resources.hasMoreElements()) {
                        compoundResults.add(resources.nextElement());
                    }
                }
            }
            ++i;
        }
        return compoundResults == null ? firstResult : compoundResults.elements();
    }
}

