/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;

public class GroupingChecker {
    HashMap bundles = new HashMap();

    private ArrayList getConstraints(ResolverExport constrained) {
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            return null;
        }
        ArrayList constraints = (ArrayList)exports.get(constrained);
        if (constraints == null) {
            return null;
        }
        ArrayList results = new ArrayList(constraints.size());
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            ResolverExport impConstraint;
            Object constraint = iter.next();
            if (constraint instanceof ResolverExport && !results.contains(constraint)) {
                results.add(constraint);
                continue;
            }
            ResolverImport imp = (ResolverImport)constraint;
            if (imp.getMatchingExport() == null || (impConstraint = imp.getMatchingExport().getRoot()) == null || results.contains(impConstraint)) continue;
            results.add(impConstraint);
        }
        return results;
    }

    private ArrayList createConstraints(ResolverExport constrained) {
        ArrayList constraints;
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            exports = new HashMap();
            this.bundles.put(constrained.getExporter(), exports);
        }
        if ((constraints = (ArrayList)exports.get(constrained)) == null) {
            constraints = new ArrayList();
            exports.put(constrained, constraints);
        }
        return constraints;
    }

    private void addConstraint(ResolverExport constrained, Object constraint) {
        ArrayList list = this.createConstraints(constrained);
        if (!list.contains(constraint)) {
            list.add(constraint);
        }
    }

    private void addConstraints(ResolverExport constrained, ArrayList newConstraints) {
        ArrayList list = this.createConstraints(constrained);
        int i = 0;
        while (i < newConstraints.size()) {
            Object constraint = newConstraints.get(i);
            if (!list.contains(constraint)) {
                list.add(constraint);
            }
            ++i;
        }
    }

    void removeAllExportConstraints(ResolverBundle bundle) {
        this.bundles.remove(bundle);
    }

    ResolverExport isConsistent(ResolverImport imp, ResolverExport exp) {
        ResolverImport[] imports = imp.getBundle().getImportPackages();
        BundleConstraint[] requires = imp.getBundle().getRequires();
        int i = 0;
        while (i < imports.length) {
            ResolverExport wire = imports[i].getMatchingExport();
            if (wire != null) {
                ResolverExport re;
                int j;
                ArrayList list = this.getConstraints(wire);
                if (list != null) {
                    j = 0;
                    while (j < list.size()) {
                        re = (ResolverExport)list.get(j);
                        if (!re.isDropped() && re.getExporter().isResolvable() && exp.getName().equals(re.getName()) && !ResolverExport.isOnRootPath(re.getExporter(), imp.getMatchingExport()) && !imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) {
                            return wire;
                        }
                        ++j;
                    }
                }
                if ((list = this.getConstraints(exp)) != null) {
                    j = 0;
                    while (j < list.size()) {
                        re = (ResolverExport)list.get(j);
                        if (!re.isDropped()) {
                            if (re.getExporter().isResolvable() && wire.getName().equals(re.getName()) && !ResolverExport.isOnRootPath(re.getExporter(), imports[i].getMatchingExport()) && !imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) {
                                return wire;
                            }
                            int k = 0;
                            while (k < requires.length) {
                                if (requires[k].getMatchingBundle() != null) {
                                    ResolverExport[] exports = requires[k].getMatchingBundle().getExportPackages();
                                    int m = 0;
                                    while (m < exports.length) {
                                        if (re.getExporter().isResolvable() && exports[m].getName().equals(re.getName()) && !ResolverExport.isOnRootPath(re.getExporter(), exports[m])) {
                                            return re;
                                        }
                                        ++m;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() != null) {
                ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    ArrayList list = this.getConstraints(exports[j]);
                    if (list != null) {
                        int k = 0;
                        while (k < list.size()) {
                            ResolverExport re = (ResolverExport)list.get(k);
                            if (re.getExporter().isResolvable() && exp.getName().equals(re.getName()) && !ResolverExport.isOnRootPath(re.getExporter(), imp.getMatchingExport())) {
                                return re;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    boolean checkRequiresConstraints(ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        if (requires == null) {
            return true;
        }
        int i = 0;
        while (i < requires.length) {
            ResolverBundle matchingBundle = requires[i].getMatchingBundle();
            if (matchingBundle != null) {
                ResolverExport[] exports = matchingBundle.getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    ArrayList list = this.getConstraints(exports[j]);
                    if (list != null) {
                        int k = 0;
                        while (k < list.size()) {
                            ResolverExport constraint = (ResolverExport)list.get(k);
                            boolean foundPotential = false;
                            boolean found = false;
                            int m = 0;
                            while (m < requires.length) {
                                if (requires[m].getMatchingBundle() != null) {
                                    ResolverExport[] exps = requires[m].getMatchingBundle().getExportPackages();
                                    int n = 0;
                                    while (n < exps.length) {
                                        if (constraint.getExporter().isResolvable() && constraint.getName().equals(exps[n].getName())) {
                                            foundPotential = true;
                                            if (exps[n] == constraint || ResolverExport.isOnRootPath(constraint.getExporter(), exps[n])) {
                                                found = true;
                                                break;
                                            }
                                        }
                                        ++n;
                                    }
                                    if (found) break;
                                }
                                ++m;
                            }
                            if (foundPotential && !found) {
                                return false;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    void addInitialGroupingConstraints(ResolverBundle[] initBundles) {
        int i = 0;
        while (i < initBundles.length) {
            if (!this.bundles.containsKey(initBundles[i])) {
                ResolverExport[] exports = initBundles[i].getExportPackages();
                int j = 0;
                while (j < exports.length) {
                    String[] uses = (String[])exports[j].getExportPackageDescription().getDirective("uses");
                    if (uses != null) {
                        int k = 0;
                        while (k < uses.length) {
                            Object constraint = initBundles[i].getExport(uses[k]);
                            if (constraint != null) {
                                this.addConstraint(exports[j], constraint);
                                this.addTransitiveGroupingConstraints(exports[j], (ResolverExport)constraint);
                            }
                            if ((constraint = initBundles[i].getImport(uses[k])) != null) {
                                this.addConstraint(exports[j], constraint);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                if (this.bundles.get(initBundles[i]) == null) {
                    this.bundles.put(initBundles[i], null);
                }
            }
            ++i;
        }
    }

    private void addTransitiveGroupingConstraints(ResolverExport export, ResolverExport constraint) {
        if (export == constraint) {
            return;
        }
        String[] uses = (String[])constraint.getExportPackageDescription().getDirective("uses");
        if (uses == null) {
            return;
        }
        int i = 0;
        while (i < uses.length) {
            ArrayList list;
            Object newConstraint = export.getExporter().getExport(uses[i]);
            if (newConstraint == null) {
                newConstraint = export.getExporter().getImport(uses[i]);
            }
            if (!(newConstraint == null || newConstraint == constraint || (list = this.getConstraints(export)) != null && list.contains(newConstraint))) {
                this.addConstraint(export, newConstraint);
                if (newConstraint instanceof ResolverExport) {
                    this.addTransitiveGroupingConstraints(export, (ResolverExport)newConstraint);
                }
            }
            ++i;
        }
    }

    void addReExportConstraints(ResolverBundle bundle) {
        ResolverExport[] exports = bundle.getExportPackages();
        int i = 0;
        while (i < exports.length) {
            ArrayList list;
            ResolverExport root;
            if (!exports[i].getExportPackageDescription().isRoot() && (root = exports[i].getRoot()) != null && (list = this.getConstraints(root)) != null) {
                this.addConstraints(exports[i], list);
            }
            ++i;
        }
    }

    void addRequireConstraints(ResolverExport[] exports, ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        int i = 0;
        while (i < exports.length) {
            if (!exports[i].getExportPackageDescription().isRoot()) {
                int j = 0;
                while (j < requires.length) {
                    if (requires[j].getMatchingBundle() != null && exports[i].getExporter() != requires[j].getMatchingBundle()) {
                        ResolverExport[] requireExports = requires[j].getMatchingBundle().getExportPackages();
                        int k = 0;
                        while (k < requireExports.length) {
                            ArrayList list;
                            if (exports[i].getName().equals(requireExports[k].getName()) && (list = this.getConstraints(requireExports[k])) != null) {
                                int m = 0;
                                while (m < list.size()) {
                                    this.addConstraint(exports[i], list.get(m));
                                    ++m;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void addReprovideConstraints(ResolverExport re) {
        BundleConstraint[] requires = re.getExporter().getRequires();
        int i = 0;
        while (i < requires.length) {
            if (requires[i].getMatchingBundle() == null) {
                return;
            }
            ResolverExport[] requireExports = requires[i].getMatchingBundle().getExportPackages();
            int j = 0;
            while (j < requireExports.length) {
                ArrayList list;
                if (re.getName().equals(requireExports[j].getName()) && (list = this.getConstraints(requireExports[j])) != null) {
                    int k = 0;
                    while (k < list.size()) {
                        this.addConstraint(re, list.get(k));
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

