/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IAccessible;
import org.eclipse.swt.internal.ole.win32.IEnumVARIANT;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Accessible {
    int refCount = 0;
    int enumIndex = 0;
    COMObject objIAccessible;
    COMObject objIEnumVARIANT;
    IAccessible iaccessible;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector textListeners = new Vector();
    Object[] variants;
    Control control;

    Accessible(Control control2) {
        this.control = control2;
        long[] lArray = new long[1];
        int n = COM.CreateStdAccessibleObject(control2.handle, -4, COM.IIDIAccessible, lArray);
        if (lArray[0] == 0L) {
            return;
        }
        if (n != 0) {
            OLE.error(1001, n);
        }
        this.iaccessible = new IAccessible(lArray[0]);
        int[] nArray = new int[28];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 2;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 5;
        nArray[23] = 3;
        nArray[24] = 3;
        nArray[25] = 1;
        nArray[26] = 2;
        nArray[27] = 2;
        this.objIAccessible = new COMObject(nArray){

            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            public long method7(long[] lArray) {
                return Accessible.this.get_accParent(lArray[0]);
            }

            public long method8(long[] lArray) {
                return Accessible.this.get_accChildCount(lArray[0]);
            }

            public long method9(long[] lArray) {
                return Accessible.this.get_accChild(lArray[0], lArray[1]);
            }

            public long method10(long[] lArray) {
                return Accessible.this.get_accName(lArray[0], lArray[1]);
            }

            public long method11(long[] lArray) {
                return Accessible.this.get_accValue(lArray[0], lArray[1]);
            }

            public long method12(long[] lArray) {
                return Accessible.this.get_accDescription(lArray[0], lArray[1]);
            }

            public long method13(long[] lArray) {
                return Accessible.this.get_accRole(lArray[0], lArray[1]);
            }

            public long method14(long[] lArray) {
                return Accessible.this.get_accState(lArray[0], lArray[1]);
            }

            public long method15(long[] lArray) {
                return Accessible.this.get_accHelp(lArray[0], lArray[1]);
            }

            public long method16(long[] lArray) {
                return Accessible.this.get_accHelpTopic(lArray[0], lArray[1], lArray[2]);
            }

            public long method17(long[] lArray) {
                return Accessible.this.get_accKeyboardShortcut(lArray[0], lArray[1]);
            }

            public long method18(long[] lArray) {
                return Accessible.this.get_accFocus(lArray[0]);
            }

            public long method19(long[] lArray) {
                return Accessible.this.get_accSelection(lArray[0]);
            }

            public long method20(long[] lArray) {
                return Accessible.this.get_accDefaultAction(lArray[0], lArray[1]);
            }

            public long method21(long[] lArray) {
                return Accessible.this.accSelect((int)lArray[0], lArray[1]);
            }

            public long method22(long[] lArray) {
                return Accessible.this.accLocation(lArray[0], lArray[1], lArray[2], lArray[3], lArray[4]);
            }

            public long method23(long[] lArray) {
                return Accessible.this.accNavigate((int)lArray[0], lArray[1], lArray[2]);
            }

            public long method24(long[] lArray) {
                return Accessible.this.accHitTest((int)lArray[0], (int)lArray[1], lArray[2]);
            }

            public long method25(long[] lArray) {
                return Accessible.this.accDoDefaultAction(lArray[0]);
            }

            public long method26(long[] lArray) {
                return Accessible.this.put_accName(lArray[0], lArray[1]);
            }

            public long method27(long[] lArray) {
                return Accessible.this.put_accValue(lArray[0], lArray[1]);
            }
        };
        long l = this.objIAccessible.ppVtable;
        long[] lArray2 = new long[1];
        COM.MoveMemory(lArray2, l, OS.PTR_SIZEOF);
        long[] lArray3 = new long[28];
        COM.MoveMemory(lArray3, lArray2[0], OS.PTR_SIZEOF * lArray3.length);
        lArray3[9] = COM.get_accChild_CALLBACK(lArray3[9]);
        lArray3[10] = COM.get_accName_CALLBACK(lArray3[10]);
        lArray3[11] = COM.get_accValue_CALLBACK(lArray3[11]);
        lArray3[12] = COM.get_accDescription_CALLBACK(lArray3[12]);
        lArray3[13] = COM.get_accRole_CALLBACK(lArray3[13]);
        lArray3[14] = COM.get_accState_CALLBACK(lArray3[14]);
        lArray3[15] = COM.get_accHelp_CALLBACK(lArray3[15]);
        lArray3[16] = COM.get_accHelpTopic_CALLBACK(lArray3[16]);
        lArray3[17] = COM.get_accKeyboardShortcut_CALLBACK(lArray3[17]);
        lArray3[20] = COM.get_accDefaultAction_CALLBACK(lArray3[20]);
        lArray3[21] = COM.accSelect_CALLBACK(lArray3[21]);
        lArray3[22] = COM.accLocation_CALLBACK(lArray3[22]);
        lArray3[23] = COM.accNavigate_CALLBACK(lArray3[23]);
        lArray3[25] = COM.accDoDefaultAction_CALLBACK(lArray3[25]);
        lArray3[26] = COM.put_accName_CALLBACK(lArray3[26]);
        lArray3[27] = COM.put_accValue_CALLBACK(lArray3[27]);
        COM.MoveMemory(lArray2[0], lArray3, OS.PTR_SIZEOF * lArray3.length);
        int[] nArray2 = new int[7];
        nArray2[0] = 2;
        nArray2[3] = 3;
        nArray2[4] = 1;
        nArray2[6] = 1;
        this.objIEnumVARIANT = new COMObject(nArray2){

            public long method0(long[] lArray) {
                return Accessible.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return Accessible.this.AddRef();
            }

            public long method2(long[] lArray) {
                return Accessible.this.Release();
            }

            public long method3(long[] lArray) {
                return Accessible.this.Next((int)lArray[0], lArray[1], lArray[2]);
            }

            public long method4(long[] lArray) {
                return Accessible.this.Skip((int)lArray[0]);
            }

            public long method5(long[] lArray) {
                return Accessible.this.Reset();
            }

            public long method6(long[] lArray) {
                return Accessible.this.Clone(lArray[0]);
            }
        };
        this.AddRef();
    }

    public static Accessible internal_new_Accessible(Control control2) {
        return new Accessible(control2);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.addElement(accessibleTextListener);
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.iaccessible != null) {
            this.iaccessible.Release();
        }
        this.iaccessible = null;
        this.Release();
    }

    public long internal_WM_GETOBJECT(long l, long l2) {
        if (this.objIAccessible == null) {
            return 0L;
        }
        if ((int)l2 == -4) {
            return COM.LresultFromObject(COM.IIDIAccessible, l, this.objIAccessible.getAddress());
        }
        return 0L;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.removeElement(accessibleTextListener);
    }

    public void selectionChanged() {
        this.checkWidget();
        COM.NotifyWinEvent(32777, this.control.handle, -4, 0);
    }

    public void setFocus(int n) {
        this.checkWidget();
        COM.NotifyWinEvent(32773, this.control.handle, -4, this.childIDToOs(n));
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        COM.NotifyWinEvent(32779, this.control.handle, -8, 0);
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        COM.NotifyWinEvent(32782, this.control.handle, -4, 0);
    }

    public void textSelectionChanged() {
        this.checkWidget();
    }

    int QueryInterface(long l, long l2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, l, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(l2, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDispatch)) {
            COM.MoveMemory(l2, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible)) {
            COM.MoveMemory(l2, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIEnumVARIANT)) {
            COM.MoveMemory(l2, new long[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            this.enumIndex = 0;
            return 0;
        }
        long[] lArray = new long[1];
        int n = this.iaccessible.QueryInterface(gUID, lArray);
        COM.MoveMemory(l2, lArray, OS.PTR_SIZEOF);
        return n;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessible != null) {
                this.objIAccessible.dispose();
            }
            this.objIAccessible = null;
            if (this.objIEnumVARIANT != null) {
                this.objIEnumVARIANT.dispose();
            }
            this.objIEnumVARIANT = null;
        }
        return this.refCount;
    }

    int accDoDefaultAction(long l) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = this.iaccessible.accDoDefaultAction(l);
        if (n == -2147024809) {
            n = 1;
        }
        return n;
    }

    int accHitTest(int n, int n2, long l) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return this.iaccessible.accHitTest(n, n2, l);
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -2;
        accessibleControlEvent.x = n;
        accessibleControlEvent.y = n2;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
            ++n3;
        }
        n3 = accessibleControlEvent.childID;
        if (n3 == -2) {
            return this.iaccessible.accHitTest(n, n2, l);
        }
        COM.MoveMemory(l, new short[]{3}, 2);
        COM.MoveMemory(l + 8L, new int[]{this.childIDToOs(n3)}, 4);
        return 0;
    }

    int accLocation(long l, long l2, long l3, long l4, long l5) {
        Object object;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l5, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.iaccessible.accLocation(l, l2, l3, l4, l5);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return n5;
        }
        if (n5 == 0) {
            object2 = new int[1];
            int[] nArray = new int[1];
            object = new int[1];
            int[] nArray2 = new int[1];
            COM.MoveMemory(object2, l, 4);
            COM.MoveMemory(nArray, l2, 4);
            COM.MoveMemory((int[])object, l3, 4);
            COM.MoveMemory(nArray2, l4, 4);
            n = object2[0];
            n2 = nArray[0];
            n3 = object[0];
            n4 = nArray2[0];
        }
        object2 = new AccessibleControlEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.x = n;
        object2.y = n2;
        object2.width = n3;
        object2.height = n4;
        int n6 = 0;
        while (n6 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
            object.getLocation((AccessibleControlEvent)object2);
            ++n6;
        }
        OS.MoveMemory(l, new int[]{object2.x}, 4);
        OS.MoveMemory(l2, new int[]{object2.y}, 4);
        OS.MoveMemory(l3, new int[]{object2.width}, 4);
        OS.MoveMemory(l4, new int[]{object2.height}, 4);
        return 0;
    }

    int accNavigate(int n, long l, long l2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n2 = this.iaccessible.accNavigate(n, l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        return n2;
    }

    int accSelect(int n, long l) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n2 = this.iaccessible.accSelect(n, l);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        return n2;
    }

    int get_accChild(long l, long l2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        if (this.accessibleControlListeners.size() == 0) {
            int n = this.iaccessible.get_accChild(l, l2);
            if (n == -2147024809) {
                n = 1;
            }
            return n;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.osToChildID(vARIANT.lVal);
        int n = 0;
        while (n < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n);
            accessibleControlListener.getChild(accessibleControlEvent);
            ++n;
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            COM.MoveMemory(l2, new long[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        return 1;
    }

    int get_accChildCount(long l) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = 0;
        int n2 = this.iaccessible.get_accChildCount(l);
        if (this.accessibleControlListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object = new int[1];
            COM.MoveMemory(object, l, 4);
            n = object[0];
        }
        object = new AccessibleControlEvent(this);
        object.childID = -1;
        object.detail = n;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getChildCount((AccessibleControlEvent)object);
            ++n3;
        }
        COM.MoveMemory(l, new int[]{object.detail}, 4);
        return 0;
    }

    int get_accDefaultAction(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n2 = this.iaccessible.get_accDefaultAction(l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object2 = new long[1];
            COM.MoveMemory(object2, l2, OS.PTR_SIZEOF);
            n = COM.SysStringByteLen(object2[0]);
            if (n > 0) {
                object = new char[(n + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleControlEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n = 0;
        while (n < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n);
            object.getDefaultAction((AccessibleControlEvent)object2);
            ++n;
        }
        if (object2.result == null) {
            return n2;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        long l3 = COM.SysAllocString(cArray);
        COM.MoveMemory(l2, new long[]{l3}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accDescription(long l, long l2) {
        Tree tree;
        int n;
        Object object;
        int n2;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n3 = this.iaccessible.get_accDescription(l, l2);
        if (n3 == -2147024809) {
            n3 = 1;
        }
        if (this.accessibleListeners.size() == 0 && !(this.control instanceof Tree)) {
            return n3;
        }
        if (n3 == 0) {
            object2 = new long[1];
            COM.MoveMemory(object2, l2, OS.PTR_SIZEOF);
            n2 = COM.SysStringByteLen(object2[0]);
            if (n2 > 0) {
                object = new char[(n2 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n2);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        if (vARIANT.lVal != 0 && this.control instanceof Tree && (n = (tree = (Tree)this.control).getColumnCount()) > 1) {
            long l3 = this.control.handle;
            long l4 = 0L;
            l4 = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(l3, 4394, (long)vARIANT.lVal, 0L) : (long)vARIANT.lVal;
            Widget widget = tree.getDisplay().findWidget(l3, l4);
            object2.result = "";
            if (widget != null && widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                int n4 = 1;
                while (n4 < n) {
                    object2.result = String.valueOf(object2.result) + tree.getColumn(n4).getText() + ": " + treeItem.getText(n4);
                    if (n4 + 1 < n) {
                        object2.result = String.valueOf(object2.result) + ", ";
                    }
                    ++n4;
                }
            }
        }
        n2 = 0;
        while (n2 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n2);
            object.getDescription((AccessibleEvent)object2);
            ++n2;
        }
        if (object2.result == null) {
            return n3;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        long l5 = COM.SysAllocString(cArray);
        COM.MoveMemory(l2, new long[]{l5}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accFocus(long l) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = -2;
        int n2 = this.iaccessible.get_accFocus(l);
        if (this.accessibleControlListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object = new short[1];
            COM.MoveMemory(object, l, 2);
            if (object[0] == 3) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, l + 8L, 4);
                n = this.osToChildID(nArray[0]);
            }
        }
        object = new AccessibleControlEvent(this);
        object.childID = n;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getFocus((AccessibleControlEvent)object);
            ++n3;
        }
        Accessible accessible = object.accessible;
        if (accessible != null) {
            accessible.AddRef();
            COM.MoveMemory(l, new short[]{9}, 2);
            COM.MoveMemory(l + 8L, new long[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        int n4 = object.childID;
        if (n4 == -2) {
            COM.MoveMemory(l, new short[1], 2);
            return 1;
        }
        if (n4 == -1) {
            this.AddRef();
            COM.MoveMemory(l, new short[]{9}, 2);
            COM.MoveMemory(l + 8L, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        COM.MoveMemory(l, new short[]{3}, 2);
        COM.MoveMemory(l + 8L, new int[]{this.childIDToOs(n4)}, 4);
        return 0;
    }

    int get_accHelp(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n2 = this.iaccessible.get_accHelp(l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object2 = new long[1];
            COM.MoveMemory(object2, l2, OS.PTR_SIZEOF);
            n = COM.SysStringByteLen(object2[0]);
            if (n > 0) {
                object = new char[(n + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n = 0;
        while (n < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n);
            object.getHelp((AccessibleEvent)object2);
            ++n;
        }
        if (object2.result == null) {
            return n2;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        long l3 = COM.SysAllocString(cArray);
        COM.MoveMemory(l2, new long[]{l3}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accHelpTopic(long l, long l2, long l3) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = this.iaccessible.get_accHelpTopic(l, l2, l3);
        if (n == -2147024809) {
            n = 1;
        }
        return n;
    }

    int get_accKeyboardShortcut(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n2 = this.iaccessible.get_accKeyboardShortcut(l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object2 = new long[1];
            COM.MoveMemory(object2, l2, OS.PTR_SIZEOF);
            n = COM.SysStringByteLen(object2[0]);
            if (n > 0) {
                object = new char[(n + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n = 0;
        while (n < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n);
            object.getKeyboardShortcut((AccessibleEvent)object2);
            ++n;
        }
        if (object2.result == null) {
            return n2;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        long l3 = COM.SysAllocString(cArray);
        COM.MoveMemory(l2, new long[]{l3}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accName(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n2 = this.iaccessible.get_accName(l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object2 = new long[1];
            COM.MoveMemory(object2, l2, OS.PTR_SIZEOF);
            n = COM.SysStringByteLen(object2[0]);
            if (n > 0) {
                object = new char[(n + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n = 0;
        while (n < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n);
            object.getName((AccessibleEvent)object2);
            ++n;
        }
        if (object2.result == null) {
            return n2;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        long l3 = COM.SysAllocString(cArray);
        COM.MoveMemory(l2, new long[]{l3}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accParent(long l) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        return this.iaccessible.get_accParent(l);
    }

    int get_accRole(long l, long l2) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int n = 10;
        int n2 = this.iaccessible.get_accRole(l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Tree) && !(this.control instanceof Table)) {
            return n2;
        }
        if (n2 == 0) {
            object = new short[1];
            COM.MoveMemory(object, l2, 2);
            if (object[0] == 3) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, l2 + 8L, 4);
                n = nArray[0];
            }
        }
        object = new AccessibleControlEvent(this);
        object.childID = this.osToChildID(vARIANT.lVal);
        object.detail = this.osToRole(n);
        if (vARIANT.lVal != 0 && (this.control instanceof Tree || this.control instanceof Table) && (this.control.getStyle() & 0x20) != 0) {
            object.detail = 44;
        }
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getRole((AccessibleControlEvent)object);
            ++n3;
        }
        n3 = this.roleToOs(object.detail);
        COM.MoveMemory(l2, new short[]{3}, 2);
        COM.MoveMemory(l2 + 8L, new int[]{n3}, 4);
        return 0;
    }

    int get_accSelection(long l) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = -2;
        int n2 = this.iaccessible.get_accSelection(l);
        if (this.accessibleControlListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object = new short[1];
            COM.MoveMemory(object, l, 2);
            if (object[0] == 3) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, l + 8L, 4);
                n = this.osToChildID(nArray[0]);
            } else if (object[0] == 13) {
                n = -3;
            }
        }
        object = new AccessibleControlEvent(this);
        object.childID = n;
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getSelection((AccessibleControlEvent)object);
            ++n3;
        }
        Accessible accessible = object.accessible;
        if (accessible != null) {
            accessible.AddRef();
            COM.MoveMemory(l, new short[]{9}, 2);
            COM.MoveMemory(l + 8L, new long[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        int n4 = object.childID;
        if (n4 == -2) {
            COM.MoveMemory(l, new short[1], 2);
            return 1;
        }
        if (n4 == -3) {
            this.AddRef();
            COM.MoveMemory(l, new short[]{13}, 2);
            COM.MoveMemory(l + 8L, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        if (n4 == -1) {
            this.AddRef();
            COM.MoveMemory(l, new short[]{9}, 2);
            COM.MoveMemory(l + 8L, new long[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        COM.MoveMemory(l, new short[]{3}, 2);
        COM.MoveMemory(l + 8L, new int[]{this.childIDToOs(n4)}, 4);
        return 0;
    }

    int get_accState(long l, long l2) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        Object object2 = 0;
        int n = this.iaccessible.get_accState(l, l2);
        if (n == -2147024809) {
            n = 1;
        }
        if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Tree) && !(this.control instanceof Table)) {
            return n;
        }
        if (n == 0) {
            short[] sArray = new short[1];
            COM.MoveMemory(sArray, l2, 2);
            if (sArray[0] == 3) {
                object = new int[1];
                COM.MoveMemory((int[])object, l2 + 8L, 4);
                object2 = object[0];
            }
        }
        boolean bl = false;
        object = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object).detail = this.osToState((int)object2);
        if (vARIANT.lVal != 0) {
            Object object3;
            if (this.control instanceof Tree && (this.control.getStyle() & 0x20) != 0) {
                boolean bl2;
                long l3 = this.control.handle;
                object3 = new TVITEM();
                ((TVITEM)object3).mask = 24;
                ((TVITEM)object3).stateMask = 61440;
                ((TVITEM)object3).hItem = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(l3, 4394, (long)vARIANT.lVal, 0L) : (long)vARIANT.lVal;
                long l4 = OS.SendMessage(l3, OS.TVM_GETITEM, 0L, (TVITEM)object3);
                boolean bl3 = bl2 = l4 != 0L && (((TVITEM)object3).state >> 12 & 1) == 0;
                if (bl2) {
                    ((AccessibleControlEvent)object).detail |= 0x10;
                }
                bl = ((TVITEM)object3).state >> 12 > 2;
            } else if (this.control instanceof Table && (this.control.getStyle() & 0x20) != 0) {
                Table table = (Table)this.control;
                int n2 = ((AccessibleControlEvent)object).childID;
                if (n2 >= 0 && n2 < table.getItemCount()) {
                    object3 = table.getItem(n2);
                    if (((TableItem)object3).getChecked()) {
                        ((AccessibleControlEvent)object).detail |= 0x10;
                    }
                    if (((TableItem)object3).getGrayed()) {
                        bl = true;
                    }
                }
            }
        }
        int n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            accessibleControlListener.getState((AccessibleControlEvent)object);
            ++n3;
        }
        n3 = this.stateToOs(((AccessibleControlEvent)object).detail);
        if ((n3 & 0x10) != 0 && bl) {
            n3 &= 0xFFFFFFEF;
            n3 |= 0x20;
        }
        COM.MoveMemory(l2, new short[]{3}, 2);
        COM.MoveMemory(l2 + 8L, new int[]{n3}, 4);
        return 0;
    }

    int get_accValue(long l, long l2) {
        Object object;
        int n;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, l, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n2 = this.iaccessible.get_accValue(l, l2);
        if (n2 == -2147024809) {
            n2 = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return n2;
        }
        if (n2 == 0) {
            object2 = new long[1];
            COM.MoveMemory(object2, l2, OS.PTR_SIZEOF);
            n = COM.SysStringByteLen(object2[0]);
            if (n > 0) {
                object = new char[(n + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleControlEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n = 0;
        while (n < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n);
            object.getValue((AccessibleControlEvent)object2);
            ++n;
        }
        if (object2.result == null) {
            return n2;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        long l3 = COM.SysAllocString(cArray);
        COM.MoveMemory(l2, new long[]{l3}, OS.PTR_SIZEOF);
        return 0;
    }

    int put_accName(long l, long l2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = this.iaccessible.put_accName(l, l2);
        if (n == -2147024809) {
            n = 1;
        }
        return n;
    }

    int put_accValue(long l, long l2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n = this.iaccessible.put_accValue(l, l2);
        if (n == -2147024809) {
            n = 1;
        }
        return n;
    }

    int Next(int n, long l, long l2) {
        int n2;
        Object object;
        if (this.accessibleControlListeners.size() == 0) {
            long[] lArray = new long[1];
            int n3 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n3 != 0) {
                return n3;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            int[] nArray = new int[1];
            n3 = iEnumVARIANT.Next(n, l, nArray);
            iEnumVARIANT.Release();
            COM.MoveMemory(l2, nArray, 4);
            return n3;
        }
        if (l == 0L) {
            return -2147024809;
        }
        if (l2 == 0L && n != 1) {
            return -2147024809;
        }
        if (this.enumIndex == 0) {
            object = new AccessibleControlEvent(this);
            object.childID = -1;
            n2 = 0;
            while (n2 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                accessibleControlListener.getChildren((AccessibleControlEvent)object);
                ++n2;
            }
            this.variants = object.children;
        }
        object = null;
        if (this.variants != null && n >= 1) {
            n2 = this.enumIndex + n - 1;
            if (n2 > this.variants.length - 1) {
                n2 = this.variants.length - 1;
            }
            if (this.enumIndex <= n2) {
                object = new Object[n2 - this.enumIndex + 1];
                int n4 = 0;
                while (n4 < ((Object[])object).length) {
                    Object object2 = this.variants[this.enumIndex];
                    object[n4] = object2 instanceof Integer ? new Integer(this.childIDToOs((Integer)object2)) : object2;
                    ++this.enumIndex;
                    ++n4;
                }
            }
        }
        if (object != null) {
            n2 = 0;
            while (n2 < ((Object[])object).length) {
                Object object3 = object[n2];
                if (object3 instanceof Integer) {
                    int n5 = (Integer)object3;
                    COM.MoveMemory(l + (long)(n2 * VARIANT.sizeof), new short[]{3}, 2);
                    COM.MoveMemory(l + (long)(n2 * VARIANT.sizeof) + 8L, new int[]{n5}, 4);
                } else {
                    Accessible accessible = (Accessible)object3;
                    accessible.AddRef();
                    COM.MoveMemory(l + (long)(n2 * VARIANT.sizeof), new short[]{9}, 2);
                    COM.MoveMemory(l + (long)(n2 * VARIANT.sizeof) + 8L, new long[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
                }
                ++n2;
            }
            if (l2 != 0L) {
                COM.MoveMemory(l2, new int[]{((Object[])object).length}, 4);
            }
            if (((Object[])object).length == n) {
                return 0;
            }
        } else if (l2 != 0L) {
            COM.MoveMemory(l2, new int[1], 4);
        }
        return 1;
    }

    int Skip(int n) {
        if (this.accessibleControlListeners.size() == 0) {
            long[] lArray = new long[1];
            int n2 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n2 != 0) {
                return n2;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            n2 = iEnumVARIANT.Skip(n);
            iEnumVARIANT.Release();
            return n2;
        }
        if (n < 1) {
            return -2147024809;
        }
        this.enumIndex += n;
        if (this.enumIndex > this.variants.length - 1) {
            this.enumIndex = this.variants.length - 1;
            return 1;
        }
        return 0;
    }

    int Reset() {
        if (this.accessibleControlListeners.size() == 0) {
            long[] lArray = new long[1];
            int n = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n != 0) {
                return n;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            n = iEnumVARIANT.Reset();
            iEnumVARIANT.Release();
            return n;
        }
        this.enumIndex = 0;
        return 0;
    }

    int Clone(long l) {
        if (this.accessibleControlListeners.size() == 0) {
            long[] lArray = new long[1];
            int n = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, lArray);
            if (n != 0) {
                return n;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(lArray[0]);
            long[] lArray2 = new long[1];
            n = iEnumVARIANT.Clone(lArray2);
            iEnumVARIANT.Release();
            COM.MoveMemory(l, lArray2, OS.PTR_SIZEOF);
            return n;
        }
        if (l == 0L) {
            return -2147024809;
        }
        COM.MoveMemory(l, new long[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int childIDToOs(int n) {
        if (n == -1) {
            return 0;
        }
        if (!(this.control instanceof Tree)) {
            return n + 1;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            return n;
        }
        return (int)OS.SendMessage(this.control.handle, 4395, (long)n, 0L);
    }

    int osToChildID(int n) {
        if (n == 0) {
            return -1;
        }
        if (!(this.control instanceof Tree)) {
            return n - 1;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            return n;
        }
        return (int)OS.SendMessage(this.control.handle, 4394, (long)n, 0L);
    }

    int stateToOs(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200000) != 0) {
            n2 |= 0x200000;
        }
        if ((n & 0x1000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x400000) != 0) {
            n2 |= 0x400000;
        }
        return n2;
    }

    int osToState(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200000) != 0) {
            n2 |= 0x200000;
        }
        if ((n & 0x1000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x400000) != 0) {
            n2 |= 0x400000;
        }
        return n2;
    }

    int roleToOs(int n) {
        switch (n) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
        }
        return 10;
    }

    int osToRole(int n) {
        switch (n) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
        }
        return 10;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

