/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CLayoutData;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

class ViewFormLayout
extends Layout {
    ViewFormLayout() {
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        ViewForm viewForm = (ViewForm)composite;
        Control control2 = viewForm.topLeft;
        Control control3 = viewForm.topCenter;
        Control control4 = viewForm.topRight;
        Control control5 = viewForm.content;
        Point point = new Point(0, 0);
        if (control2 != null) {
            point = this.computeChildSize(control2, -1, -1, bl);
        }
        Point point2 = new Point(0, 0);
        if (control3 != null) {
            point2 = this.computeChildSize(control3, -1, -1, bl);
        }
        Point point3 = new Point(0, 0);
        if (control4 != null) {
            point3 = this.computeChildSize(control4, -1, -1, bl);
        }
        Point point4 = new Point(0, 0);
        if (viewForm.separateTopCenter || n != -1 && point.x + point2.x + point3.x > n) {
            point4.x = point.x + point3.x;
            if (point.x > 0 && point3.x > 0) {
                point4.x += viewForm.horizontalSpacing;
            }
            point4.x = Math.max(point2.x, point4.x);
            point4.y = Math.max(point.y, point3.y);
            if (control3 != null) {
                point4.y += point2.y;
                if (control2 != null || control4 != null) {
                    point4.y += viewForm.verticalSpacing;
                }
            }
        } else {
            point4.x = point.x + point2.x + point3.x;
            int n3 = -1;
            if (point.x > 0) {
                ++n3;
            }
            if (point2.x > 0) {
                ++n3;
            }
            if (point3.x > 0) {
                ++n3;
            }
            if (n3 > 0) {
                point4.x += n3 * viewForm.horizontalSpacing;
            }
            point4.y = Math.max(point.y, Math.max(point2.y, point3.y));
        }
        if (control5 != null) {
            if (control2 != null || control4 != null || control3 != null) {
                ++point4.y;
            }
            Point point5 = new Point(0, 0);
            point5 = this.computeChildSize(control5, -1, -1, bl);
            point4.x = Math.max(point4.x, point5.x);
            point4.y += point5.y;
            if (point4.y > point5.y) {
                point4.y += viewForm.verticalSpacing;
            }
        }
        point4.x += 2 * viewForm.marginWidth;
        point4.y += 2 * viewForm.marginHeight;
        if (n != -1) {
            point4.x = n;
        }
        if (n2 != -1) {
            point4.y = n2;
        }
        return point4;
    }

    Point computeChildSize(Control control2, int n, int n2, boolean bl) {
        Object object = control2.getLayoutData();
        if (object == null || !(object instanceof CLayoutData)) {
            object = new CLayoutData();
            control2.setLayoutData(object);
        }
        return ((CLayoutData)object).computeSize(control2, n, n2, bl);
    }

    int computeTrim(Control control2) {
        if (control2 instanceof Scrollable) {
            Rectangle rectangle = ((Scrollable)control2).computeTrim(0, 0, 0, 0);
            return rectangle.width;
        }
        return control2.getBorderWidth() * 2;
    }

    protected boolean flushCache(Control control2) {
        Object object = control2.getLayoutData();
        if (object != null && object instanceof CLayoutData) {
            ((CLayoutData)object).flushCache();
        }
        return true;
    }

    protected void layout(Composite composite, boolean bl) {
        int n;
        int n2;
        ViewForm viewForm = (ViewForm)composite;
        Control control2 = viewForm.topLeft;
        Control control3 = viewForm.topCenter;
        Control control4 = viewForm.topRight;
        Control control5 = viewForm.content;
        Rectangle rectangle = composite.getClientArea();
        Point point = new Point(0, 0);
        if (control2 != null && !control2.isDisposed()) {
            point = this.computeChildSize(control2, -1, -1, bl);
        }
        Point point2 = new Point(0, 0);
        if (control3 != null && !control3.isDisposed()) {
            point2 = this.computeChildSize(control3, -1, -1, bl);
        }
        Point point3 = new Point(0, 0);
        if (control4 != null && !control4.isDisposed()) {
            point3 = this.computeChildSize(control4, -1, -1, bl);
        }
        int n3 = point.x + point2.x + point3.x + 2 * viewForm.marginWidth + 2 * viewForm.highlight;
        int n4 = -1;
        if (point.x > 0) {
            ++n4;
        }
        if (point2.x > 0) {
            ++n4;
        }
        if (point3.x > 0) {
            ++n4;
        }
        if (n4 > 0) {
            n3 += n4 * viewForm.horizontalSpacing;
        }
        int n5 = rectangle.x + rectangle.width - viewForm.marginWidth - viewForm.highlight;
        int n6 = rectangle.y + viewForm.marginHeight + viewForm.highlight;
        boolean bl2 = false;
        if (viewForm.separateTopCenter || n3 > rectangle.width) {
            int n7;
            n2 = Math.max(point3.y, point.y);
            if (control4 != null && !control4.isDisposed()) {
                bl2 = true;
                control4.setBounds(n5 -= point3.x, n6, point3.x, n2);
                n5 -= viewForm.horizontalSpacing;
            }
            if (control2 != null && !control2.isDisposed()) {
                bl2 = true;
                n7 = this.computeTrim(control2);
                n = n5 - rectangle.x - viewForm.marginWidth - viewForm.highlight - n7;
                point = this.computeChildSize(control2, n, -1, false);
                control2.setBounds(rectangle.x + viewForm.marginWidth + viewForm.highlight, n6, point.x, n2);
            }
            if (bl2) {
                n6 += n2 + viewForm.verticalSpacing;
            }
            if (control3 != null && !control3.isDisposed()) {
                bl2 = true;
                n7 = this.computeTrim(control3);
                n = rectangle.width - 2 * viewForm.marginWidth - 2 * viewForm.highlight - n7;
                point2 = this.computeChildSize(control3, n, -1, false);
                control3.setBounds(rectangle.x + rectangle.width - viewForm.marginWidth - viewForm.highlight - point2.x, n6, point2.x, point2.y);
                n6 += point2.y + viewForm.verticalSpacing;
            }
        } else {
            n2 = Math.max(point3.y, Math.max(point2.y, point.y));
            if (control4 != null && !control4.isDisposed()) {
                bl2 = true;
                control4.setBounds(n5 -= point3.x, n6, point3.x, n2);
                n5 -= viewForm.horizontalSpacing;
            }
            if (control3 != null && !control3.isDisposed()) {
                bl2 = true;
                control3.setBounds(n5 -= point2.x, n6, point2.x, n2);
                n5 -= viewForm.horizontalSpacing;
            }
            if (control2 != null && !control2.isDisposed()) {
                bl2 = true;
                Rectangle rectangle2 = control2 instanceof Composite ? ((Composite)control2).computeTrim(0, 0, 0, 0) : new Rectangle(0, 0, 0, 0);
                n = n5 - rectangle.x - viewForm.marginWidth - viewForm.highlight - rectangle2.width;
                int n8 = n2 - rectangle2.height;
                point = this.computeChildSize(control2, n, n8, false);
                control2.setBounds(rectangle.x + viewForm.marginWidth + viewForm.highlight, n6, point.x, n2);
            }
            if (bl2) {
                n6 += n2 + viewForm.verticalSpacing;
            }
        }
        n2 = viewForm.separator;
        viewForm.separator = -1;
        if (control5 != null && !control5.isDisposed()) {
            if (control2 != null || control4 != null || control3 != null) {
                viewForm.separator = n6++;
            }
            control5.setBounds(rectangle.x + viewForm.marginWidth + viewForm.highlight, n6, rectangle.width - 2 * viewForm.marginWidth - 2 * viewForm.highlight, rectangle.y + rectangle.height - n6 - viewForm.marginHeight - viewForm.highlight);
        }
        if (n2 != -1 && viewForm.separator != -1) {
            int n9 = Math.min(viewForm.separator, n2);
            n = Math.max(viewForm.separator, n2);
            viewForm.redraw(viewForm.borderLeft, n9, viewForm.getSize().x - viewForm.borderLeft - viewForm.borderRight, n - n9, false);
        }
    }
}

