/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.EMR;
import org.eclipse.swt.internal.win32.EMREXTCREATEFONTINDIRECTW;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRIC;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICA;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICW;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_DIGITSUBSTITUTE;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing = 0;
    int ascent = -1;
    int descent = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    long mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.text = "";
        long[] lArray = new long[1];
        OS.OleInitialize(0L);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0L, 1, IID_IMLangFontLink2, lArray) == 0) {
            this.mLangFontLink2 = lArray[0];
        }
        this.init();
    }

    void breakRun(StyleItem styleItem) {
        if (styleItem.psla != 0L) {
            return;
        }
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        long l = OS.GetProcessHeap();
        styleItem.psla = OS.HeapAlloc(l, 8, SCRIPT_LOGATTR.sizeof * cArray.length);
        if (styleItem.psla == 0L) {
            SWT.error(2);
        }
        OS.ScriptBreak(cArray, cArray.length, styleItem.analysis, styleItem.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        if (this.runs != null) {
            return;
        }
        long l = gC != null ? gC.handle : this.device.internal_new_GC(null);
        long l2 = OS.CreateCompatibleDC(l);
        this.allRuns = this.itemize();
        int n5 = 0;
        while (n5 < this.allRuns.length - 1) {
            object = this.allRuns[n5];
            OS.SelectObject(l2, this.getItemFont((StyleItem)object));
            this.shape(l2, (StyleItem)object);
            ++n5;
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n6 = this.indent;
        int n7 = 0;
        int n8 = 1;
        int n9 = 0;
        while (n9 < this.allRuns.length - 1) {
            int n10;
            StyleItem styleItem = this.allRuns[n9];
            if (styleItem.length == 1) {
                n4 = this.segmentsText.charAt(styleItem.start);
                switch (n4) {
                    case 9: {
                        styleItem.tab = true;
                        if (this.tabs == null) break;
                        n3 = this.tabs.length;
                        int n11 = 0;
                        while (n11 < n3) {
                            if (this.tabs[n11] > n6) {
                                styleItem.width = this.tabs[n11] - n6;
                                break;
                            }
                            ++n11;
                        }
                        if (n11 != n3) break;
                        n2 = this.tabs[n3 - 1];
                        int n12 = n10 = n3 > 1 ? this.tabs[n3 - 1] - this.tabs[n3 - 2] : this.tabs[0];
                        if (n10 <= 0) break;
                        while (n2 <= n6) {
                            n2 += n10;
                        }
                        styleItem.width = n2 - n6;
                        break;
                    }
                    case 10: {
                        styleItem.lineBreak = true;
                        break;
                    }
                    case 13: {
                        styleItem.lineBreak = true;
                        StyleItem styleItem2 = this.allRuns[n9 + 1];
                        if (styleItem2.length == 0 || this.segmentsText.charAt(styleItem2.start) != '\n') break;
                        ++styleItem.length;
                        styleItem2.free();
                        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length - 1];
                        System.arraycopy(this.allRuns, 0, styleItemArray, 0, n9 + 1);
                        System.arraycopy(this.allRuns, n9 + 2, styleItemArray, n9 + 1, this.allRuns.length - n9 - 2);
                        this.allRuns = styleItemArray;
                    }
                }
            }
            if (this.wrapWidth != -1 && n6 + styleItem.width > this.wrapWidth && !styleItem.tab) {
                StyleItem[] styleItemArray;
                n4 = 0;
                int[] nArray = new int[styleItem.length];
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    nArray[0] = styleItem.width;
                } else {
                    OS.ScriptGetLogicalWidths(styleItem.analysis, styleItem.length, styleItem.glyphCount, styleItem.advances, styleItem.clusters, styleItem.visAttrs, nArray);
                }
                int n13 = 0;
                n2 = this.wrapWidth - n6;
                while (n13 + nArray[n4] < n2) {
                    n13 += nArray[n4++];
                }
                n10 = n4;
                int n14 = n9;
                while (n9 >= n7) {
                    this.breakRun(styleItem);
                    while (n4 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)(n4 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n4;
                    }
                    if (n4 == 0 && n9 != n7 && !styleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        n = ((SCRIPT_PROPERTIES)object).langid;
                        styleItemArray = this.allRuns[n9 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItemArray.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (((SCRIPT_PROPERTIES)object).langid == n || n == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun((StyleItem)styleItemArray);
                            OS.MoveMemory(sCRIPT_LOGATTR, styleItemArray.psla + (long)((styleItemArray.length - 1) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n4 = -1;
                            }
                        }
                    }
                    if (n4 >= 0 || n9 == n7) break;
                    styleItem = this.allRuns[--n9];
                    n4 = styleItem.length - 1;
                }
                if (n4 == 0 && n9 != n7 && !styleItem.tab) {
                    styleItem = this.allRuns[--n9];
                } else if (n4 <= 0 && n9 == n7) {
                    if (n6 == this.wrapWidth && n14 > 0) {
                        n9 = n14 - 1;
                        styleItem = this.allRuns[n9];
                        n4 = styleItem.length;
                    } else {
                        n9 = n14;
                        styleItem = this.allRuns[n9];
                        n4 = Math.max(1, n10);
                    }
                }
                this.breakRun(styleItem);
                while (n4 < styleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)(n4 * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n4;
                }
                if (n4 > 0 && n4 < styleItem.length) {
                    StyleItem styleItem3 = new StyleItem();
                    styleItem3.start = styleItem.start + n4;
                    styleItem3.length = styleItem.length - n4;
                    styleItem3.style = styleItem.style;
                    styleItem3.analysis = this.cloneScriptAnalysis(styleItem.analysis);
                    styleItem.free();
                    styleItem.length = n4;
                    OS.SelectObject(l2, this.getItemFont(styleItem));
                    styleItem.analysis.fNoGlyphIndex = false;
                    this.shape(l2, styleItem);
                    OS.SelectObject(l2, this.getItemFont(styleItem3));
                    styleItem3.analysis.fNoGlyphIndex = false;
                    this.shape(l2, styleItem3);
                    styleItemArray = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, styleItemArray, 0, n9 + 1);
                    System.arraycopy(this.allRuns, n9 + 1, styleItemArray, n9 + 2, this.allRuns.length - n9 - 1);
                    this.allRuns = styleItemArray;
                    this.allRuns[n9 + 1] = styleItem3;
                }
                if (n9 != this.allRuns.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n6 += styleItem.width;
            if (styleItem.lineBreak) {
                n7 = n9 + 1;
                n6 = styleItem.softBreak ? 0 : this.indent;
                ++n8;
            }
            ++n9;
        }
        n6 = 0;
        this.runs = new StyleItem[n8][];
        this.lineOffset = new int[n8 + 1];
        this.lineY = new int[n8 + 1];
        this.lineWidth = new int[n8];
        n9 = 0;
        int n15 = 0;
        n4 = Math.max(0, this.ascent);
        n3 = Math.max(0, this.descent);
        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length];
        n2 = 0;
        while (n2 < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n2];
            styleItemArray[n9++] = styleItem;
            n6 += styleItem.width;
            n4 = Math.max(n4, styleItem.ascent);
            n3 = Math.max(n3, styleItem.descent);
            if (styleItem.lineBreak || n2 == this.allRuns.length - 1) {
                if (n9 == 1 && n2 == this.allRuns.length - 1) {
                    TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(l2, this.getItemFont(styleItem));
                    OS.GetTextMetrics(l2, tEXTMETRIC);
                    styleItem.ascent = tEXTMETRIC.tmAscent;
                    styleItem.descent = tEXTMETRIC.tmDescent;
                    n4 = Math.max(n4, styleItem.ascent);
                    n3 = Math.max(n3, styleItem.descent);
                }
                this.runs[n15] = new StyleItem[n9];
                System.arraycopy(styleItemArray, 0, this.runs[n15], 0, n9);
                if (this.justify && this.wrapWidth != -1 && styleItem.softBreak && n6 > 0) {
                    if (n15 == 0) {
                        n6 += this.indent;
                    } else {
                        StyleItem[] styleItemArray2 = this.runs[n15 - 1];
                        StyleItem styleItem4 = styleItemArray2[styleItemArray2.length - 1];
                        if (styleItem4.lineBreak && !styleItem4.softBreak) {
                            n6 += this.indent;
                        }
                    }
                    long l3 = OS.GetProcessHeap();
                    int n16 = 0;
                    int n17 = 0;
                    while (n17 < this.runs[n15].length) {
                        StyleItem styleItem5 = this.runs[n15][n17];
                        int n18 = styleItem5.width * this.wrapWidth / n6;
                        if (n18 != styleItem5.width) {
                            styleItem5.justify = OS.HeapAlloc(l3, 8, styleItem5.glyphCount * 4);
                            if (styleItem5.justify == 0L) {
                                SWT.error(2);
                            }
                            OS.ScriptJustify(styleItem5.visAttrs, styleItem5.advances, styleItem5.glyphCount, n18 - styleItem5.width, 2, styleItem5.justify);
                            styleItem5.width = n18;
                        }
                        n16 += styleItem5.width;
                        ++n17;
                    }
                    n6 = n16;
                }
                this.lineWidth[n15] = n6;
                StyleItem styleItem6 = this.runs[n15][n9 - 1];
                n = styleItem6.start + styleItem6.length;
                this.runs[n15] = this.reorder(this.runs[n15], n2 == this.allRuns.length - 1);
                styleItem6 = this.runs[n15][n9 - 1];
                if (styleItem.softBreak && styleItem != styleItem6) {
                    styleItem.lineBreak = false;
                    styleItem.softBreak = false;
                    styleItem6.lineBreak = true;
                    styleItem6.softBreak = true;
                }
                n6 = this.getLineIndent(n15);
                int n19 = 0;
                while (n19 < this.runs[n15].length) {
                    this.runs[n15][n19].x = n6;
                    n6 += this.runs[n15][n19].width;
                    ++n19;
                }
                this.lineY[++n15] = this.lineY[n15 - 1] + n4 + n3 + this.lineSpacing;
                this.lineOffset[n15] = n;
                n6 = 0;
                n9 = 0;
                n4 = Math.max(0, this.ascent);
                n3 = Math.max(0, this.descent);
            }
            ++n2;
        }
        if (l2 != 0L) {
            OS.DeleteDC(l2);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(l, null);
        }
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.mLangFontLink2 != 0L) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0L;
        }
        OS.OleUninitialize();
    }

    SCRIPT_ANALYSIS cloneScriptAnalysis(SCRIPT_ANALYSIS sCRIPT_ANALYSIS) {
        SCRIPT_ANALYSIS sCRIPT_ANALYSIS2 = new SCRIPT_ANALYSIS();
        sCRIPT_ANALYSIS2.eScript = sCRIPT_ANALYSIS.eScript;
        sCRIPT_ANALYSIS2.fRTL = sCRIPT_ANALYSIS.fRTL;
        sCRIPT_ANALYSIS2.fLayoutRTL = sCRIPT_ANALYSIS.fLayoutRTL;
        sCRIPT_ANALYSIS2.fLinkBefore = sCRIPT_ANALYSIS.fLinkBefore;
        sCRIPT_ANALYSIS2.fLinkAfter = sCRIPT_ANALYSIS.fLinkAfter;
        sCRIPT_ANALYSIS2.fLogicalOrder = sCRIPT_ANALYSIS.fLogicalOrder;
        sCRIPT_ANALYSIS2.fNoGlyphIndex = sCRIPT_ANALYSIS.fNoGlyphIndex;
        sCRIPT_ANALYSIS2.s = new SCRIPT_STATE();
        sCRIPT_ANALYSIS2.s.uBidiLevel = sCRIPT_ANALYSIS.s.uBidiLevel;
        sCRIPT_ANALYSIS2.s.fOverrideDirection = sCRIPT_ANALYSIS.s.fOverrideDirection;
        sCRIPT_ANALYSIS2.s.fInhibitSymSwap = sCRIPT_ANALYSIS.s.fInhibitSymSwap;
        sCRIPT_ANALYSIS2.s.fCharShape = sCRIPT_ANALYSIS.s.fCharShape;
        sCRIPT_ANALYSIS2.s.fDigitSubstitute = sCRIPT_ANALYSIS.s.fDigitSubstitute;
        sCRIPT_ANALYSIS2.s.fInhibitLigate = sCRIPT_ANALYSIS.s.fInhibitLigate;
        sCRIPT_ANALYSIS2.s.fDisplayZWG = sCRIPT_ANALYSIS.s.fDisplayZWG;
        sCRIPT_ANALYSIS2.s.fArabicNumContext = sCRIPT_ANALYSIS.s.fArabicNumContext;
        sCRIPT_ANALYSIS2.s.fGcpClusters = sCRIPT_ANALYSIS.s.fGcpClusters;
        sCRIPT_ANALYSIS2.s.fReserved = sCRIPT_ANALYSIS.s.fReserved;
        sCRIPT_ANALYSIS2.s.fEngineReserved = sCRIPT_ANALYSIS.s.fEngineReserved;
        return sCRIPT_ANALYSIS2;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        boolean bl;
        long l;
        int n8;
        this.checkLayout();
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n8 = this.text.length()) == 0 && n5 == 0) {
            return;
        }
        long l2 = gC.handle;
        Rectangle rectangle = gC.getClipping();
        GCData gCData = gC.data;
        long l3 = gCData.gdipGraphics;
        int n9 = gCData.foreground;
        int n10 = gCData.alpha;
        boolean bl2 = l3 != 0L && (n10 != 255 || gCData.foregroundPattern != null);
        long l4 = 0L;
        float[] fArray = null;
        Rect rect = new Rect();
        if (l3 != 0L && !bl2) {
            l = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (l == 0L) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(l3, l);
            long l5 = gC.identity();
            Gdip.Matrix_Invert(l5);
            Gdip.Matrix_Multiply(l, l5, 1);
            Gdip.Matrix_delete(l5);
            if (!Gdip.Matrix_IsIdentity(l)) {
                fArray = new float[6];
                Gdip.Matrix_GetElements(l, fArray);
            }
            Gdip.Matrix_delete(l);
            if ((gCData.style & 0x8000000) != 0 && fArray != null) {
                bl2 = true;
                fArray = null;
            } else {
                Gdip.Graphics_SetPixelOffsetMode(l3, 3);
                long l6 = Gdip.Region_new();
                Gdip.Graphics_GetClip(l3, l6);
                if (!Gdip.Region_IsInfinite(l6, l3)) {
                    l4 = Gdip.Region_GetHRGN(l6, l3);
                }
                Gdip.Region_delete(l6);
                Gdip.Graphics_SetPixelOffsetMode(l3, 4);
                l2 = Gdip.Graphics_GetHDC(l3);
            }
        }
        l = 0L;
        int n11 = 0;
        if (bl2) {
            gC.checkGC(1);
            l = gC.getFgBrush();
        } else {
            n11 = OS.SaveDC(l2);
            if ((gCData.style & 0x8000000) != 0) {
                OS.SetLayout(l2, OS.GetLayout(l2) | 1);
            }
            if (fArray != null) {
                OS.SetGraphicsMode(l2, 2);
                OS.SetWorldTransform(l2, fArray);
            }
            if (l4 != 0L) {
                OS.SelectClipRgn(l2, l4);
                OS.DeleteObject(l4);
            }
        }
        boolean bl3 = bl = n3 <= n4 && n3 != -1 && n4 != -1;
        if (bl || (n5 & 0x100000) != 0) {
            n3 = Math.min(Math.max(0, n3), n8 - 1);
            n4 = Math.min(Math.max(0, n4), n8 - 1);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
        }
        RECT rECT = new RECT();
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        if (bl || (n5 & 0x100000) != 0) {
            if (bl2) {
                n7 = color2.handle;
                n6 = (n10 & 0xFF) << 24 | n7 >> 16 & 0xFF | n7 & 0xFF00 | (n7 & 0xFF) << 16;
                long l10 = Gdip.Color_new(n6);
                l7 = Gdip.SolidBrush_new(l10);
                Gdip.Color_delete(l10);
                int n12 = color.handle;
                n6 = (n10 & 0xFF) << 24 | n12 >> 16 & 0xFF | n12 & 0xFF00 | (n12 & 0xFF) << 16;
                l10 = Gdip.Color_new(n6);
                l9 = Gdip.SolidBrush_new(l10);
                l8 = Gdip.Pen_new(l9, 1.0f);
                Gdip.Color_delete(l10);
            } else {
                l7 = OS.CreateSolidBrush(color2.handle);
                l8 = OS.CreatePen(0, 1, color.handle);
            }
        }
        n7 = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        OS.SetBkMode(l2, 1);
        n6 = 0;
        while (n6 < this.runs.length) {
            int n13;
            int n14;
            int n15 = n + this.getLineIndent(n6);
            int n16 = n2 + this.lineY[n6];
            StyleItem[] styleItemArray = this.runs[n6];
            int n17 = this.lineY[n6 + 1] - this.lineY[n6] - this.lineSpacing;
            if (n5 != 0 && (bl || (n5 & 0x100000) != 0)) {
                n14 = 0;
                if (n6 == this.runs.length - 1 && (n5 & 0x100000) != 0) {
                    n14 = 1;
                } else {
                    StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
                    if (styleItem.lineBreak && !styleItem.softBreak) {
                        if (n3 <= styleItem.start && styleItem.start <= n4) {
                            n14 = 1;
                        }
                    } else {
                        n13 = styleItem.start + styleItem.length - 1;
                        if (n3 <= n13 && n13 < n4 && (n5 & 0x10000) != 0) {
                            n14 = 1;
                        }
                    }
                }
                if (n14 != 0) {
                    int n18 = (n5 & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : n17 / 3;
                    if (bl2) {
                        Gdip.Graphics_FillRectangle(l3, l7, n15 + this.lineWidth[n6], n16, n18, n17);
                    } else {
                        OS.SelectObject(l2, l7);
                        OS.PatBlt(l2, n15 + this.lineWidth[n6], n16, n18, n17, 15728673);
                    }
                }
            }
            if (n15 <= rectangle.x + rectangle.width && n15 + this.lineWidth[n6] >= rectangle.x) {
                int n19;
                int n20;
                int n21;
                n14 = Math.max(0, this.ascent);
                int n22 = 0;
                n13 = 0;
                while (n13 < styleItemArray.length) {
                    n14 = Math.max(n14, styleItemArray[n13].ascent);
                    n22 = Math.min(n22, styleItemArray[n13].underlinePos);
                    ++n13;
                }
                n13 = n15;
                int n23 = 0;
                while (n23 < styleItemArray.length) {
                    StyleItem styleItem = styleItemArray[n23];
                    if (styleItem.length != 0) {
                        if (n15 > rectangle.x + rectangle.width) break;
                        if (n15 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                            int n24 = styleItem.start + styleItem.length - 1;
                            int n25 = n21 = bl && n3 <= styleItem.start && n4 >= n24 ? 1 : 0;
                            if (n21 != 0) {
                                if (bl2) {
                                    Gdip.Graphics_FillRectangle(l3, l7, n15, n16, styleItem.width, n17);
                                } else {
                                    OS.SelectObject(l2, l7);
                                    OS.PatBlt(l2, n15, n16, styleItem.width, n17, 15728673);
                                }
                            } else {
                                if (styleItem.style != null && styleItem.style.background != null) {
                                    n20 = styleItem.style.background.handle;
                                    if (bl2) {
                                        n19 = (n10 & 0xFF) << 24 | n20 >> 16 & 0xFF | n20 & 0xFF00 | (n20 & 0xFF) << 16;
                                        long l11 = Gdip.Color_new(n19);
                                        long l12 = Gdip.SolidBrush_new(l11);
                                        Gdip.Graphics_FillRectangle(l3, l12, n15, n16, styleItem.width, n17);
                                        Gdip.Color_delete(l11);
                                        Gdip.SolidBrush_delete(l12);
                                    } else {
                                        long l13 = OS.CreateSolidBrush(n20);
                                        long l14 = OS.SelectObject(l2, l13);
                                        OS.PatBlt(l2, n15, n16, styleItem.width, n17, 15728673);
                                        OS.SelectObject(l2, l14);
                                        OS.DeleteObject(l13);
                                    }
                                }
                                int n26 = n20 = bl && n3 <= n24 && styleItem.start <= n4 ? 1 : 0;
                                if (n20 != 0) {
                                    n19 = Math.max(n3, styleItem.start) - styleItem.start;
                                    int n27 = Math.min(n4, n24) - styleItem.start;
                                    int n28 = styleItem.length;
                                    int n29 = styleItem.glyphCount;
                                    int[] nArray = new int[1];
                                    long l15 = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                                    OS.ScriptCPtoX(n19, false, n28, n29, styleItem.clusters, styleItem.visAttrs, l15, styleItem.analysis, nArray);
                                    int n30 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.left = n15 + n30;
                                    rECT.top = n16;
                                    OS.ScriptCPtoX(n27, true, n28, n29, styleItem.clusters, styleItem.visAttrs, l15, styleItem.analysis, nArray);
                                    n30 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.right = n15 + n30;
                                    rECT.bottom = n16 + n17;
                                    if (bl2) {
                                        if (rECT.left > rECT.right) {
                                            int n31 = rECT.left;
                                            rECT.left = rECT.right;
                                            rECT.right = n31;
                                        }
                                        Gdip.Graphics_FillRectangle(l3, l7, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
                                    } else {
                                        OS.SelectObject(l2, l7);
                                        OS.PatBlt(l2, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                                    }
                                }
                            }
                        }
                        n15 += styleItem.width;
                    }
                    ++n23;
                }
                RECT rECT2 = null;
                n15 = n13;
                int n32 = 0;
                while (n32 < styleItemArray.length) {
                    StyleItem styleItem = styleItemArray[n32];
                    if (styleItem.length != 0) {
                        if (n15 > rectangle.x + rectangle.width) break;
                        if (!(n15 + styleItem.width < rectangle.x || styleItem.tab || styleItem.lineBreak && !styleItem.softBreak || styleItem.style != null && styleItem.style.metrics != null)) {
                            int n33;
                            n21 = styleItem.start + styleItem.length - 1;
                            n20 = bl && n3 <= styleItem.start && n4 >= n21 ? 1 : 0;
                            n19 = bl && n20 == 0 && n3 <= n21 && styleItem.start <= n4 ? 1 : 0;
                            OS.SelectObject(l2, this.getItemFont(styleItem));
                            int n34 = n16 + (n14 - styleItem.ascent);
                            if (n19 != 0) {
                                int n35 = Math.max(n3, styleItem.start) - styleItem.start;
                                int n36 = Math.min(n4, n21) - styleItem.start;
                                int n37 = styleItem.length;
                                int n38 = styleItem.glyphCount;
                                int[] nArray = new int[1];
                                long l16 = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                                OS.ScriptCPtoX(n35, false, n37, n38, styleItem.clusters, styleItem.visAttrs, l16, styleItem.analysis, nArray);
                                n33 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.left = n15 + n33;
                                rECT.top = n16;
                                OS.ScriptCPtoX(n36, true, n37, n38, styleItem.clusters, styleItem.visAttrs, l16, styleItem.analysis, nArray);
                                n33 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.right = n15 + n33;
                                rECT.bottom = n16 + n17;
                            }
                            if (bl2) {
                                int n39;
                                OS.BeginPath(l2);
                                OS.ScriptTextOut(l2, styleItem.psc, n15, n34, 0, null, styleItem.analysis, 0L, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                OS.EndPath(l2);
                                int n40 = OS.GetPath(l2, null, null, 0);
                                int[] nArray = new int[n40 * 2];
                                byte[] byArray = new byte[n40];
                                OS.GetPath(l2, nArray, byArray, n40);
                                int n41 = 0;
                                while (n41 < byArray.length) {
                                    int n42 = 0;
                                    int n43 = byArray[n41] & 0xFF;
                                    switch (n43 & 0xFFFFFFFE) {
                                        case 6: {
                                            n42 = 0;
                                            break;
                                        }
                                        case 2: {
                                            n42 = 1;
                                            break;
                                        }
                                        case 4: {
                                            n42 = 3;
                                        }
                                    }
                                    if ((n43 & 1) != 0) {
                                        n42 |= 0x80;
                                    }
                                    byArray[n41] = (byte)n42;
                                    ++n41;
                                }
                                long l17 = Gdip.GraphicsPath_new(nArray, byArray, n40, 0);
                                if (l17 == 0L) {
                                    SWT.error(2);
                                }
                                long l18 = l;
                                if (n20 != 0) {
                                    l18 = l9;
                                } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                    n33 = styleItem.style.foreground.handle;
                                    n39 = (n10 & 0xFF) << 24 | n33 >> 16 & 0xFF | n33 & 0xFF00 | (n33 & 0xFF) << 16;
                                    long l19 = Gdip.Color_new(n39);
                                    l18 = Gdip.SolidBrush_new(l19);
                                    Gdip.Color_delete(l19);
                                }
                                n33 = 0;
                                if (n19 != 0) {
                                    rect.X = rECT.left;
                                    rect.Y = rECT.top;
                                    rect.Width = rECT.right - rECT.left;
                                    rect.Height = rECT.bottom - rECT.top;
                                    n33 = Gdip.Graphics_Save(l3);
                                    Gdip.Graphics_SetClip(l3, rect, 4);
                                }
                                n39 = Gdip.Graphics_GetSmoothingMode(l3);
                                int n44 = 0;
                                int n45 = Gdip.Graphics_GetTextRenderingHint(gCData.gdipGraphics);
                                switch (n45) {
                                    case 0: {
                                        n44 = 4;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n44 = 3;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        n44 = 4;
                                    }
                                }
                                Gdip.Graphics_SetSmoothingMode(l3, n44);
                                int n46 = 0;
                                if ((gCData.style & 0x8000000) != 0) {
                                    n46 = Gdip.Graphics_Save(l3);
                                    Gdip.Graphics_ScaleTransform(l3, -1.0f, 1.0f, 0);
                                    Gdip.Graphics_TranslateTransform(l3, -2 * n15 - styleItem.width, 0.0f, 0);
                                }
                                Gdip.Graphics_FillPath(l3, l18, l17);
                                if ((gCData.style & 0x8000000) != 0) {
                                    Gdip.Graphics_Restore(l3, n46);
                                }
                                Gdip.Graphics_SetSmoothingMode(l3, n39);
                                this.drawLines(bl2, l3, n, n16 + n14, n22, n16 + n17, styleItemArray, n32, l18, null, n10);
                                if (n19 != 0) {
                                    Gdip.Graphics_Restore(l3, n33);
                                    n33 = Gdip.Graphics_Save(l3);
                                    Gdip.Graphics_SetClip(l3, rect, 1);
                                    Gdip.Graphics_SetSmoothingMode(l3, n44);
                                    if ((gCData.style & 0x8000000) != 0) {
                                        n46 = Gdip.Graphics_Save(l3);
                                        Gdip.Graphics_ScaleTransform(l3, -1.0f, 1.0f, 0);
                                        Gdip.Graphics_TranslateTransform(l3, -2 * n15 - styleItem.width, 0.0f, 0);
                                    }
                                    Gdip.Graphics_FillPath(l3, l9, l17);
                                    if ((gCData.style & 0x8000000) != 0) {
                                        Gdip.Graphics_Restore(l3, n46);
                                    }
                                    Gdip.Graphics_SetSmoothingMode(l3, n39);
                                    this.drawLines(bl2, l3, n, n16 + n14, n22, n16 + n17, styleItemArray, n32, l9, rECT, n10);
                                    Gdip.Graphics_Restore(l3, n33);
                                }
                                rECT2 = this.drawBorder(bl2, l3, n, n16, n17, l, l9, n20 != 0, rECT2, n19 != 0 ? rECT : null, n10, styleItemArray, n32, n3, n4);
                                Gdip.GraphicsPath_delete(l17);
                                if (l18 != l9 && l18 != l) {
                                    Gdip.SolidBrush_delete(l18);
                                }
                            } else {
                                int n47 = n9;
                                if (n20 != 0) {
                                    n47 = color.handle;
                                } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                    n47 = styleItem.style.foreground.handle;
                                }
                                OS.SetTextColor(l2, n47);
                                OS.ScriptTextOut(l2, styleItem.psc, n15 + n7, n34, 0, null, styleItem.analysis, 0L, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                this.drawLines(bl2, l2, n, n16 + n14, n22, n16 + n17, styleItemArray, n32, n47, null, n10);
                                if (n19 != 0 && n47 != color.handle) {
                                    OS.SetTextColor(l2, color.handle);
                                    OS.ScriptTextOut(l2, styleItem.psc, n15 + n7, n34, 4, rECT, styleItem.analysis, 0L, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                    this.drawLines(bl2, l2, n, n16 + n14, n22, n16 + n17, styleItemArray, n32, color.handle, rECT, n10);
                                }
                                int n48 = color != null ? color.handle : 0;
                                rECT2 = this.drawBorder(bl2, l2, n, n16, n17, n9, n48, n20 != 0, rECT2, n19 != 0 ? rECT : null, n10, styleItemArray, n32, n3, n4);
                            }
                        }
                        n15 += styleItem.width;
                    }
                    ++n32;
                }
            }
            ++n6;
        }
        if (bl2) {
            if (l7 != 0L) {
                Gdip.SolidBrush_delete(l7);
            }
            if (l9 != 0L) {
                Gdip.SolidBrush_delete(l9);
            }
            if (l8 != 0L) {
                Gdip.Pen_delete(l8);
            }
        } else {
            OS.RestoreDC(l2, n11);
            if (l3 != 0L) {
                Gdip.Graphics_ReleaseHDC(l3, l2);
            }
            if (l7 != 0L) {
                OS.DeleteObject(l7);
            }
            if (l8 != 0L) {
                OS.DeleteObject(l8);
            }
        }
    }

    void drawLines(boolean bl, long l, int n, int n2, int n3, int n4, StyleItem[] styleItemArray, int n5, long l2, RECT rECT, int n6) {
        StyleItem styleItem = styleItemArray[n5];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return;
        }
        if (!textStyle.underline && !textStyle.strikeout) {
            return;
        }
        int n7 = n + styleItem.x;
        int n8 = n2 - n3;
        int n9 = n2 - styleItem.strikeoutPos;
        if (bl) {
            long l3;
            int n10;
            Gdip.Graphics_SetPixelOffsetMode(l, 3);
            long l4 = l2;
            if (textStyle.underline) {
                int n11;
                if (textStyle.underlineColor != null) {
                    n11 = textStyle.underlineColor.handle;
                    n10 = (n6 & 0xFF) << 24 | n11 >> 16 & 0xFF | n11 & 0xFF00 | (n11 & 0xFF) << 16;
                    l3 = Gdip.Color_new(n10);
                    l4 = Gdip.SolidBrush_new(l3);
                    Gdip.Color_delete(l3);
                }
                switch (textStyle.underlineStyle) {
                    case 2: 
                    case 3: {
                        Object object;
                        n11 = 1;
                        n10 = 2 * n11;
                        int n12 = Math.min(n8 - n10 / 2, n4 - n10 - 1);
                        int n13 = n7;
                        int n14 = n5;
                        while (n14 > 0 && textStyle.isAdherentUnderline(styleItemArray[n14 - 1].style)) {
                            n13 = n + styleItemArray[n14 - 1].x;
                            --n14;
                        }
                        n14 = 0;
                        if (rECT == null) {
                            n14 = Gdip.Graphics_Save(l);
                            object = new Rect();
                            ((Rect)object).X = n7;
                            ((Rect)object).Y = n12;
                            ((Rect)object).Width = styleItem.width + 1;
                            ((Rect)object).Height = n12 + n10 + 1;
                            Gdip.Graphics_SetClip(l, (Rect)object, 1);
                        }
                        object = this.computePolyline(n13, n12, n7 + styleItem.width, n12 + n10);
                        long l5 = Gdip.Pen_new(l4, n11);
                        Gdip.Graphics_DrawLines(l, l5, (int[])object, ((Object)object).length / 2);
                        Gdip.Pen_delete(l5);
                        if (n14 == 0) break;
                        Gdip.Graphics_Restore(l, n14);
                        break;
                    }
                    case 0: {
                        Gdip.Graphics_FillRectangle(l, l4, n7, n8, styleItem.width, styleItem.underlineThickness);
                        break;
                    }
                    case 1: {
                        Gdip.Graphics_FillRectangle(l, l4, n7, n8, styleItem.width, styleItem.underlineThickness);
                        Gdip.Graphics_FillRectangle(l, l4, n7, n8 + styleItem.underlineThickness * 2, styleItem.width, styleItem.underlineThickness);
                        break;
                    }
                    case 196608: {
                        Gdip.Graphics_FillRectangle(l, l4, n7 - styleItem.underlineThickness, n8, styleItem.width, styleItem.underlineThickness * 2);
                        break;
                    }
                    case 65536: 
                    case 131072: {
                        long l6 = Gdip.Pen_new(l4, 1.0f);
                        int n15 = textStyle.underlineStyle == 65536 ? 2 : 1;
                        Gdip.Pen_SetDashStyle(l6, n15);
                        Gdip.Graphics_DrawLine(l, l6, n7, n8, n7 + styleItem.width, n8);
                        Gdip.Pen_delete(l6);
                    }
                }
                if (l4 != l2) {
                    Gdip.SolidBrush_delete(l4);
                }
            }
            if (textStyle.strikeout) {
                if (textStyle.strikeoutColor != null) {
                    int n16 = textStyle.strikeoutColor.handle;
                    n10 = (n6 & 0xFF) << 24 | n16 >> 16 & 0xFF | n16 & 0xFF00 | (n16 & 0xFF) << 16;
                    l3 = Gdip.Color_new(n10);
                    l4 = Gdip.SolidBrush_new(l3);
                    Gdip.Color_delete(l3);
                }
                Gdip.Graphics_FillRectangle(l, l4, n7, n9, styleItem.width, styleItem.strikeoutThickness);
                if (l4 != l2) {
                    Gdip.SolidBrush_delete(l4);
                }
            }
            Gdip.Graphics_SetPixelOffsetMode(l, 4);
        } else {
            int n17 = (int)l2;
            int n18 = (int)l2;
            long l7 = 0L;
            long l8 = 0L;
            RECT rECT2 = new RECT();
            if (textStyle.underline) {
                if (textStyle.underlineColor != null) {
                    n17 = textStyle.underlineColor.handle;
                }
                switch (textStyle.underlineStyle) {
                    case 2: 
                    case 3: {
                        int n19 = 1;
                        int n20 = 2 * n19;
                        int n21 = Math.min(n8 - n20 / 2, n4 - n20 - 1);
                        int n22 = n7;
                        int n23 = n5;
                        while (n23 > 0 && textStyle.isAdherentUnderline(styleItemArray[n23 - 1].style)) {
                            n22 = n + styleItemArray[n23 - 1].x;
                            --n23;
                        }
                        n23 = OS.SaveDC(l);
                        if (rECT != null) {
                            OS.IntersectClipRect(l, rECT.left, rECT.top, rECT.right, rECT.bottom);
                        } else {
                            OS.IntersectClipRect(l, n7, n21, n7 + styleItem.width + 1, n21 + n20 + 1);
                        }
                        int[] nArray = this.computePolyline(n22, n21, n7 + styleItem.width, n21 + n20);
                        long l9 = OS.CreatePen(0, n19, n17);
                        long l10 = OS.SelectObject(l, l9);
                        OS.Polyline(l, nArray, nArray.length / 2);
                        int n24 = nArray.length;
                        if (n24 >= 2 && n19 <= 1) {
                            OS.SetPixel(l, nArray[n24 - 2], nArray[n24 - 1], n17);
                        }
                        OS.RestoreDC(l, n23);
                        OS.SelectObject(l, l10);
                        OS.DeleteObject(l9);
                        break;
                    }
                    case 0: {
                        l7 = OS.CreateSolidBrush(n17);
                        OS.SetRect(rECT2, n7, n8, n7 + styleItem.width, n8 + styleItem.underlineThickness);
                        if (rECT != null) {
                            rECT2.left = Math.max(rECT2.left, rECT.left);
                            rECT2.right = Math.min(rECT2.right, rECT.right);
                        }
                        OS.FillRect(l, rECT2, l7);
                        break;
                    }
                    case 1: {
                        l7 = OS.CreateSolidBrush(n17);
                        OS.SetRect(rECT2, n7, n8, n7 + styleItem.width, n8 + styleItem.underlineThickness);
                        if (rECT != null) {
                            rECT2.left = Math.max(rECT2.left, rECT.left);
                            rECT2.right = Math.min(rECT2.right, rECT.right);
                        }
                        OS.FillRect(l, rECT2, l7);
                        OS.SetRect(rECT2, n7, n8 + styleItem.underlineThickness * 2, n7 + styleItem.width, n8 + styleItem.underlineThickness * 3);
                        if (rECT != null) {
                            rECT2.left = Math.max(rECT2.left, rECT.left);
                            rECT2.right = Math.min(rECT2.right, rECT.right);
                        }
                        OS.FillRect(l, rECT2, l7);
                        break;
                    }
                    case 196608: {
                        l7 = OS.CreateSolidBrush(n17);
                        OS.SetRect(rECT2, n7, n8 - styleItem.underlineThickness, n7 + styleItem.width, n8 + styleItem.underlineThickness);
                        if (rECT != null) {
                            rECT2.left = Math.max(rECT2.left, rECT.left);
                            rECT2.right = Math.min(rECT2.right, rECT.right);
                        }
                        OS.FillRect(l, rECT2, l7);
                        break;
                    }
                    case 65536: 
                    case 131072: {
                        n8 = n2 + styleItem.descent;
                        int n25 = textStyle.underlineStyle == 131072 ? 1 : 2;
                        long l11 = OS.CreatePen(n25, 1, n17);
                        long l12 = OS.SelectObject(l, l11);
                        OS.SetRect(rECT2, n7, n8, n7 + styleItem.width, n8 + styleItem.underlineThickness);
                        if (rECT != null) {
                            rECT2.left = Math.max(rECT2.left, rECT.left);
                            rECT2.right = Math.min(rECT2.right, rECT.right);
                        }
                        OS.MoveToEx(l, rECT2.left, rECT2.top, 0L);
                        OS.LineTo(l, rECT2.right, rECT2.top);
                        OS.SelectObject(l, l12);
                        OS.DeleteObject(l11);
                    }
                }
            }
            if (textStyle.strikeout) {
                if (textStyle.strikeoutColor != null) {
                    n18 = textStyle.strikeoutColor.handle;
                }
                l8 = l7 != 0L && n18 == n17 ? l7 : OS.CreateSolidBrush(n18);
                OS.SetRect(rECT2, n7, n9, n7 + styleItem.width, n9 + styleItem.strikeoutThickness);
                if (rECT != null) {
                    rECT2.left = Math.max(rECT2.left, rECT.left);
                    rECT2.right = Math.min(rECT2.right, rECT.right);
                }
                OS.FillRect(l, rECT2, l8);
            }
            if (l7 != 0L) {
                OS.DeleteObject(l7);
            }
            if (l8 != 0L && l8 != l7) {
                OS.DeleteObject(l8);
            }
        }
    }

    RECT drawBorder(boolean bl, long l, int n, int n2, int n3, long l2, long l3, boolean bl2, RECT rECT, RECT rECT2, int n4, StyleItem[] styleItemArray, int n5, int n6, int n7) {
        int n8;
        StyleItem styleItem = styleItemArray[n5];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        if (rECT2 != null) {
            if (rECT == null) {
                rECT = new RECT();
                OS.SetRect(rECT, -1, rECT2.top, -1, rECT2.bottom);
            }
            int n9 = n8 = (this.orientation & 0x4000000) != 0 ? 1 : 0;
            if (styleItem.start <= n6 && n6 <= styleItem.start + styleItem.length) {
                if ((styleItem.analysis.fRTL ^ n8) != 0) {
                    rECT.right = rECT2.left;
                } else {
                    rECT.left = rECT2.left;
                }
            }
            if (styleItem.start <= n7 && n7 <= styleItem.start + styleItem.length) {
                if ((styleItem.analysis.fRTL ^ n8) != 0) {
                    rECT.left = rECT2.right;
                } else {
                    rECT.right = rECT2.right;
                }
            }
        }
        if (n5 + 1 >= styleItemArray.length || !textStyle.isAdherentBorder(styleItemArray[n5 + 1].style)) {
            n8 = styleItem.x;
            int n10 = n5;
            while (n10 > 0 && textStyle.isAdherentBorder(styleItemArray[n10 - 1].style)) {
                n8 = styleItemArray[n10 - 1].x;
                --n10;
            }
            if (bl) {
                int n11;
                long l4 = l2;
                int n12 = -1;
                if (textStyle.borderColor != null) {
                    n12 = textStyle.borderColor.handle;
                } else {
                    if (textStyle.foreground != null) {
                        n12 = textStyle.foreground.handle;
                    }
                    if (bl2 && rECT == null) {
                        n12 = -1;
                        l4 = l3;
                    }
                }
                if (n12 != -1) {
                    n11 = (n4 & 0xFF) << 24 | n12 >> 16 & 0xFF | n12 & 0xFF00 | (n12 & 0xFF) << 16;
                    long l5 = Gdip.Color_new(n11);
                    l4 = Gdip.SolidBrush_new(l5);
                    Gdip.Color_delete(l5);
                }
                n11 = 1;
                int n13 = 0;
                switch (textStyle.borderStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n13 = 1;
                        break;
                    }
                    case 4: {
                        n13 = 2;
                    }
                }
                long l6 = Gdip.Pen_new(l4, n11);
                Gdip.Pen_SetDashStyle(l6, n13);
                float f = 0.5f;
                float f2 = 0.5f;
                Gdip.Graphics_TranslateTransform(l, f, f2, 0);
                if (textStyle.borderColor == null && rECT != null) {
                    int n14 = Gdip.Graphics_Save(l);
                    if (rECT.left == -1) {
                        rECT.left = 0;
                    }
                    if (rECT.right == -1) {
                        rECT.right = 524287;
                    }
                    Rect rect = new Rect();
                    rect.X = rECT.left;
                    rect.Y = rECT.top;
                    rect.Width = rECT.right - rECT.left;
                    rect.Height = rECT.bottom - rECT.top;
                    Gdip.Graphics_SetClip(l, rect, 4);
                    Gdip.Graphics_DrawRectangle(l, l6, n + n8, n2, styleItem.x + styleItem.width - n8 - 1, n3 - 1);
                    Gdip.Graphics_Restore(l, n14);
                    n14 = Gdip.Graphics_Save(l);
                    Gdip.Graphics_SetClip(l, rect, 1);
                    long l7 = Gdip.Pen_new(l3, n11);
                    Gdip.Pen_SetDashStyle(l6, n13);
                    Gdip.Graphics_DrawRectangle(l, l7, n + n8, n2, styleItem.x + styleItem.width - n8 - 1, n3 - 1);
                    Gdip.Pen_delete(l7);
                    Gdip.Graphics_Restore(l, n14);
                } else {
                    Gdip.Graphics_DrawRectangle(l, l6, n + n8, n2, styleItem.x + styleItem.width - n8 - 1, n3 - 1);
                }
                Gdip.Graphics_TranslateTransform(l, -f, -f2, 0);
                Gdip.Pen_delete(l6);
                if (n12 != -1) {
                    Gdip.SolidBrush_delete(l4);
                }
            } else {
                if (textStyle.borderColor != null) {
                    l2 = textStyle.borderColor.handle;
                } else {
                    if (textStyle.foreground != null) {
                        l2 = textStyle.foreground.handle;
                    }
                    if (bl2 && rECT == null) {
                        l2 = l3;
                    }
                }
                n10 = 1;
                int n15 = 0;
                switch (textStyle.borderStyle) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n15 = 1;
                        break;
                    }
                    case 4: {
                        n15 = 2;
                    }
                }
                LOGBRUSH lOGBRUSH = new LOGBRUSH();
                lOGBRUSH.lbStyle = 0;
                lOGBRUSH.lbColor = (int)l2;
                long l8 = OS.ExtCreatePen(n15 | 0x10000, Math.max(1, n10), lOGBRUSH, 0, null);
                long l9 = OS.SelectObject(l, l8);
                long l10 = OS.SelectObject(l, OS.GetStockObject(5));
                OS.Rectangle(l, n + n8, n2, n + styleItem.x + styleItem.width, n2 + n3);
                if (textStyle.borderColor == null && rECT != null && l2 != l3) {
                    int n16 = OS.SaveDC(l);
                    if (rECT.left == -1) {
                        rECT.left = 0;
                    }
                    if (rECT.right == -1) {
                        rECT.right = 524287;
                    }
                    OS.IntersectClipRect(l, rECT.left, rECT.top, rECT.right, rECT.bottom);
                    lOGBRUSH.lbColor = (int)l3;
                    long l11 = OS.ExtCreatePen(n15 | 0x10000, Math.max(1, n10), lOGBRUSH, 0, null);
                    OS.SelectObject(l, l11);
                    OS.Rectangle(l, n + n8, n2, n + styleItem.x + styleItem.width, n2 + n3);
                    OS.RestoreDC(l, n16);
                    OS.SelectObject(l, l8);
                    OS.DeleteObject(l11);
                }
                OS.SelectObject(l, l10);
                OS.SelectObject(l, l9);
                OS.DeleteObject(l8);
            }
            return null;
        }
        return rECT;
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        int n9 = 0;
        while (n9 < n8) {
            int n10 = 4 * n9;
            nArray[n10] = n + n7 * n9;
            nArray[n10 + 1] = n4;
            nArray[n10 + 2] = nArray[n10] + n7 / 2;
            nArray[n10 + 3] = n2;
            ++n9;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int n = 0;
        while (n < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n];
            styleItem.free();
            ++n;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n = 0;
        if (this.wrapWidth != -1) {
            n = this.wrapWidth;
        } else {
            int n2 = 0;
            while (n2 < this.runs.length) {
                n = Math.max(n, this.lineWidth[n2] + this.getLineIndent(n2));
                ++n2;
            }
        }
        return new Rectangle(0, 0, n, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        boolean bl = (this.orientation & 0x4000000) != 0;
        int n8 = 0;
        while (n8 < this.allRuns.length - 1) {
            StyleItem styleItem = this.allRuns[n8];
            int n9 = styleItem.start + styleItem.length;
            if (n9 > n) {
                long l;
                Object object;
                int n10;
                if (styleItem.start > n2) break;
                int n11 = styleItem.x;
                int n12 = styleItem.x + styleItem.width;
                if (styleItem.start <= n && n < n9) {
                    n10 = 0;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n10 = object.width * (n - styleItem.start);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n - styleItem.start, false, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, object);
                        int n13 = n10 = bl ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl) {
                        n12 = styleItem.x + n10;
                    } else {
                        n11 = styleItem.x + n10;
                    }
                }
                if (styleItem.start <= n2 && n2 < n9) {
                    n10 = styleItem.width;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n10 = object.width * (n2 - styleItem.start + 1);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n2 - styleItem.start, true, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, object);
                        int n14 = n10 = bl ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl) {
                        n11 = styleItem.x + n10;
                    } else {
                        n12 = styleItem.x + n10;
                    }
                }
                n10 = 0;
                while (n10 < this.runs.length && this.lineOffset[n10 + 1] <= styleItem.start) {
                    ++n10;
                }
                n4 = Math.min(n4, n11);
                n5 = Math.max(n5, n12);
                n6 = Math.min(n6, this.lineY[n10]);
                n7 = Math.max(n7, this.lineY[n10 + 1] - this.lineSpacing);
            }
            ++n8;
        }
        return new Rectangle(n4, n6, n5 - n4, n7 - n6);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    long getItemFont(StyleItem styleItem) {
        if (styleItem.fallbackFont != 0L) {
            return styleItem.fallbackFont;
        }
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont.handle;
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 1;
        while (n3 < this.allRuns.length) {
            if (this.allRuns[n3].start > n) {
                return this.allRuns[n3 - 1].analysis.s.uBidiLevel;
            }
            ++n3;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.getLineIndent(n);
        int n3 = this.lineY[n];
        int n4 = this.lineWidth[n];
        int n5 = this.lineY[n + 1] - n3 - this.lineSpacing;
        return new Rectangle(n2, n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n) {
        StyleItem[] styleItemArray;
        int n2 = 0;
        if (n == 0) {
            n2 = this.indent;
        } else {
            StyleItem[] styleItemArray2 = this.runs[n - 1];
            styleItemArray = styleItemArray2[styleItemArray2.length - 1];
            if (styleItemArray.lineBreak && !styleItemArray.softBreak) {
                n2 = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean bl = true;
            if (this.justify) {
                styleItemArray = this.runs[n];
                if (styleItemArray[styleItemArray.length - 1].softBreak) {
                    bl = false;
                }
            }
            if (bl) {
                int n3 = this.lineWidth[n] + n2;
                switch (this.alignment) {
                    case 0x1000000: {
                        n2 += (this.wrapWidth - n3) / 2;
                        break;
                    }
                    case 131072: {
                        n2 += this.wrapWidth - n3;
                    }
                }
            }
        }
        return n2;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) {
                return n3;
            }
            ++n3;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        long l = this.device.internal_new_GC(null);
        long l2 = OS.CreateCompatibleDC(l);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(l2, this.font != null ? this.font.handle : this.device.systemFont.handle);
        OS.GetTextMetrics(l2, tEXTMETRIC);
        OS.DeleteDC(l2);
        this.device.internal_dispose_GC(l, null);
        int n2 = Math.max(tEXTMETRIC.tmAscent, this.ascent);
        int n3 = Math.max(tEXTMETRIC.tmDescent, this.descent);
        int n4 = tEXTMETRIC.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] styleItemArray = this.runs[n];
            int n5 = 0;
            while (n5 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n5];
                if (styleItem.ascent > n2) {
                    n2 = styleItem.ascent;
                    n4 = styleItem.leading;
                }
                n3 = Math.max(n3, styleItem.descent);
                ++n5;
            }
        }
        tEXTMETRIC.tmAscent = n2;
        tEXTMETRIC.tmDescent = n3;
        tEXTMETRIC.tmHeight = n2 + n3;
        tEXTMETRIC.tmInternalLeading = n4;
        tEXTMETRIC.tmAveCharWidth = 0;
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.untranslateOffset(this.lineOffset[n]);
            ++n;
        }
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n2 = this.segmentsText.length();
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) break;
            ++n3;
        }
        n3 = Math.min(n3, this.runs.length - 1);
        if (n == n2) {
            return new Point(this.getLineIndent(n3) + this.lineWidth[n3], this.lineY[n3]);
        }
        int n4 = -1;
        int n5 = this.allRuns.length;
        while (n5 - n4 > 1) {
            int n6;
            int n7 = (n5 + n4) / 2;
            StyleItem styleItem = this.allRuns[n7];
            if (styleItem.start > n) {
                n5 = n7;
                continue;
            }
            if (styleItem.start + styleItem.length <= n) {
                n4 = n7;
                continue;
            }
            if (styleItem.style != null && styleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = styleItem.style.metrics;
                n6 = glyphMetrics.width * (n - styleItem.start + (bl ? 1 : 0));
            } else if (styleItem.tab) {
                n6 = bl || n == n2 ? styleItem.width : 0;
            } else {
                int n8 = n - styleItem.start;
                int n9 = styleItem.length;
                int n10 = styleItem.glyphCount;
                int[] nArray = new int[1];
                long l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
                OS.ScriptCPtoX(n8, bl, n9, n10, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, nArray);
                n6 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
            }
            return new Point(styleItem.x + n6, this.lineY[n3]);
        }
        return new Point(0, 0);
    }

    public int getNextOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.computeRuns(null);
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        n4 = this.segmentsText.length();
        n = this.translateOffset(n);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n6 = bl ? 0 : this.allRuns.length - 1;
        n = this.validadeOffset(n, n3);
        do {
            boolean bl2;
            StyleItem styleItem = this.allRuns[n6];
            if (styleItem.start > n || n >= styleItem.start + styleItem.length) continue;
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (styleItem.tab) {
                return this.untranslateOffset(styleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl3 = bl2 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl2) {
                this.breakRun(styleItem);
            }
            while (styleItem.start <= n && n < styleItem.start + styleItem.length) {
                if (bl2) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (long)((n - styleItem.start) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                }
                switch (n2) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo) {
                            if (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop) break;
                            return this.untranslateOffset(n);
                        }
                        return this.untranslateOffset(n);
                    }
                    case 4: 
                    case 16: {
                        boolean bl4;
                        boolean bl5;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n > 0 && ((bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n))) != (bl4 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1))) || !bl5) && !Compatibility.isWhitespace(this.segmentsText.charAt(n)))) break;
                        return this.untranslateOffset(n);
                    }
                    case 8: {
                        if (n <= 0) break;
                        boolean bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n));
                        boolean bl4 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1));
                        if (bl5 || !bl4) break;
                        return this.untranslateOffset(n);
                    }
                }
                n = this.validadeOffset(n, n3);
            }
        } while ((n6 += n3) >= 0 && n6 < this.allRuns.length - 1 && n >= 0 && n < n4);
        return bl ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        this.checkLayout();
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n3 = this.runs.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.lineY[n4 + 1] > n2) break;
            ++n4;
        }
        n4 = Math.min(n4, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n4];
        int n5 = this.getLineIndent(n4);
        if (n >= n5 + this.lineWidth[n4]) {
            n = n5 + this.lineWidth[n4] - 1;
        }
        if (n < n5) {
            n = n5;
        }
        int n6 = -1;
        int n7 = styleItemArray.length;
        while (n7 - n6 > 1) {
            int n8 = (n7 + n6) / 2;
            StyleItem styleItem = styleItemArray[n8];
            if (styleItem.x > n) {
                n7 = n8;
                continue;
            }
            if (styleItem.x + styleItem.width <= n) {
                n6 = n8;
                continue;
            }
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            int n9 = n - styleItem.x;
            if (styleItem.style != null && styleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = styleItem.style.metrics;
                if (glyphMetrics.width > 0) {
                    if (nArray != null) {
                        nArray[0] = n9 % glyphMetrics.width < glyphMetrics.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(styleItem.start + n9 / glyphMetrics.width);
                }
            }
            if (styleItem.tab) {
                if (nArray != null) {
                    nArray[0] = n < styleItem.x + styleItem.width / 2 ? 0 : 1;
                }
                return this.untranslateOffset(styleItem.start);
            }
            int n10 = styleItem.length;
            int n11 = styleItem.glyphCount;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            if ((this.orientation & 0x4000000) != 0) {
                n9 = styleItem.width - n9;
            }
            long l = styleItem.justify != 0L ? styleItem.justify : styleItem.advances;
            OS.ScriptXtoCP(n9, n10, n11, styleItem.clusters, styleItem.visAttrs, l, styleItem.analysis, nArray2, nArray3);
            if (nArray != null) {
                nArray[0] = nArray3[0];
            }
            return this.untranslateOffset(styleItem.start + nArray2[0]);
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[n4 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.stylesCount) {
            if (this.styles[n3].start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.stylesCount) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        long l;
        long l2;
        this.segmentsText = this.getSegmentsText();
        int n = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n2 = n + 1;
        if ((this.orientation & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
            SCRIPT_DIGITSUBSTITUTE sCRIPT_DIGITSUBSTITUTE = new SCRIPT_DIGITSUBSTITUTE();
            OS.ScriptRecordDigitSubstitution(1024, sCRIPT_DIGITSUBSTITUTE);
            OS.ScriptApplyDigitSubstitution(sCRIPT_DIGITSUBSTITUTE, sCRIPT_CONTROL, sCRIPT_STATE);
        }
        if ((l2 = OS.HeapAlloc(l = OS.GetProcessHeap(), 8, n2 * SCRIPT_ITEM.sizeof)) == 0L) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        char[] cArray = new char[n];
        this.segmentsText.getChars(0, n, cArray, 0);
        OS.ScriptItemize(cArray, n, n2, sCRIPT_CONTROL, sCRIPT_STATE, l2, nArray);
        StyleItem[] styleItemArray = this.merge(l2, nArray[0]);
        OS.HeapFree(l, 0, l2);
        return styleItemArray;
    }

    StyleItem[] merge(long l, int n) {
        StyleItem styleItem;
        if (this.styles.length > this.stylesCount) {
            StyleItem[] styleItemArray = new StyleItem[this.stylesCount];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.segmentsText.length();
        int n5 = 0;
        int n6 = 0;
        StyleItem[] styleItemArray = new StyleItem[n + this.stylesCount];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        boolean bl = false;
        while (n3 < n4) {
            styleItem = new StyleItem();
            styleItem.start = n3;
            styleItem.style = this.styles[n6].style;
            styleItemArray[n2++] = styleItem;
            OS.MoveMemory(sCRIPT_ITEM, l + (long)(n5 * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
            styleItem.analysis = sCRIPT_ITEM.a;
            if (bl) {
                styleItem.analysis.fLinkBefore = true;
                bl = false;
            }
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(sCRIPT_ITEM, l + (long)((n5 + 1) * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
            int n7 = sCRIPT_ITEM.iCharPos;
            int n8 = this.translateOffset(this.styles[n6 + 1].start);
            if (n8 <= n7) {
                ++n6;
                n3 = n8;
                if (n3 < n7 && n3 > 0 && n3 < n4) {
                    char c = this.segmentsText.charAt(n3 - 1);
                    char c2 = this.segmentsText.charAt(n3);
                    if (Compatibility.isLetter(c) && Compatibility.isLetter(c2)) {
                        styleItem.analysis.fLinkAfter = true;
                        bl = true;
                    }
                }
            }
            if (n7 <= n8) {
                ++n5;
                n3 = n7;
            }
            styleItem.length = n3 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n4;
        OS.MoveMemory(sCRIPT_ITEM, l + (long)(n * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
        styleItem.analysis = sCRIPT_ITEM.a;
        styleItemArray[n2++] = styleItem;
        if (styleItemArray.length != n2) {
            StyleItem[] styleItemArray2 = new StyleItem[n2];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n2);
            return styleItemArray2;
        }
        return styleItemArray;
    }

    StyleItem[] reorder(StyleItem[] styleItemArray, boolean bl) {
        int n = styleItemArray.length;
        if (n <= 1) {
            return styleItemArray;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(styleItemArray[n2].analysis.s.uBidiLevel & 0x1F);
            ++n2;
        }
        StyleItem styleItem = styleItemArray[n - 1];
        if (styleItem.lineBreak && !styleItem.softBreak) {
            byArray[n - 1] = 0;
        }
        int[] nArray = new int[n];
        OS.ScriptLayout(n, byArray, null, nArray);
        StyleItem[] styleItemArray2 = new StyleItem[n];
        int n3 = 0;
        while (n3 < n) {
            styleItemArray2[nArray[n3]] = styleItemArray[n3];
            ++n3;
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (bl) {
                --n;
            }
            n3 = 0;
            while (n3 < n / 2) {
                StyleItem styleItem2 = styleItemArray2[n3];
                styleItemArray2[n3] = styleItemArray2[n - n3 - 1];
                styleItemArray2[n - n3 - 1] = styleItem2;
                ++n3;
            }
        }
        return styleItemArray2;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        if (this.alignment == n) {
            return;
        }
        this.freeRuns();
        this.alignment = n;
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.freeRuns();
        this.indent = n;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (this.justify == bl) {
            return;
        }
        this.freeRuns();
        this.justify = bl;
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        this.checkLayout();
        int n6 = this.text.length();
        if (n6 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n6 - 1);
        n2 = Math.min(Math.max(0, n2), n6 - 1);
        int n7 = -1;
        int n8 = this.stylesCount;
        while (n8 - n7 > 1) {
            n5 = (n8 + n7) / 2;
            if (this.styles[n5 + 1].start > n) {
                n8 = n5;
                continue;
            }
            n7 = n5;
        }
        if (n8 >= 0 && n8 < this.stylesCount) {
            StyleItem styleItem = this.styles[n8];
            if (styleItem.start == n && this.styles[n8 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n9 = n5 = n8;
        while (n9 < this.stylesCount) {
            if (this.styles[n9 + 1].start > n2) break;
            ++n9;
        }
        if (n5 == n9) {
            n4 = this.styles[n5].start;
            n3 = this.styles[n9 + 1].start - 1;
            if (n4 == n && n3 == n2) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n && n3 != n2) {
                int n10 = this.stylesCount + 2;
                if (n10 > this.styles.length) {
                    int n11 = Math.min(n10 + 1024, Math.max(64, n10 * 2));
                    StyleItem[] styleItemArray = new StyleItem[n11];
                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                    this.styles = styleItemArray;
                }
                System.arraycopy(this.styles, n9 + 1, this.styles, n9 + 3, this.stylesCount - n9 - 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                this.styles[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n5].style;
                this.styles[n5 + 2] = styleItem;
                this.stylesCount = n10;
                return;
            }
        }
        if (n == this.styles[n5].start) {
            --n5;
        }
        if (n2 == this.styles[n9 + 1].start - 1) {
            ++n9;
        }
        if ((n4 = this.stylesCount + 1 - (n9 - n5 - 1)) > this.styles.length) {
            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
            StyleItem[] styleItemArray = new StyleItem[n3];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        System.arraycopy(this.styles, n9, this.styles, n5 + 2, this.stylesCount - n9);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        this.styles[n5 + 1] = styleItem;
        this.styles[n5 + 2].start = n2 + 1;
        this.stylesCount = n4;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
    }

    boolean shape(long l, StyleItem styleItem, char[] cArray, int[] nArray, int n, SCRIPT_PROPERTIES sCRIPT_PROPERTIES) {
        short[] sArray;
        boolean bl;
        boolean bl2 = bl = !sCRIPT_PROPERTIES.fComplex && !styleItem.analysis.fNoGlyphIndex;
        if (bl && OS.ScriptGetCMap(l, styleItem.psc, cArray, cArray.length, 0, sArray = new short[cArray.length]) != 0) {
            if (styleItem.psc != 0L) {
                OS.ScriptFreeCache(styleItem.psc);
                nArray[0] = 0;
                OS.MoveMemory(styleItem.psc, new long[1], OS.PTR_SIZEOF);
            }
            return false;
        }
        int n2 = OS.ScriptShape(l, styleItem.psc, cArray, cArray.length, n, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
        styleItem.glyphCount = nArray[0];
        if (bl) {
            return true;
        }
        if (n2 != -2147220992) {
            if (styleItem.analysis.fNoGlyphIndex) {
                return true;
            }
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(l, styleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray2 = new short[nArray[0]];
            OS.MoveMemory(sArray2, styleItem.glyphs, sArray2.length * 2);
            int n3 = 0;
            while (n3 < sArray2.length) {
                if (sArray2[n3] == sCRIPT_FONTPROPERTIES.wgDefault) break;
                ++n3;
            }
            if (n3 == sArray2.length) {
                return true;
            }
        }
        if (styleItem.psc != 0L) {
            OS.ScriptFreeCache(styleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(styleItem.psc, new long[1], OS.PTR_SIZEOF);
        }
        styleItem.glyphCount = 0;
        return false;
    }

    void shape(long l, StyleItem styleItem) {
        int[] nArray = new int[1];
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n = cArray.length * 3 / 2 + 16;
        long l2 = OS.GetProcessHeap();
        styleItem.glyphs = OS.HeapAlloc(l2, 8, n * 2);
        if (styleItem.glyphs == 0L) {
            SWT.error(2);
        }
        styleItem.clusters = OS.HeapAlloc(l2, 8, n * 2);
        if (styleItem.clusters == 0L) {
            SWT.error(2);
        }
        styleItem.visAttrs = OS.HeapAlloc(l2, 8, n * 2);
        if (styleItem.visAttrs == 0L) {
            SWT.error(2);
        }
        styleItem.psc = OS.HeapAlloc(l2, 8, OS.PTR_SIZEOF);
        if (styleItem.psc == 0L) {
            SWT.error(2);
        }
        short s = styleItem.analysis.eScript;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[s], SCRIPT_PROPERTIES.sizeof);
        boolean bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
        if (!bl) {
            long l3 = OS.GetCurrentObject(l, 6);
            long l4 = OS.HeapAlloc(l2, 8, OS.SCRIPT_STRING_ANALYSIS_sizeof());
            long l5 = OS.CreateEnhMetaFile(l, null, null, null);
            long l6 = OS.SelectObject(l5, l3);
            int n2 = 6304;
            if (OS.ScriptStringAnalyse(l5, cArray, cArray.length, 0, -1, n2, 0, null, null, 0L, 0L, 0L, l4) == 0) {
                OS.ScriptStringOut(l4, 0, 0, 0, null, 0, 0, false);
                OS.ScriptStringFree(l4);
            }
            OS.HeapFree(l2, 0, l4);
            OS.SelectObject(l5, l6);
            long l7 = OS.CloseEnhMetaFile(l5);
            EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW = new EMREXTCREATEFONTINDIRECTW();
            class MetaFileEnumProc {
                final /* synthetic */ TextLayout this$0;
                private final /* synthetic */ EMREXTCREATEFONTINDIRECTW val$emr;

                MetaFileEnumProc(TextLayout textLayout, EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW) {
                    this.this$0 = textLayout;
                    this.val$emr = eMREXTCREATEFONTINDIRECTW;
                }

                long metaFileEnumProc(long l, long l2, long l3, long l4, long l5) {
                    OS.MoveMemory(this.val$emr.emr, l3, EMR.sizeof);
                    switch (this.val$emr.emr.iType) {
                        case 82: {
                            OS.MoveMemory(this.val$emr, l3, EMREXTCREATEFONTINDIRECTW.sizeof);
                            break;
                        }
                        case 84: {
                            return 0L;
                        }
                    }
                    return 1L;
                }
            }
            MetaFileEnumProc metaFileEnumProc = new MetaFileEnumProc(this, eMREXTCREATEFONTINDIRECTW);
            Callback callback = new Callback(metaFileEnumProc, "metaFileEnumProc", 5);
            long l8 = callback.getAddress();
            if (l8 == 0L) {
                SWT.error(3);
            }
            OS.EnumEnhMetaFile(0L, l7, l8, 0L, null);
            OS.DeleteEnhMetaFile(l7);
            callback.dispose();
            long l9 = OS.CreateFontIndirectW(eMREXTCREATEFONTINDIRECTW.elfw.elfLogFont);
            OS.SelectObject(l, l9);
            bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
            if (bl) {
                styleItem.fallbackFont = l9;
            }
            if (!bl && !sCRIPT_PROPERTIES.fComplex) {
                styleItem.analysis.fNoGlyphIndex = true;
                bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
                if (bl) {
                    styleItem.fallbackFont = l9;
                } else {
                    styleItem.analysis.fNoGlyphIndex = false;
                }
            }
            if (!bl && this.mLangFontLink2 != 0L) {
                long[] lArray = new long[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                OS.VtblCall(4, this.mLangFontLink2, cArray, cArray.length, 0, nArray2, nArray3);
                if (OS.VtblCall(10, this.mLangFontLink2, l, nArray2[0], (int)cArray[0], lArray) == 0) {
                    LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                    OS.GetObject(lArray[0], LOGFONT.sizeof, lOGFONT);
                    OS.VtblCall(8, this.mLangFontLink2, lArray[0]);
                    long l10 = OS.CreateFontIndirect(lOGFONT);
                    long l11 = OS.SelectObject(l, l10);
                    bl = this.shape(l, styleItem, cArray, nArray, n, sCRIPT_PROPERTIES);
                    if (bl) {
                        styleItem.fallbackFont = l10;
                    } else {
                        OS.SelectObject(l, l11);
                        OS.DeleteObject(l10);
                    }
                }
            }
            if (!bl) {
                OS.SelectObject(l, l3);
            }
            if (l9 != styleItem.fallbackFont) {
                OS.DeleteObject(l9);
            }
        }
        if (!bl) {
            OS.ScriptShape(l, styleItem.psc, cArray, cArray.length, n, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
            styleItem.glyphCount = nArray[0];
        }
        int[] nArray4 = new int[3];
        styleItem.advances = OS.HeapAlloc(l2, 8, styleItem.glyphCount * 4);
        if (styleItem.advances == 0L) {
            SWT.error(2);
        }
        styleItem.goffsets = OS.HeapAlloc(l2, 8, styleItem.glyphCount * 8);
        if (styleItem.goffsets == 0L) {
            SWT.error(2);
        }
        OS.ScriptPlace(l, styleItem.psc, styleItem.glyphs, styleItem.glyphCount, styleItem.visAttrs, styleItem.analysis, styleItem.advances, styleItem.goffsets, nArray4);
        styleItem.width = nArray4[0] + nArray4[1] + nArray4[2];
        TextStyle textStyle = styleItem.style;
        if (textStyle != null) {
            OUTLINETEXTMETRIC oUTLINETEXTMETRIC = null;
            if (textStyle.underline || textStyle.strikeout) {
                OUTLINETEXTMETRIC oUTLINETEXTMETRIC2 = oUTLINETEXTMETRIC = OS.IsUnicode ? new OUTLINETEXTMETRICW() : new OUTLINETEXTMETRICA();
                if (OS.GetOutlineTextMetrics(l, OUTLINETEXTMETRIC.sizeof, oUTLINETEXTMETRIC) == 0) {
                    oUTLINETEXTMETRIC = null;
                }
            }
            if (textStyle.metrics != null) {
                GlyphMetrics glyphMetrics = textStyle.metrics;
                styleItem.width = glyphMetrics.width * Math.max(1, styleItem.glyphCount);
                styleItem.ascent = glyphMetrics.ascent;
                styleItem.descent = glyphMetrics.descent;
                styleItem.leading = 0;
            } else {
                TEXTMETRIC tEXTMETRIC = null;
                if (oUTLINETEXTMETRIC != null) {
                    tEXTMETRIC = OS.IsUnicode ? oUTLINETEXTMETRIC.otmTextMetrics : ((OUTLINETEXTMETRICA)oUTLINETEXTMETRIC).otmTextMetrics;
                } else {
                    tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.GetTextMetrics(l, tEXTMETRIC);
                }
                styleItem.ascent = tEXTMETRIC.tmAscent;
                styleItem.descent = tEXTMETRIC.tmDescent;
                styleItem.leading = tEXTMETRIC.tmInternalLeading;
            }
            if (oUTLINETEXTMETRIC != null) {
                styleItem.underlinePos = oUTLINETEXTMETRIC.otmsUnderscorePosition;
                styleItem.underlineThickness = Math.max(1, oUTLINETEXTMETRIC.otmsUnderscoreSize);
                styleItem.strikeoutPos = oUTLINETEXTMETRIC.otmsStrikeoutPosition;
                styleItem.strikeoutThickness = Math.max(1, oUTLINETEXTMETRIC.otmsStrikeoutSize);
            } else {
                styleItem.underlinePos = 1;
                styleItem.underlineThickness = 1;
                styleItem.strikeoutPos = styleItem.ascent / 2;
                styleItem.strikeoutThickness = 1;
            }
            styleItem.ascent += textStyle.rise;
            styleItem.descent -= textStyle.rise;
        } else {
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(l, tEXTMETRIC);
            styleItem.ascent = tEXTMETRIC.tmAscent;
            styleItem.descent = tEXTMETRIC.tmDescent;
            styleItem.leading = tEXTMETRIC.tmInternalLeading;
        }
    }

    int validadeOffset(int n, int n2) {
        n += n2;
        if (this.segments != null && this.segments.length > 2) {
            int n3 = 0;
            while (n3 < this.segments.length) {
                if (this.translateOffset(this.segments[n3]) - 1 == n) {
                    n += n2;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return n;
        }
        int n4 = 0;
        while (n4 < n2 && n - n4 >= this.segments[n4]) {
            ++n;
            ++n4;
        }
        return n;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return n;
        }
        int n4 = 0;
        while (n4 < n2 && n > this.segments[n4]) {
            --n;
            ++n4;
        }
        return n;
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        long psc = 0L;
        long glyphs;
        int glyphCount;
        long clusters;
        long visAttrs;
        long advances;
        long goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int underlinePos;
        int underlineThickness;
        int strikeoutPos;
        int strikeoutThickness;
        long justify;
        long psla;
        long fallbackFont;

        StyleItem() {
        }

        void free() {
            long l = OS.GetProcessHeap();
            if (this.psc != 0L) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(l, 0, this.psc);
                this.psc = 0L;
            }
            if (this.glyphs != 0L) {
                OS.HeapFree(l, 0, this.glyphs);
                this.glyphs = 0L;
                this.glyphCount = 0;
            }
            if (this.clusters != 0L) {
                OS.HeapFree(l, 0, this.clusters);
                this.clusters = 0L;
            }
            if (this.visAttrs != 0L) {
                OS.HeapFree(l, 0, this.visAttrs);
                this.visAttrs = 0L;
            }
            if (this.advances != 0L) {
                OS.HeapFree(l, 0, this.advances);
                this.advances = 0L;
            }
            if (this.goffsets != 0L) {
                OS.HeapFree(l, 0, this.goffsets);
                this.goffsets = 0L;
            }
            if (this.justify != 0L) {
                OS.HeapFree(l, 0, this.justify);
                this.justify = 0L;
            }
            if (this.psla != 0L) {
                OS.HeapFree(l, 0, this.psla);
                this.psla = 0L;
            }
            if (this.fallbackFont != 0L) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0L;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

