/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Library {
    static int MAJOR_VERSION = 3;
    static int MINOR_VERSION = 452;
    static int REVISION = 0;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    static final String SEPARATOR;
    static /* synthetic */ Class class$0;

    static {
        SEPARATOR = System.getProperty("file.separator");
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }

    static int parseVersion(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n2 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        n6 = ++n5;
        while (n5 < n4 && Character.isDigit(string.charAt(n5))) {
            ++n5;
        }
        try {
            if (n6 < n4) {
                n3 = Integer.parseInt(string.substring(n6, n5));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return Library.JAVA_VERSION(n, n2, n3);
    }

    public static int JAVA_VERSION(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    public static int SWT_VERSION(int n, int n2) {
        return n * 1000 + n2;
    }

    static boolean extract(String string, String string2) {
        File file;
        block17: {
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            file = new File(string);
            try {
                int n;
                if (file.exists()) break block17;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.swt.internal.Library");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((inputStream = clazz.getResourceAsStream("/" + string2)) == null) break block17;
                byte[] byArray = new byte[4096];
                fileOutputStream = new FileOutputStream(string);
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
                if (!"win32".equals("win32")) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", string}).waitFor();
                    }
                    catch (Throwable throwable) {}
                }
                if (Library.load(string)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (file.exists()) {
            file.delete();
        }
        return false;
    }

    static boolean load(String string) {
        try {
            if (string.indexOf(SEPARATOR) != -1) {
                System.load(string);
            } else {
                System.loadLibrary(string);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static void loadLibrary(String string) {
        Library.loadLibrary(string, true);
    }

    public static void loadLibrary(String string, boolean bl) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = System.getProperty("sun.arch.data.model");
        if (string7 == null) {
            string7 = System.getProperty("com.ibm.vm.bitmode");
        }
        if (string7 != null) {
            if ("32".equals(string7)) {
                throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
            }
            if ("64".equals(string7)) {
                // empty if block
            }
        }
        if (bl) {
            string6 = System.getProperty("swt.version");
            if (string6 == null) {
                string6 = "" + MAJOR_VERSION;
                if (MINOR_VERSION < 10) {
                    string6 = String.valueOf(string6) + "00";
                } else if (MINOR_VERSION < 100) {
                    string6 = String.valueOf(string6) + "0";
                }
                string6 = String.valueOf(string6) + MINOR_VERSION;
                if (REVISION > 0) {
                    string6 = String.valueOf(string6) + "r" + REVISION;
                }
            }
            string5 = String.valueOf(string) + "-" + "win32" + "-" + string6;
            string4 = String.valueOf(string) + "-" + "win32";
            string3 = System.mapLibraryName(string5);
            string2 = System.mapLibraryName(string4);
        } else {
            string3 = string2 = string;
            string4 = string2;
            string5 = string2;
        }
        string6 = System.getProperty("swt.library.path");
        if (string6 != null) {
            if (Library.load(String.valueOf(string6 = new File(string6).getAbsolutePath()) + SEPARATOR + string3)) {
                return;
            }
            if (bl && Library.load(String.valueOf(string6) + SEPARATOR + string2)) {
                return;
            }
        }
        if (Library.load(string5)) {
            return;
        }
        if (bl && Library.load(string4)) {
            return;
        }
        if (string6 == null) {
            string6 = System.getProperty("java.io.tmpdir");
            if (Library.load(String.valueOf(string6 = new File(string6).getAbsolutePath()) + SEPARATOR + string3)) {
                return;
            }
            if (bl && Library.load(String.valueOf(string6) + SEPARATOR + string2)) {
                return;
            }
        }
        if (string6 != null) {
            if (Library.extract(String.valueOf(string6) + SEPARATOR + string3, string3)) {
                return;
            }
            if (bl && Library.extract(String.valueOf(string6) + SEPARATOR + string2, string2)) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + string5 + " or " + string4 + " in swt.library.path, java.library.path or the jar file");
    }
}

