/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCHITTESTINFO;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;
    static final long TabFolderProc;
    static final TCHAR TabFolderClass;
    static final int ID_UPDOWN = 1;

    static {
        TabFolderClass = new TCHAR(0, "SysTabControl32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, TabFolderClass, wNDCLASS);
        TabFolderProc = wNDCLASS.lpfnWndProc;
        long l = OS.GetModuleHandle(null);
        long l2 = OS.GetProcessHeap();
        wNDCLASS.hInstance = l;
        wNDCLASS.style &= 0xFFFFBFFC;
        int n = TabFolderClass.length() * TCHAR.sizeof;
        long l3 = OS.HeapAlloc(l2, 8, n);
        OS.MoveMemory(l3, TabFolderClass, n);
        wNDCLASS.lpszClassName = l3;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(l2, 0, l3);
    }

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(TabFolderProc, l, n, l2, l3);
    }

    static int checkStyle(int n) {
        if (OS.IsPPC && (n & 0x80) == 0) {
            n |= 0x400;
        }
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0L, rECT);
        int n3 = rECT.left - rECT.right;
        int n4 = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (n4 != 0) {
            OS.SendMessage(this.handle, 4874, (long)(n4 - 1), rECT2);
            n3 = Math.max(n3, rECT2.right - rECT.right);
        }
        RECT rECT3 = new RECT();
        OS.SetRect(rECT3, 0, 0, n3, point.y);
        OS.SendMessage(this.handle, 4904, 1L, rECT3);
        int n5 = this.getBorderWidth();
        rECT3.left -= n5;
        rECT3.right += n5;
        n3 = rECT3.right - rECT3.left;
        point.x = Math.max(n3, point.x);
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        OS.SendMessage(this.handle, 4904, 1L, rECT);
        int n5 = this.getBorderWidth();
        rECT.left -= n5;
        rECT.right += n5;
        rECT.top -= n5;
        rECT.bottom += n5;
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n6, n7);
    }

    void createItem(TabItem tabItem, int n) {
        TabItem[] tabItemArray;
        int n2 = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        if (n2 == this.items.length) {
            tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if (OS.SendMessage(this.handle, OS.TCM_INSERTITEM, (long)n, (TCITEM)(tabItemArray = new TCITEM())) == -1L) {
            this.error(14);
        }
        System.arraycopy(this.items, n, this.items, n + 1, n2 - n);
        this.items[n] = tabItem;
        if (n2 == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (OS.IsPPC) {
            OS.SendMessage(this.handle, 8199, 524L, 0L);
        }
        long l = OS.SendMessage(this.handle, 4909, 0L, 0L);
        OS.SendMessage(l, 1048, 0L, 32767L);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem tabItem) {
        int n = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] == tabItem) break;
            ++n2;
        }
        if (n2 == n) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (OS.SendMessage(this.handle, 4872, (long)n2, 0L) == 0L) {
            this.error(15);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n - n2);
        this.items[n] = null;
        if (n == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4867, 0L, 0L);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.items = new TabItem[4];
        }
        if (n > 0 && n2 == n3) {
            this.setSelection(Math.max(0, n3 - 1), true);
        }
    }

    void drawThemeBackground(long l, long l2, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        OS.MapWindowPoints(this.handle, l2, rECT2, 2);
        if (OS.IntersectRect(new RECT(), rECT2, rECT)) {
            OS.DrawThemeBackground(this.display.hTabTheme(), l, 10, 0, rECT2, null);
        }
    }

    Control findThemeControl() {
        return this;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.SendMessage(this.handle, 4904, 0L, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    public TabItem getItem(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TCHITTESTINFO tCHITTESTINFO = new TCHITTESTINFO();
        tCHITTESTINFO.x = point.x;
        tCHITTESTINFO.y = point.y;
        int n = (int)OS.SendMessage(this.handle, 4877, 0L, tCHITTESTINFO);
        if (n == -1) {
            return null;
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n = this.imageList.add(image);
            long l = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0L, l);
            return n;
        }
        int n = this.imageList.indexOf(image);
        if (n == -1) {
            n = this.imageList.add(image);
        } else {
            this.imageList.put(n, image);
        }
        return n;
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] == tabItem) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < controlArray.length) {
            SerializableCompatibility serializableCompatibility;
            Control control2 = controlArray[n5];
            int n6 = 0;
            int n7 = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
            while (n6 < n7) {
                if (this.items[n6].control == control2) break;
                ++n6;
            }
            if (n6 == n7) {
                serializableCompatibility = control2.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
            } else {
                serializableCompatibility = control2.computeSize(n, n2, bl);
                n3 = Math.max(n3, ((Point)serializableCompatibility).x);
                n4 = Math.max(n4, ((Point)serializableCompatibility).y);
            }
            ++n5;
        }
        return new Point(n3, n4);
    }

    boolean mnemonicHit(char c) {
        int n = 0;
        while (n < this.items.length) {
            TabItem tabItem = this.items[n];
            if (tabItem != null) {
                char c2 = this.findMnemonic(tabItem.getText());
                if (Character.toUpperCase(c) == Character.toUpperCase(c2) && this.forceFocus()) {
                    if (n != this.getSelectionIndex()) {
                        this.setSelection(n, true);
                    }
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = 0;
        while (n < this.items.length) {
            TabItem tabItem = this.items[n];
            if (tabItem != null) {
                char c2 = this.findMnemonic(tabItem.getText());
                if (Character.toUpperCase(c) == Character.toUpperCase(c2)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
            int n2 = 0;
            while (n2 < n) {
                TabItem tabItem = this.items[n2];
                if (tabItem != null && !tabItem.isDisposed()) {
                    tabItem.release(false);
                }
                ++n2;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4867, 0L, 0L);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
    }

    void removeControl(Control control2) {
        super.removeControl(control2);
        int n = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = this.items[n2];
            if (tabItem.control == control2) {
                tabItem.setControl(null);
            }
            ++n2;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            int n = tabItemArray.length - 1;
            while (n >= 0) {
                int n2 = this.indexOf(tabItemArray[n]);
                if (n2 != -1) {
                    this.setSelection(n2, false);
                }
                --n;
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
            int n = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
            if (n != -1) {
                TabItem tabItem = this.items[n];
                Control control2 = tabItem.control;
                if (control2 != null && !control2.isDisposed()) {
                    control2.setBounds(this.getClientArea());
                }
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 4868, 0L, 0L);
        if (n < 0 || n >= n2) {
            return;
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Widget widget;
        int n2 = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            TabItem tabItem = this.items[n2];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.SendMessage(this.handle, 4876, (long)n, 0L);
        int n3 = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (n3 != -1) {
            widget = this.items[n3];
            Control control2 = ((TabItem)widget).control;
            if (control2 != null && !control2.isDisposed()) {
                control2.setBounds(this.getClientArea());
                control2.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = widget;
                this.sendEvent(13, event);
            }
        }
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        int n = (int)nMTTDISPINFO.idFrom;
        long l = OS.SendMessage(this.handle, 4909, 0L, 0L);
        if (l == nMTTDISPINFO.hwndFrom) {
            TabItem tabItem;
            nMTTDISPINFO.uFlags = (this.style & 0x4000000) != 0 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (n >= 0 && n < this.items.length && (tabItem = this.items[n]) != null) {
                return tabItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    boolean traversePage(boolean bl) {
        int n = this.getItemCount();
        if (n <= 1) {
            return false;
        }
        int n2 = this.getSelectionIndex();
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3 = bl ? 1 : -1;
            n2 = (n2 + n3 + n) % n;
        }
        this.setSelection(n2, true);
        if (n2 == this.getSelectionIndex()) {
            OS.SendMessage(this.handle, 295, 3L, 0L);
            return true;
        }
        return false;
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x2000000;
        if ((this.style & 0x80000) != 0) {
            n |= 0x8000;
        }
        if ((this.style & 0x400) != 0) {
            n |= 2;
        }
        return n | 0x4000;
    }

    TCHAR windowClass() {
        return TabFolderClass;
    }

    long windowProc() {
        return TabFolderProc;
    }

    LRESULT WM_GETDLGCODE(long l, long l2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8192L);
    }

    LRESULT WM_MOUSELEAVE(long l, long l2) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            long l3 = OS.SendMessage(this.handle, 4909, 0L, 0L);
            if (OS.SendMessage(l3, OS.TTM_GETCURRENTTOOL, 0L, tOOLINFO) != 0L && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(l3, OS.TTM_DELTOOL, 0L, tOOLINFO);
                OS.SendMessage(l3, OS.TTM_ADDTOOL, 0L, tOOLINFO);
            }
        }
        return lRESULT;
    }

    LRESULT WM_NCHITTEST(long l, long l2) {
        LRESULT lRESULT = super.WM_NCHITTEST(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = OS.DefWindowProc(this.handle, 132, l, l2);
        return new LRESULT(l3);
    }

    LRESULT WM_NOTIFY(long l, long l2) {
        LRESULT lRESULT = super.WM_NOTIFY(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PARENTNOTIFY(long l, long l2) {
        LRESULT lRESULT = super.WM_PARENTNOTIFY(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return lRESULT;
        }
        if ((this.style & 0x4000000) != 0) {
            int n = OS.LOWORD(l);
            switch (n) {
                case 1: {
                    int n2 = OS.HIWORD(l);
                    long l3 = l2;
                    if (n2 != 1) break;
                    int n3 = OS.GetWindowLong(l3, -20);
                    OS.SetWindowLong(l3, -20, n3 | 0x400000);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(long l, long l2) {
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
        if (n != -1) {
            TabItem tabItem = this.items[n];
            Control control2 = tabItem.control;
            if (control2 != null && !control2.isDisposed()) {
                control2.setBounds(this.getClientArea());
            }
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, l2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 0x200) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0L, rECT);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        if (n3 == n5 && n4 == n6) {
            return lRESULT;
        }
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0L, rECT2);
        int n7 = -rECT2.right;
        int n8 = -rECT2.bottom;
        if (n3 != n5) {
            n = n5;
            if (n3 < n5) {
                n = n3;
            }
            OS.SetRect(rECT, n - n7, 0, n3, n4);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n4 != n6) {
            n = n6;
            if (n4 < n6) {
                n = n4;
            }
            if (n3 < n5) {
                n5 -= n7;
            }
            OS.SetRect(rECT, 0, n - n8, n5, n4);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        int n = nMHDR.code;
        switch (n) {
            case -552: 
            case -551: {
                Object object;
                TabItem tabItem = null;
                int n2 = (int)OS.SendMessage(this.handle, 4875, 0L, 0L);
                if (n2 != -1) {
                    tabItem = this.items[n2];
                }
                if (tabItem != null && (object = tabItem.control) != null && !((Widget)object).isDisposed()) {
                    if (n == -551) {
                        ((Control)object).setBounds(this.getClientArea());
                    }
                    ((Control)object).setVisible(n == -551);
                }
                if (n != -551) break;
                object = new Event();
                ((Event)object).item = tabItem;
                this.postEvent(13, (Event)object);
            }
        }
        return super.wmNotifyChild(nMHDR, l, l2);
    }
}

